/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import org.jsimpledb.util.AbstractNavigableSet;
import org.jsimpledb.util.BoundType;
import org.jsimpledb.util.Bounds;
import org.jsimpledb.util.EmptyNavigableSet;
import org.jsimpledb.util.NavigableSets;

abstract class AbstractMultiNavigableSet<E>
extends AbstractNavigableSet<E> {
    protected final ArrayList<? extends NavigableSet<E>> list;
    protected final Comparator<? super E> comparator;

    protected AbstractMultiNavigableSet(Iterable<? extends NavigableSet<E>> sets) {
        this(sets, AbstractMultiNavigableSet.getComparator(sets), new Bounds());
    }

    protected AbstractMultiNavigableSet(Iterable<? extends NavigableSet<E>> sets, Comparator<? super E> comparator, Bounds<E> bounds) {
        super(bounds);
        Preconditions.checkArgument((sets != null ? 1 : 0) != 0, (Object)"null sets");
        this.list = Lists.newArrayList(sets);
        Preconditions.checkArgument((!this.list.contains(null) ? 1 : 0) != 0, (Object)"null set");
        this.comparator = comparator;
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    private static <E> Comparator<? super E> getComparator(Iterable<? extends NavigableSet<E>> sets) {
        assert (Iterables.find(sets, (Predicate)Predicates.instanceOf(EmptyNavigableSet.class), null) == null);
        Iterator<NavigableSet<E>> i = sets.iterator();
        if (!i.hasNext()) {
            return null;
        }
        Comparator comparator = i.next().comparator();
        while (i.hasNext()) {
            Comparator comparator2 = i.next().comparator();
            if (comparator != null ? comparator.equals(comparator2) : comparator2 == null) continue;
            throw new IllegalArgumentException("sets have unequal comparators: " + comparator + " != " + comparator2);
        }
        return comparator;
    }

    @Override
    protected final NavigableSet<E> createSubSet(boolean reverse, Bounds<E> newBounds) {
        Comparator<E> nonNullComparator = NavigableSets.getComparator(this.comparator(), false);
        ArrayList<NavigableSet<NavigableSet<E>>> newList = new ArrayList<NavigableSet<NavigableSet<E>>>(this.list.size());
        for (NavigableSet<E> set : this.list) {
            block15: {
                int diff;
                block14: {
                    if (reverse) {
                        set = set.descendingSet();
                    }
                    if (newBounds.getLowerBoundType() != BoundType.NONE) {
                        try {
                            set = set.tailSet(newBounds.getLowerBound(), newBounds.getLowerBoundType().isInclusive());
                        }
                        catch (IllegalArgumentException e) {
                            if (set.isEmpty()) {
                                set = new EmptyNavigableSet<E>(this.comparator());
                            }
                            diff = nonNullComparator.compare(newBounds.getLowerBound(), set.last());
                            if (diff > 0) {
                                set = new EmptyNavigableSet<E>(this.comparator());
                            }
                            if (diff != 0) break block14;
                            if (newBounds.getLowerBoundType().isInclusive().booleanValue()) {
                                throw e;
                            }
                            set = new EmptyNavigableSet<E>(this.comparator());
                        }
                    }
                }
                if (newBounds.getUpperBoundType() != BoundType.NONE) {
                    try {
                        set = set.headSet(newBounds.getUpperBound(), newBounds.getUpperBoundType().isInclusive());
                    }
                    catch (IllegalArgumentException e) {
                        if (set.isEmpty()) {
                            set = new EmptyNavigableSet<E>(this.comparator());
                        }
                        diff = nonNullComparator.compare(newBounds.getUpperBound(), set.first());
                        if (diff < 0) {
                            set = new EmptyNavigableSet<E>(this.comparator());
                        }
                        if (diff != 0) break block15;
                        if (newBounds.getUpperBoundType().isInclusive().booleanValue()) {
                            throw e;
                        }
                        set = new EmptyNavigableSet<E>(this.comparator());
                    }
                }
            }
            newList.add(set);
        }
        return this.createSubSet(reverse, newBounds, newList);
    }

    protected abstract NavigableSet<E> createSubSet(boolean var1, Bounds<E> var2, List<NavigableSet<E>> var3);
}

