/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.util;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import org.jsimpledb.util.AbstractIterationSet;
import org.jsimpledb.util.BoundType;
import org.jsimpledb.util.Bounds;
import org.jsimpledb.util.NavigableSets;

public abstract class AbstractNavigableSet<E>
extends AbstractIterationSet<E>
implements NavigableSet<E> {
    protected final Bounds<E> bounds;

    protected AbstractNavigableSet() {
        this(new Bounds());
    }

    protected AbstractNavigableSet(Bounds<E> bounds) {
        Preconditions.checkArgument((bounds != null ? 1 : 0) != 0, (Object)"null bounds");
        this.bounds = bounds;
    }

    @Override
    public boolean remove(Object elem) {
        throw new UnsupportedOperationException("read-only set");
    }

    @Override
    public E first() {
        return this.iterator().next();
    }

    @Override
    public E last() {
        return this.descendingIterator().next();
    }

    @Override
    public E pollFirst() {
        Iterator i = this.iterator();
        if (!i.hasNext()) {
            return null;
        }
        Object value = i.next();
        i.remove();
        return value;
    }

    @Override
    public E pollLast() {
        return this.descendingSet().pollFirst();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.descendingSet().iterator();
    }

    @Override
    public E lower(E elem) {
        return this.searchBelow(elem, false);
    }

    @Override
    public E floor(E elem) {
        return this.searchBelow(elem, true);
    }

    @Override
    public E ceiling(E elem) {
        return this.searchAbove(elem, true);
    }

    @Override
    public E higher(E elem) {
        return this.searchAbove(elem, false);
    }

    @Override
    public NavigableSet<E> headSet(E newMaxElement) {
        return this.headSet(newMaxElement, false);
    }

    @Override
    public NavigableSet<E> tailSet(E newMinElement) {
        return this.tailSet(newMinElement, true);
    }

    @Override
    public NavigableSet<E> subSet(E newMinElement, E newMaxElement) {
        return this.subSet(newMinElement, true, newMaxElement, false);
    }

    @Override
    public NavigableSet<E> descendingSet() {
        return this.createSubSet(true, this.bounds.reverse());
    }

    @Override
    public NavigableSet<E> headSet(E newMaxElement, boolean inclusive) {
        Bounds<E> newBounds = this.bounds.withUpperBound(newMaxElement, BoundType.of(inclusive));
        if (!this.bounds.isWithinBounds(this.comparator(), newBounds)) {
            throw new IllegalArgumentException("upper bound " + newMaxElement + " is out of bounds: " + this.bounds);
        }
        return this.createSubSet(false, newBounds);
    }

    @Override
    public NavigableSet<E> tailSet(E newMinElement, boolean inclusive) {
        Bounds<E> newBounds = this.bounds.withLowerBound(newMinElement, BoundType.of(inclusive));
        if (!this.bounds.isWithinBounds(this.comparator(), newBounds)) {
            throw new IllegalArgumentException("lower bound " + newMinElement + " is out of bounds: " + this.bounds);
        }
        return this.createSubSet(false, newBounds);
    }

    @Override
    public NavigableSet<E> subSet(E newMinElement, boolean minInclusive, E newMaxElement, boolean maxInclusive) {
        Bounds<E> newBounds = new Bounds<E>(newMinElement, BoundType.of(minInclusive), newMaxElement, BoundType.of(maxInclusive));
        if (!this.bounds.isWithinBounds(this.comparator(), newBounds)) {
            throw new IllegalArgumentException("new bound(s) " + newBounds + " are out of bounds: " + this.bounds);
        }
        return this.createSubSet(false, newBounds);
    }

    @Override
    public Spliterator<E> spliterator() {
        return new Spliterators.AbstractSpliterator<E>(Long.MAX_VALUE, 21){
            private final Iterator<E> iterator;
            {
                this.iterator = AbstractNavigableSet.this.iterator();
            }

            @Override
            public boolean tryAdvance(Consumer<? super E> action) {
                if (!this.iterator.hasNext()) {
                    return false;
                }
                action.accept(this.iterator.next());
                return true;
            }

            @Override
            public Comparator<? super E> getComparator() {
                return AbstractNavigableSet.this.comparator();
            }
        };
    }

    protected E searchBelow(E elem, boolean inclusive) {
        if (!this.isWithinLowerBound(elem)) {
            return null;
        }
        AbstractNavigableSet subSet = this.isWithinUpperBound(elem) ? this.headSet(elem, inclusive) : this;
        try {
            return subSet.last();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    protected E searchAbove(E elem, boolean inclusive) {
        if (!this.isWithinUpperBound(elem)) {
            return null;
        }
        AbstractNavigableSet subSet = this.isWithinLowerBound(elem) ? this.tailSet(elem, inclusive) : this;
        try {
            return subSet.first();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    protected Comparator<? super E> getComparator(boolean reversed) {
        return NavigableSets.getComparator(this.comparator(), reversed);
    }

    protected abstract NavigableSet<E> createSubSet(boolean var1, Bounds<E> var2);

    protected boolean isWithinLowerBound(E elem) {
        return this.bounds.isWithinLowerBound(this.comparator(), elem);
    }

    protected boolean isWithinUpperBound(E elem) {
        return this.bounds.isWithinUpperBound(this.comparator(), elem);
    }
}

