/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.util;

import java.util.Arrays;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public abstract class AbstractXMLStreaming {
    protected AbstractXMLStreaming() {
    }

    protected boolean expect(XMLStreamReader reader, boolean closingOK, QName ... names) throws XMLStreamException {
        block5: {
            int eventType;
            do {
                if (!reader.hasNext()) {
                    throw new XMLStreamException("unexpected end of input", reader.getLocation());
                }
                eventType = reader.next();
                if (eventType == 1) break block5;
            } while (eventType != 2);
            if (!closingOK) {
                throw new XMLStreamException("expected " + this.description(names) + " but found closing <" + reader.getName() + "> tag instead", reader.getLocation());
            }
            return false;
        }
        if (names.length == 0) {
            throw new XMLStreamException("expected closing tag but found opening <" + reader.getName() + "> tag instead", reader.getLocation());
        }
        if (!Arrays.asList(names).contains(reader.getName())) {
            throw new XMLStreamException("expected " + this.description(names) + " but found <" + reader.getName() + "> instead", reader.getLocation());
        }
        return true;
    }

    protected void expectClose(XMLStreamReader reader) throws XMLStreamException {
        this.expect(reader, true, new QName[0]);
    }

    private String description(QName[] names) {
        switch (names.length) {
            case 0: {
                return "closing tag";
            }
            case 1: {
                return "opening <" + names[0] + "> tag";
            }
        }
        StringBuilder buf = new StringBuilder();
        for (QName name : names) {
            if (buf.length() == 0) {
                buf.append("one of ");
            } else {
                buf.append(", ");
            }
            buf.append('<').append(name).append('>');
        }
        return buf.toString();
    }

    protected void writeElement(XMLStreamWriter writer, QName element, String content) throws XMLStreamException {
        writer.writeStartElement(element.getNamespaceURI(), element.getLocalPart());
        writer.writeCharacters(content);
        writer.writeEndElement();
    }

    protected String getAttr(XMLStreamReader reader, QName name, boolean required) throws XMLStreamException {
        String value = reader.getAttributeValue(name.getNamespaceURI(), name.getLocalPart());
        if (value == null && required) {
            throw new XMLStreamException("<" + reader.getName().getLocalPart() + "> element is missing required \"" + name + "\" attribute", reader.getLocation());
        }
        return value;
    }

    protected String getAttr(XMLStreamReader reader, QName name) throws XMLStreamException {
        return this.getAttr(reader, name, true);
    }

    protected Integer getIntAttr(XMLStreamReader reader, QName name, boolean required) throws XMLStreamException {
        String text = this.getAttr(reader, name, required);
        if (text == null) {
            return null;
        }
        try {
            return Integer.parseInt(text, 10);
        }
        catch (NumberFormatException e) {
            throw new XMLStreamException("<" + reader.getName().getLocalPart() + "> element attribute \"" + name + "\" value `" + text + "' is invalid: not a valid value", reader.getLocation(), e);
        }
    }

    protected Long getLongAttr(XMLStreamReader reader, QName name, boolean required) throws XMLStreamException {
        String text = this.getAttr(reader, name, required);
        if (text == null) {
            return null;
        }
        try {
            return Long.parseLong(text, 10);
        }
        catch (NumberFormatException e) {
            throw new XMLStreamException("<" + reader.getName().getLocalPart() + "> element attribute \"" + name + "\" value `" + text + "' is invalid: not a valid long value", reader.getLocation(), e);
        }
    }

    protected int getIntAttr(XMLStreamReader reader, QName name) throws XMLStreamException {
        return this.getIntAttr(reader, name, true);
    }

    protected Boolean getBooleanAttr(XMLStreamReader reader, QName name, boolean required) throws XMLStreamException {
        String text = this.getAttr(reader, name, required);
        if (text == null) {
            return null;
        }
        switch (text) {
            case "true": {
                return true;
            }
            case "false": {
                return false;
            }
        }
        throw new XMLStreamException("<" + reader.getName().getLocalPart() + "> element attribute \"" + name + "\" value `" + text + "' is invalid: expected either \"true\" or \"false\"", reader.getLocation());
    }

    protected boolean getBooleanAttr(XMLStreamReader reader, QName name) throws XMLStreamException {
        return this.getBooleanAttr(reader, name, true);
    }
}

