/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.util;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.Objects;
import org.jsimpledb.util.BoundType;

public class Bounds<T> {
    private final T lowerBound;
    private final T upperBound;
    private final BoundType lowerBoundType;
    private final BoundType upperBoundType;

    public Bounds() {
        this(null, BoundType.NONE, null, BoundType.NONE);
    }

    public Bounds(T bound, BoundType boundType, boolean upper) {
        this((upper ? null : (T)bound), upper ? BoundType.NONE : boundType, (upper ? bound : null), upper ? boundType : BoundType.NONE);
    }

    public Bounds(T lowerBound, T upperBound) {
        this(lowerBound, BoundType.INCLUSIVE, upperBound, BoundType.EXCLUSIVE);
    }

    public Bounds(T lowerBound, BoundType lowerBoundType, T upperBound, BoundType upperBoundType) {
        Preconditions.checkArgument((lowerBoundType != null ? 1 : 0) != 0, (Object)"null lowerBoundType");
        Preconditions.checkArgument((upperBoundType != null ? 1 : 0) != 0, (Object)"null upperBoundType");
        this.lowerBound = lowerBoundType != BoundType.NONE ? lowerBound : null;
        this.upperBound = upperBoundType != BoundType.NONE ? upperBound : null;
        this.lowerBoundType = lowerBoundType;
        this.upperBoundType = upperBoundType;
    }

    public T getLowerBound() {
        return this.lowerBound;
    }

    public T getUpperBound() {
        return this.upperBound;
    }

    public BoundType getLowerBoundType() {
        return this.lowerBoundType;
    }

    public BoundType getUpperBoundType() {
        return this.upperBoundType;
    }

    public Bounds<T> reverse() {
        return new Bounds<T>(this.upperBound, this.upperBoundType, this.lowerBound, this.lowerBoundType);
    }

    public Bounds<T> withLowerBound(T newLowerBound, BoundType newLowerBoundType) {
        return new Bounds<T>(newLowerBound, newLowerBoundType, this.upperBound, this.upperBoundType);
    }

    public Bounds<T> withUpperBound(T newUpperBound, BoundType newUpperBoundType) {
        return new Bounds<T>(this.lowerBound, this.lowerBoundType, newUpperBound, newUpperBoundType);
    }

    public Bounds<T> withoutLowerBound() {
        return new Bounds<Object>(null, BoundType.NONE, this.upperBound, this.upperBoundType);
    }

    public Bounds<T> withoutUpperBound() {
        return new Bounds<Object>(this.lowerBound, this.lowerBoundType, null, BoundType.NONE);
    }

    public boolean isWithinLowerBound(Comparator<? super T> comparator, T value) {
        return this.isWithinBound(comparator, value, true, false);
    }

    public boolean isWithinUpperBound(Comparator<? super T> comparator, T value) {
        return this.isWithinBound(comparator, value, true, true);
    }

    public boolean isWithinBounds(Comparator<? super T> comparator, T value) {
        return this.isWithinLowerBound(comparator, value) && this.isWithinUpperBound(comparator, value);
    }

    public boolean isWithinBounds(Comparator<? super T> comparator, Bounds<? extends T> newBounds) {
        Preconditions.checkArgument((newBounds != null ? 1 : 0) != 0, (Object)"null newBounds");
        if (newBounds.lowerBoundType != BoundType.NONE && !this.isWithinBound(comparator, newBounds.lowerBound, newBounds.lowerBoundType.isInclusive(), false)) {
            return false;
        }
        return newBounds.upperBoundType == BoundType.NONE || this.isWithinBound(comparator, newBounds.upperBound, newBounds.upperBoundType.isInclusive(), true);
    }

    private boolean isWithinBound(Comparator<? super T> comparator, T value, boolean requireInclusive, boolean upper) {
        int diff;
        BoundType boundType;
        BoundType boundType2 = boundType = upper ? this.upperBoundType : this.lowerBoundType;
        if (boundType == BoundType.NONE) {
            return true;
        }
        T bound = upper ? this.upperBound : this.lowerBound;
        int n = diff = comparator != null ? comparator.compare(value, bound) : ((Comparable)value).compareTo(bound);
        if (diff == 0) {
            return boundType == BoundType.INCLUSIVE || !requireInclusive;
        }
        return upper ? diff < 0 : diff > 0;
    }

    public String toString() {
        return "Bounds[lower(" + (Object)((Object)this.lowerBoundType) + ")=" + this.lowerBound + ",upper(" + (Object)((Object)this.upperBoundType) + ")=" + this.upperBound + "]";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Bounds that = (Bounds)obj;
        return this.lowerBoundType == that.lowerBoundType && this.upperBoundType == that.upperBoundType && Objects.equals(this.lowerBound, that.lowerBound) && Objects.equals(this.upperBound, that.upperBound);
    }

    public int hashCode() {
        return this.lowerBoundType.hashCode() ^ this.upperBoundType.hashCode() ^ Objects.hashCode(this.lowerBound) ^ Objects.hashCode(this.upperBound);
    }
}

