/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.util;

import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Comparator;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteWriter;

public final class ByteUtil {
    public static final byte[] EMPTY = new byte[0];
    public static final Comparator<byte[]> COMPARATOR = ByteUtil::compare;
    public static final Converter<byte[], String> STRING_CONVERTER = new Converter<byte[], String>(){

        public String doForward(byte[] b) {
            return b != null ? ByteUtil.toString(b) : null;
        }

        public byte[] doBackward(String s) {
            return s != null ? ByteUtil.parse(s) : null;
        }
    };

    private ByteUtil() {
    }

    public static int compare(byte[] b1, byte[] b2) {
        int sharedLength = Math.min(b1.length, b2.length);
        if (b1 == b2) {
            return 0;
        }
        for (int i = 0; i < sharedLength; ++i) {
            int v1 = b1[i] & 0xFF;
            int v2 = b2[i] & 0xFF;
            if (v1 < v2) {
                return -1;
            }
            if (v1 <= v2) continue;
            return 1;
        }
        if (b1.length < b2.length) {
            return -1;
        }
        if (b1.length > b2.length) {
            return 1;
        }
        return 0;
    }

    public static byte[] min(byte[] b1, byte[] b2) {
        return ByteUtil.compare(b1, b2) <= 0 ? b1 : b2;
    }

    public static byte[] max(byte[] b1, byte[] b2) {
        return ByteUtil.compare(b1, b2) >= 0 ? b1 : b2;
    }

    public static boolean isPrefixOf(byte[] prefix, byte[] value) {
        if (prefix.length > value.length) {
            return false;
        }
        for (int i = 0; i < prefix.length; ++i) {
            if (value[i] == prefix[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] getNextKey(byte[] key) {
        byte[] nextKey = new byte[key.length + 1];
        System.arraycopy(key, 0, nextKey, 0, key.length);
        return nextKey;
    }

    public static boolean isConsecutive(byte[] key1, byte[] key2) {
        if (key2.length != key1.length + 1) {
            return false;
        }
        if (key2[key1.length] != 0) {
            return false;
        }
        for (int i = 0; i < key1.length; ++i) {
            if (key1[i] == key2[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] getKeyAfterPrefix(byte[] prefix) {
        int len = prefix.length;
        if (len == 0) {
            throw new IllegalArgumentException("empty prefix");
        }
        while (len > 0 && prefix[len - 1] == -1) {
            --len;
        }
        if (len <= 0) {
            throw new IllegalArgumentException("prefix contains only 0xff bytes");
        }
        byte[] buf = new byte[len];
        System.arraycopy(prefix, 0, buf, 0, len);
        int n = len - 1;
        buf[n] = (byte)(buf[n] + 1);
        return buf;
    }

    public static String toString(byte[] buf) {
        if (buf == null) {
            return "null";
        }
        char[] result = new char[buf.length * 2];
        int off = 0;
        for (byte value : buf) {
            result[off++] = Character.forDigit(value >> 4 & 0xF, 16);
            result[off++] = Character.forDigit(value & 0xF, 16);
        }
        return new String(result);
    }

    public static byte[] parse(String text) {
        if ((text.length() & 1) != 0) {
            throw new IllegalArgumentException("byte array has an odd number of digits");
        }
        byte[] array = new byte[text.length() / 2];
        int pos = 0;
        int i = 0;
        while (pos < text.length()) {
            int nib2;
            int nib1;
            if ((nib1 = Character.digit(text.charAt(pos++), 16)) == -1) {
                throw new IllegalArgumentException("invalid hex digit `" + text.charAt(pos - 1) + "'");
            }
            if ((nib2 = Character.digit(text.charAt(pos++), 16)) == -1) {
                throw new IllegalArgumentException("invalid hex digit `" + text.charAt(pos - 1) + "'");
            }
            array[i] = (byte)(nib1 << 4 | nib2);
            ++i;
        }
        return array;
    }

    public static int readInt(ByteReader reader) {
        return reader.readByte() << 24 | reader.readByte() << 16 | reader.readByte() << 8 | reader.readByte();
    }

    public static void writeInt(ByteWriter writer, int value) {
        writer.writeByte(value >> 24);
        writer.writeByte(value >> 16);
        writer.writeByte(value >> 8);
        writer.writeByte(value);
    }

    public static long readLong(ByteReader reader) {
        return (long)reader.readByte() << 56 | (long)reader.readByte() << 48 | (long)reader.readByte() << 40 | (long)reader.readByte() << 32 | (long)reader.readByte() << 24 | (long)reader.readByte() << 16 | (long)reader.readByte() << 8 | (long)reader.readByte();
    }

    public static void writeLong(ByteWriter writer, long value) {
        writer.writeByte((int)(value >> 56));
        writer.writeByte((int)(value >> 48));
        writer.writeByte((int)(value >> 40));
        writer.writeByte((int)(value >> 32));
        writer.writeByte((int)(value >> 24));
        writer.writeByte((int)(value >> 16));
        writer.writeByte((int)(value >> 8));
        writer.writeByte((int)value);
    }

    public static double toDouble(byte[] key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"null key");
        long bits = 0x3FF0000000000000L;
        int length6 = Math.min(key.length, 6);
        for (int i = 0; i < length6; ++i) {
            bits |= (long)(key[i] & 0xFF) << 44 - i * 8;
        }
        if (key.length > 6) {
            bits |= (long)(key[6] & 0xFF) >> 4;
        }
        return Double.longBitsToDouble(bits) - 1.0;
    }

    public static byte[] fromDouble(double value) {
        int length;
        Preconditions.checkArgument((Double.isFinite(value) && value >= 0.0 && value < 1.0 ? 1 : 0) != 0, (Object)"invalid value");
        long bits = Double.doubleToLongBits(value + 1.0);
        byte[] bytes = new byte[]{(byte)(bits >> 44), (byte)(bits >> 36), (byte)(bits >> 28), (byte)(bits >> 20), (byte)(bits >> 12), (byte)(bits >> 4), (byte)(bits << 4)};
        for (length = bytes.length; length > 0 && bytes[length - 1] == 0; --length) {
        }
        switch (length) {
            case 0: {
                return EMPTY;
            }
            case 7: {
                return bytes;
            }
        }
        return Arrays.copyOfRange(bytes, 0, length);
    }
}

