/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.util;

import org.jsimpledb.util.ByteReader;

public class ByteWriter {
    private static final int DEFAULT_CAPACITY = 20;
    byte[] buf;
    int len;

    public ByteWriter() {
        this(20);
    }

    public ByteWriter(int capacity) {
        if (capacity < 0) {
            throw new IndexOutOfBoundsException("capacity = " + capacity);
        }
        this.buf = new byte[capacity];
    }

    public byte[] getBytes() {
        if (this.buf.length == this.len) {
            return this.buf;
        }
        byte[] result = new byte[this.len];
        System.arraycopy(this.buf, 0, result, 0, this.len);
        return result;
    }

    public byte[] getBytes(int off) {
        return this.getBytes(off, this.len - off);
    }

    public byte[] getBytes(int off, int len) {
        if (off == 0 && len == this.len && this.buf.length == this.len) {
            return this.buf;
        }
        if (off < 0 || off > this.len || len < 0 || off + len < 0 || off + len > this.len) {
            throw new IndexOutOfBoundsException("total length = " + this.len + ", off = " + off + ", len = " + len);
        }
        byte[] result = new byte[len];
        System.arraycopy(this.buf, off, result, 0, len);
        return result;
    }

    public void writeByte(int value) {
        byte b = (byte)value;
        this.makeRoom(1);
        this.buf[this.len++] = b;
    }

    public void write(ByteReader reader) {
        this.write(reader.buf, reader.off, reader.max - reader.off);
    }

    public void write(byte[] data) {
        this.makeRoom(data.length);
        System.arraycopy(data, 0, this.buf, this.len, data.length);
        this.len += data.length;
    }

    public void write(byte[] data, int off, int len) {
        if (off < 0 || off > data.length || len < 0 || off + len < 0 || off + len > data.length) {
            throw new IndexOutOfBoundsException("data.length = " + data.length + ", off = " + off + ", len = " + len);
        }
        this.makeRoom(len);
        System.arraycopy(data, off, this.buf, this.len, len);
        this.len += len;
    }

    public int getLength() {
        return this.len;
    }

    public int mark() {
        return this.len;
    }

    public void reset(int mark) {
        if (mark < 0 || mark > this.len) {
            throw new IndexOutOfBoundsException();
        }
        this.len = mark;
    }

    void makeRoom(int amount) {
        if (this.len + amount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.len + amount, this.buf.length * 2 + 8)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.len);
            this.buf = newbuf;
        }
    }
}

