/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.util;

import com.google.common.collect.ForwardingIterator;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jsimpledb.util.CloseableIterator;

class CloseableIteratorWrapper<E>
extends ForwardingIterator<E>
implements CloseableIterator<E> {
    private final Iterator<E> iterator;
    private final AutoCloseable resource;
    private final AtomicBoolean closed = new AtomicBoolean();

    CloseableIteratorWrapper(Iterator<E> iterator, AutoCloseable resource) {
        this.iterator = iterator;
        this.resource = resource;
    }

    protected Iterator<E> delegate() {
        return this.iterator;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true) && this.resource != null) {
            try {
                this.resource.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

