/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.util;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseableTracker
implements Closeable {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private HashSet<HolderRef> unclosedItems;
    private ReferenceQueue<Object> queue;

    public CloseableTracker() {
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object holder, Closeable item) {
        HolderRef holderRef = new HolderRef(holder, item, this.queue);
        CloseableTracker closeableTracker = this;
        synchronized (closeableTracker) {
            this.unclosedItems.add(holderRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poll() {
        HolderRef ref;
        ArrayList<HolderRef> closedItems = null;
        while ((ref = (HolderRef)this.queue.poll()) != null) {
            if (closedItems == null) {
                closedItems = new ArrayList<HolderRef>();
            }
            Closeable item = ref.getItem();
            try {
                item.close();
            }
            catch (Throwable e) {
                this.exceptionDuringClose(item, e);
            }
            closedItems.add(ref);
        }
        if (closedItems != null) {
            CloseableTracker closeableTracker = this;
            synchronized (closeableTracker) {
                this.unclosedItems.removeAll(closedItems);
            }
        }
    }

    @Override
    public void close() {
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        HashSet<HolderRef> itemsToClose;
        CloseableTracker closeableTracker = this;
        synchronized (closeableTracker) {
            itemsToClose = this.unclosedItems;
            this.unclosedItems = new HashSet();
            this.queue = new ReferenceQueue();
        }
        if (itemsToClose == null) {
            return;
        }
        for (HolderRef ref : itemsToClose) {
            Closeable item = ref.getItem();
            try {
                item.close();
            }
            catch (Throwable e) {
                this.exceptionDuringClose(item, e);
            }
        }
    }

    protected void exceptionDuringClose(Closeable item, Throwable e) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("caught exception attempting to close " + item + " (ignoring)", e);
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private static class HolderRef
    extends WeakReference<Object> {
        private final Closeable item;

        HolderRef(Object holder, Closeable item, ReferenceQueue<Object> queue) {
            super(holder, queue);
            Preconditions.checkArgument((holder != null ? 1 : 0) != 0, (Object)"null holder");
            Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"null item");
            this.item = item;
        }

        public Closeable getItem() {
            return this.item;
        }
    }
}

