/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.util;

import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.jsimpledb.util.ConvertedSet;
import org.jsimpledb.util.MapEntryConverter;

class ConvertedEntrySet<K, V, WK, WV>
extends ConvertedSet<Map.Entry<K, V>, Map.Entry<WK, WV>> {
    private final Map<WK, WV> map;
    private final Converter<K, WK> keyConverter;
    private final Converter<V, WV> valueConverter;

    ConvertedEntrySet(Map<WK, WV> map, Converter<K, WK> keyConverter, Converter<V, WV> valueConverter) {
        super(map.entrySet(), new MapEntryConverter<K, V, WK, WV>(keyConverter, valueConverter));
        Preconditions.checkArgument((keyConverter != null ? 1 : 0) != 0, (Object)"null keyConverter");
        Preconditions.checkArgument((valueConverter != null ? 1 : 0) != 0, (Object)"null valueConverter");
        this.map = map;
        this.keyConverter = keyConverter;
        this.valueConverter = valueConverter;
    }

    public Converter<K, WK> getKeyConverter() {
        return this.keyConverter;
    }

    public Converter<V, WV> getValueConverter() {
        return this.valueConverter;
    }

    @Override
    public boolean contains(Object obj) {
        WV wvalue;
        if (!(obj instanceof Map.Entry)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)obj;
        Object key = entry.getKey();
        Object wkey = null;
        if (key != null) {
            try {
                wkey = this.keyConverter.convert(key);
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        if ((wvalue = this.map.get(wkey)) == null && !this.map.containsKey(wkey)) {
            return false;
        }
        Object value = this.valueConverter.reverse().convert(wvalue);
        return value != null ? value.equals(entry.getValue()) : entry.getValue() == null;
    }

    @Override
    public boolean add(Map.Entry<K, V> entry) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object obj) {
        WV wvalue;
        if (!(obj instanceof Map.Entry)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)obj;
        Object key = entry.getKey();
        Object wkey = null;
        if (key != null) {
            try {
                wkey = this.keyConverter.convert(key);
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        if ((wvalue = this.map.get(wkey)) == null && !this.map.containsKey(wkey)) {
            return false;
        }
        Object value = this.valueConverter.reverse().convert(wvalue);
        if (value != null ? value.equals(entry.getValue()) : entry.getValue() == null) {
            this.map.remove(wkey);
            return true;
        }
        return false;
    }
}

