/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.util;

import com.google.common.base.Converter;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.stream.Collectors;
import org.jsimpledb.util.ConvertedSpliterator;

public class ConvertedList<E, W>
extends AbstractList<E> {
    private final List<W> list;
    private final Converter<E, W> converter;

    public ConvertedList(List<W> list, Converter<E, W> converter) {
        Preconditions.checkArgument((list != null ? 1 : 0) != 0, (Object)"null list");
        Preconditions.checkArgument((converter != null ? 1 : 0) != 0, (Object)"null converter");
        this.list = list;
        this.converter = converter;
    }

    public List<W> getWrappedList() {
        return this.list;
    }

    public Converter<E, W> getConverter() {
        return this.converter;
    }

    @Override
    public E get(int index) {
        W value = this.list.get(index);
        return (E)(value != null ? this.converter.reverse().convert(value) : null);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public E set(int index, E elem) {
        Object welem = elem != null ? this.converter.convert(elem) : null;
        Object prev = this.list.set(index, welem);
        return (E)(prev != null ? this.converter.reverse().convert(prev) : null);
    }

    @Override
    public void add(int index, E elem) {
        Object welem = elem != null ? this.converter.convert(elem) : null;
        this.list.add(index, welem);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> elems) {
        return this.list.addAll(index, elems.stream().map(elem -> elem != null ? this.converter.convert(elem) : null).collect(Collectors.toList()));
    }

    @Override
    public boolean contains(Object obj) {
        Object wobj = null;
        if (obj != null) {
            try {
                wobj = this.converter.convert(obj);
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        return this.list.contains(wobj);
    }

    @Override
    public int indexOf(Object obj) {
        Object wobj = null;
        if (obj != null) {
            try {
                wobj = this.converter.convert(obj);
            }
            catch (ClassCastException e) {
                return -1;
            }
        }
        return this.list.indexOf(wobj);
    }

    @Override
    public int lastIndexOf(Object obj) {
        Object wobj = null;
        if (obj != null) {
            try {
                wobj = this.converter.convert(obj);
            }
            catch (ClassCastException e) {
                return -1;
            }
        }
        return this.list.lastIndexOf(wobj);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public E remove(int index) {
        W welem = this.list.remove(index);
        return (E)(welem != null ? this.converter.reverse().convert(welem) : null);
    }

    @Override
    public Iterator<E> iterator() {
        return Iterators.transform(this.list.iterator(), (Function)this.converter.reverse());
    }

    @Override
    public Spliterator<E> spliterator() {
        return new ConvertedSpliterator(this.list.spliterator(), this.converter.reverse());
    }

    @Override
    public List<E> subList(int min, int max) {
        return new ConvertedList<E, W>(this.list.subList(min, max), this.converter);
    }

    @Override
    protected void removeRange(int min, int max) {
        this.list.subList(min, max).clear();
    }
}

