/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.util;

import com.google.common.base.Converter;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import org.jsimpledb.util.AbstractNavigableSet;
import org.jsimpledb.util.BoundType;
import org.jsimpledb.util.Bounds;
import org.jsimpledb.util.ConvertedComparator;
import org.jsimpledb.util.ConvertedSpliterator;

public class ConvertedNavigableSet<E, W>
extends AbstractNavigableSet<E> {
    private final NavigableSet<W> set;
    private final Converter<E, W> converter;

    public ConvertedNavigableSet(NavigableSet<W> set, Converter<E, W> converter) {
        this(set, converter, new Bounds());
    }

    ConvertedNavigableSet(NavigableSet<W> set, Converter<E, W> converter, Bounds<E> bounds) {
        super(bounds);
        Preconditions.checkArgument((set != null ? 1 : 0) != 0, (Object)"null set");
        Preconditions.checkArgument((converter != null ? 1 : 0) != 0, (Object)"null converter");
        this.set = set;
        this.converter = converter;
    }

    public NavigableSet<W> getWrappedNavigableSet() {
        return this.set;
    }

    public Converter<E, W> getConverter() {
        return this.converter;
    }

    @Override
    public Comparator<? super E> comparator() {
        return new ConvertedComparator(this.set.comparator(), this.converter);
    }

    @Override
    public boolean contains(Object obj) {
        Object wobj = null;
        if (obj != null) {
            try {
                wobj = this.converter.convert(obj);
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        return this.set.contains(wobj);
    }

    @Override
    public Iterator<E> iterator() {
        return Iterators.transform(this.set.iterator(), (Function)this.converter.reverse());
    }

    @Override
    public Spliterator<E> spliterator() {
        return new ConvertedSpliterator(this.set.spliterator(), this.converter.reverse());
    }

    @Override
    public boolean add(E obj) {
        return this.set.add(obj != null ? this.converter.convert(obj) : null);
    }

    @Override
    public boolean remove(Object obj) {
        Object wobj = null;
        if (obj != null) {
            try {
                wobj = this.converter.convert(obj);
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        return this.set.remove(wobj);
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    protected E searchBelow(E elem, boolean inclusive) {
        try {
            return super.searchBelow(elem, inclusive);
        }
        catch (IllegalArgumentException e) {
            Object last;
            try {
                last = this.last();
            }
            catch (NoSuchElementException e2) {
                return null;
            }
            return (E)(this.getComparator(false).compare(elem, last) > 0 ? last : null);
        }
    }

    @Override
    protected E searchAbove(E elem, boolean inclusive) {
        try {
            return super.searchAbove(elem, inclusive);
        }
        catch (IllegalArgumentException e) {
            Object first;
            try {
                first = this.first();
            }
            catch (NoSuchElementException e2) {
                return null;
            }
            return (E)(this.getComparator(false).compare(elem, first) < 0 ? first : null);
        }
    }

    @Override
    protected NavigableSet<E> createSubSet(boolean reverse, Bounds<E> newBounds) {
        NavigableSet<Object> subSet;
        E lower = newBounds.getLowerBound();
        E upper = newBounds.getUpperBound();
        Object wlower = newBounds.getLowerBoundType() != BoundType.NONE && lower != null ? this.converter.convert(lower) : null;
        Object wupper = newBounds.getUpperBoundType() != BoundType.NONE && upper != null ? this.converter.convert(upper) : null;
        NavigableSet<W> navigableSet = subSet = reverse ? this.set.descendingSet() : this.set;
        if (newBounds.getLowerBoundType() != BoundType.NONE && newBounds.getUpperBoundType() != BoundType.NONE) {
            subSet = subSet.subSet(wlower, newBounds.getLowerBoundType().isInclusive(), wupper, newBounds.getUpperBoundType().isInclusive());
        } else if (newBounds.getLowerBoundType() != BoundType.NONE) {
            subSet = subSet.tailSet(wlower, newBounds.getLowerBoundType().isInclusive());
        } else if (newBounds.getUpperBoundType() != BoundType.NONE) {
            subSet = subSet.headSet(wupper, newBounds.getUpperBoundType().isInclusive());
        }
        return new ConvertedNavigableSet<E, W>(subSet, this.converter, newBounds);
    }
}

