/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.util;

import com.google.common.base.Converter;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import org.jsimpledb.util.AbstractIterationSet;
import org.jsimpledb.util.ConvertedSpliterator;

public class ConvertedSet<E, W>
extends AbstractIterationSet<E> {
    private final Set<W> set;
    private final Converter<E, W> converter;

    ConvertedSet(Set<W> set, Converter<E, W> converter) {
        Preconditions.checkArgument((set != null ? 1 : 0) != 0, (Object)"null set");
        Preconditions.checkArgument((converter != null ? 1 : 0) != 0, (Object)"null converter");
        this.set = set;
        this.converter = converter;
    }

    public Set<W> getWrappedSet() {
        return this.set;
    }

    public Converter<E, W> getConverter() {
        return this.converter;
    }

    @Override
    public boolean contains(Object obj) {
        Object wobj = null;
        if (obj != null) {
            try {
                wobj = this.converter.convert(obj);
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        return this.set.contains(wobj);
    }

    @Override
    public Iterator<E> iterator() {
        return Iterators.transform(this.set.iterator(), (Function)this.converter.reverse());
    }

    @Override
    public Spliterator<E> spliterator() {
        return new ConvertedSpliterator(this.set.spliterator(), this.converter.reverse());
    }

    @Override
    public boolean add(E obj) {
        return this.set.add(obj != null ? this.converter.convert(obj) : null);
    }

    @Override
    public boolean remove(Object obj) {
        Object wobj = null;
        if (obj != null) {
            try {
                wobj = this.converter.convert(obj);
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        return this.set.remove(wobj);
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public int size() {
        return this.set.size();
    }
}

