/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.util;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;

public class Diffs
extends LinkedHashMap<String, Diffs> {
    public Diffs() {
    }

    public Diffs(Diffs other) {
        super(other);
    }

    public void add(String description) {
        this.add(description, null);
    }

    public void add(String description, Diffs diffs) {
        Preconditions.checkArgument((description != null ? 1 : 0) != 0, (Object)"null description");
        this.put(description, diffs);
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "no differences";
        }
        StringBuilder buf = new StringBuilder();
        this.format(buf, 0);
        return buf.toString().trim();
    }

    private void format(StringBuilder buf, int depth) {
        String indent = this.getIndent(depth);
        for (Map.Entry entry : this.entrySet()) {
            String description = (String)entry.getKey();
            buf.append(String.format("%s%s%n", indent, description.trim().replaceAll("(\\r?\\n)", "$1" + Matcher.quoteReplacement(indent))));
            Diffs child = (Diffs)entry.getValue();
            if (child == null) continue;
            child.format(buf, depth + 1);
        }
    }

    private String getIndent(int depth) {
        char[] indent = new char[depth * 2];
        Arrays.fill(indent, ' ');
        return new String(indent) + "-> ";
    }
}

