/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.util;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import org.jsimpledb.util.AbstractNavigableSet;
import org.jsimpledb.util.BoundType;
import org.jsimpledb.util.Bounds;

public class ImmutableNavigableSet<E>
extends AbstractNavigableSet<E> {
    private final E[] elems;
    private final int minIndex;
    private final int maxIndex;
    private final Comparator<? super E> comparator;
    private final Comparator<? super E> actualComparator;

    public ImmutableNavigableSet(NavigableSet<E> source) {
        this(source.toArray(), source.comparator());
    }

    public ImmutableNavigableSet(E[] elems, Comparator<? super E> comparator) {
        this(new Bounds(), elems, 0, elems.length, comparator);
    }

    ImmutableNavigableSet(E[] elems, int minIndex, int maxIndex, Comparator<? super E> comparator) {
        this(new Bounds(), elems, minIndex, maxIndex, comparator);
    }

    ImmutableNavigableSet(Bounds<E> bounds, E[] elems, int minIndex, int maxIndex, Comparator<? super E> comparator) {
        super(bounds);
        Preconditions.checkArgument((elems != null ? 1 : 0) != 0);
        Preconditions.checkArgument((minIndex >= 0 && maxIndex >= minIndex ? 1 : 0) != 0);
        Preconditions.checkArgument((elems.length >= maxIndex ? 1 : 0) != 0);
        this.elems = elems;
        this.minIndex = minIndex;
        this.maxIndex = maxIndex;
        this.comparator = comparator;
        this.actualComparator = this.comparator != null ? this.comparator : Comparator.naturalOrder();
        for (int i = minIndex + 1; i < maxIndex; ++i) {
            assert (this.actualComparator.compare(this.elems[i - 1], this.elems[i]) < 0);
        }
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public boolean isEmpty() {
        return this.minIndex == this.maxIndex;
    }

    @Override
    public int size() {
        return this.maxIndex - this.minIndex;
    }

    @Override
    public boolean contains(Object obj) {
        return this.find(obj) >= 0;
    }

    @Override
    public E first() {
        return this.elems[this.checkIndex(this.minIndex)];
    }

    @Override
    public E last() {
        return this.elems[this.checkIndex(this.maxIndex - 1)];
    }

    @Override
    public E pollFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E pollLast() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E lower(E elem) {
        return this.findElem(elem, -1, -1);
    }

    @Override
    public E floor(E elem) {
        return this.findElem(elem, -1, 0);
    }

    @Override
    public E higher(E elem) {
        return this.findElem(elem, 0, 1);
    }

    @Override
    public E ceiling(E elem) {
        return this.findElem(elem, 0, 0);
    }

    @Override
    public Iterator<E> iterator() {
        return new Iter(this.minIndex, this.maxIndex, 1);
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new Iter(this.maxIndex - 1, this.minIndex - 1, -1);
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this.elems, this.minIndex, this.maxIndex, 5140);
    }

    @Override
    protected ImmutableNavigableSet<E> createSubSet(boolean reverse, Bounds<E> newBounds) {
        int newMaxIndex;
        int newMinIndex;
        E minBound = reverse ? newBounds.getUpperBound() : newBounds.getLowerBound();
        E maxBound = reverse ? newBounds.getLowerBound() : newBounds.getUpperBound();
        BoundType minBoundType = reverse ? newBounds.getUpperBoundType() : newBounds.getLowerBoundType();
        BoundType maxBoundType = reverse ? newBounds.getLowerBoundType() : newBounds.getUpperBoundType();
        switch (minBoundType) {
            case INCLUSIVE: {
                newMinIndex = this.findNearby(minBound, 0, 0);
                break;
            }
            case EXCLUSIVE: {
                newMinIndex = this.findNearby(minBound, 0, 1);
                break;
            }
            case NONE: {
                newMinIndex = this.minIndex;
                break;
            }
            default: {
                throw new RuntimeException("internal error");
            }
        }
        switch (maxBoundType) {
            case INCLUSIVE: {
                newMaxIndex = this.findNearby(maxBound, 0, 1);
                break;
            }
            case EXCLUSIVE: {
                newMaxIndex = this.findNearby(maxBound, 0, 0);
                break;
            }
            case NONE: {
                newMaxIndex = this.maxIndex;
                break;
            }
            default: {
                throw new RuntimeException("internal error");
            }
        }
        if (reverse) {
            int newSize = newMaxIndex - newMinIndex;
            return new ImmutableNavigableSet<E>(newBounds, ImmutableNavigableSet.reverseArray(Arrays.copyOfRange(this.elems, newMinIndex, newMaxIndex)), 0, newSize, ImmutableNavigableSet.reversedComparator(this.comparator));
        }
        return new ImmutableNavigableSet<E>(newBounds, this.elems, newMinIndex, newMaxIndex, this.comparator);
    }

    static <T> T[] reverseArray(T[] array) {
        int i = 0;
        for (int j = array.length - 1; i < j; ++i, --j) {
            T temp = array[i];
            array[i] = array[j];
            array[j] = temp;
        }
        return array;
    }

    static <T> Comparator<T> reversedComparator(Comparator<T> comparator) {
        return comparator == null ? Comparator.reverseOrder() : (comparator.equals(Comparator.reverseOrder()) ? null : comparator.reversed());
    }

    private E findElem(Object elem, int notFoundOffset, int foundOffset) {
        int index = this.findNearby(elem, notFoundOffset, foundOffset);
        if (index < this.minIndex || index >= this.maxIndex) {
            return null;
        }
        return this.elems[index];
    }

    private int findNearby(Object elem, int notFoundOffset, int foundOffset) {
        int index = this.find(elem);
        return index < 0 ? ~index + notFoundOffset : index + foundOffset;
    }

    private int find(Object elem) {
        return Arrays.binarySearch(this.elems, this.minIndex, this.maxIndex, elem, this.actualComparator);
    }

    private int checkIndex(int index) {
        if (index < this.minIndex || index >= this.maxIndex) {
            throw new NoSuchElementException();
        }
        return index;
    }

    private class Iter
    implements Iterator<E> {
        private final int stopIndex;
        private final int step;
        private int index;

        Iter(int startIndex, int stopIndex, int step) {
            this.index = startIndex;
            this.stopIndex = stopIndex;
            this.step = step;
        }

        @Override
        public boolean hasNext() {
            return this.index != this.stopIndex;
        }

        @Override
        public E next() {
            if (this.index == this.stopIndex) {
                throw new NoSuchElementException();
            }
            Object elem = ImmutableNavigableSet.this.elems[this.index];
            this.index += this.step;
            return elem;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

