/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.util;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jsimpledb.util.AbstractXMLStreaming;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImplementationsReader
extends AbstractXMLStreaming {
    private static final QName CLASS_ATTR = new QName("class");
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ArrayList<Object[]> constructorParamList = new ArrayList();
    private final QName outerTag;
    private final QName innerTag;

    public ImplementationsReader(String name) {
        Preconditions.checkArgument((name != null && name.length() > 0 ? 1 : 0) != 0, (Object)"null/empty name");
        this.outerTag = new QName(name + "-implementations");
        this.innerTag = new QName(name + "-implementation");
        this.constructorParamList.add(new Object[0]);
    }

    public void setConstructorParameterLists(List<Object[]> list) {
        Preconditions.checkArgument((list != null ? 1 : 0) != 0, (Object)"null list");
        Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0, (Object)"empty list");
        for (Object[] params : list) {
            Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"null params");
        }
        this.constructorParamList.clear();
        this.constructorParamList.addAll(list);
    }

    public List<String> parse(InputStream input) throws XMLStreamException {
        Preconditions.checkArgument((input != null ? 1 : 0) != 0, (Object)"null input");
        ArrayList<String> list = new ArrayList<String>();
        XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(input);
        this.expect(reader, false, this.outerTag);
        while (this.expect(reader, true, this.innerTag)) {
            list.add(this.getAttr(reader, CLASS_ATTR, true));
            this.expectClose(reader);
        }
        return list;
    }

    public <T> List<T> findImplementations(Class<T> type, String resource) {
        Enumeration<URL> enumeration;
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"null type");
        Preconditions.checkArgument((resource != null ? 1 : 0) != 0, (Object)"null resource");
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            enumeration = loader.getResources(resource);
        }
        catch (IOException e) {
            this.log.error("error finding resources `" + resource + "'", (Throwable)e);
            return Collections.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>();
        while (enumeration.hasMoreElements()) {
            URL url = enumeration.nextElement();
            if (this.log.isDebugEnabled()) {
                this.log.debug("reading key/value implementations from " + url);
            }
            try {
                InputStream input = url.openStream();
                Throwable throwable = null;
                try {
                    block18: for (String className : this.parse(input)) {
                        Class<T> klass;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("loading " + type.getSimpleName() + " implementation " + className);
                        }
                        try {
                            klass = Class.forName(className, false, loader).asSubclass(type);
                        }
                        catch (Exception e) {
                            this.log.error("error loading class `" + className + "' specified in " + url, (Throwable)e);
                            continue;
                        }
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("instantiating " + type.getSimpleName() + " implementation " + className);
                        }
                        Constructor<?>[] constructors = klass.getConstructors();
                        Throwable error = null;
                        for (Object[] params : this.constructorParamList) {
                            for (Constructor<?> constructor : constructors) {
                                Class<?>[] ptypes = constructor.getParameterTypes();
                                if (ptypes.length != params.length) continue;
                                for (int i = 0; i < ptypes.length; ++i) {
                                    if ((!ptypes[i].isPrimitive() || params[i] != null) && TypeToken.of(ptypes[i]).wrap().getRawType().isInstance(params[i])) continue;
                                }
                                try {
                                    list.add(type.cast(constructor.newInstance(params)));
                                    continue block18;
                                }
                                catch (Exception e) {
                                    error = e instanceof InvocationTargetException ? e.getCause() : e;
                                }
                            }
                        }
                        if (error == null) {
                            this.log.error("error instantiating class `" + className + "' specified in " + url + ": no suitable constructor found");
                            continue;
                        }
                        this.log.error("error instantiating class `" + className + "' specified in " + url, error);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (input == null) continue;
                    if (throwable != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    input.close();
                }
            }
            catch (IOException | XMLStreamException e) {
                this.log.error("error reading " + url, (Throwable)e);
            }
        }
        return list;
    }
}

