/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.util;

import java.util.Comparator;
import java.util.List;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import org.jsimpledb.util.AbstractMultiNavigableSet;
import org.jsimpledb.util.Bounds;

class IntersectionNavigableSet<E>
extends AbstractMultiNavigableSet<E> {
    IntersectionNavigableSet(Iterable<? extends NavigableSet<E>> sets) {
        super(sets);
    }

    protected IntersectionNavigableSet(Iterable<? extends NavigableSet<E>> sets, Comparator<? super E> comparator, Bounds<E> bounds) {
        super(sets, comparator, bounds);
    }

    @Override
    protected NavigableSet<E> createSubSet(boolean reverse, Bounds<E> newBounds, List<NavigableSet<E>> newList) {
        Comparator newComparator = this.getComparator(reverse);
        return new IntersectionNavigableSet<E>(newList, newComparator, this.bounds);
    }

    @Override
    public boolean contains(Object obj) {
        for (NavigableSet set : this.list) {
            if (set.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public java.util.Iterator<E> iterator() {
        return new Iterator();
    }

    private class Iterator
    implements java.util.Iterator<E> {
        private final Comparator<? super E> comparator;
        private boolean firstTime;
        private boolean finished;
        private boolean haveNext;
        private E next;

        private Iterator() {
            this.comparator = IntersectionNavigableSet.this.getComparator(false);
            this.firstTime = true;
            this.finished = IntersectionNavigableSet.this.list.isEmpty();
        }

        @Override
        public boolean hasNext() {
            return this.haveNext || this.advance();
        }

        @Override
        public E next() {
            if (!this.haveNext && !this.advance()) {
                throw new NoSuchElementException();
            }
            this.haveNext = false;
            return this.next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private boolean advance() {
            Object candidate;
            if (this.finished) {
                return false;
            }
            assert (!this.haveNext);
            NavigableSet firstSet = (NavigableSet)IntersectionNavigableSet.this.list.get(0);
            if (this.firstTime) {
                this.firstTime = false;
                try {
                    candidate = firstSet.first();
                }
                catch (NoSuchElementException e) {
                    this.finished = true;
                    return false;
                }
            } else {
                candidate = firstSet.higher(this.next);
                if (candidate == null && !this.hasNullInTailSet(firstSet, this.next, false)) {
                    this.finished = true;
                    return false;
                }
            }
            int maxMatches = IntersectionNavigableSet.this.list.size();
            int numMatches = 1;
            int i = 1;
            while (numMatches < maxMatches) {
                NavigableSet set = (NavigableSet)IntersectionNavigableSet.this.list.get(i);
                Object ceiling = set.ceiling(candidate);
                if (ceiling == null && !this.hasNullInTailSet(set, candidate, true)) {
                    this.finished = true;
                    return false;
                }
                int diff = this.comparator.compare(ceiling, candidate);
                if (diff == 0) {
                    ++numMatches;
                } else if (diff > 0) {
                    numMatches = 1;
                    candidate = ceiling;
                } else {
                    throw new IllegalStateException("internal error: NavigableSet.ceiling() returned a mis-ordered element " + ceiling + " < " + candidate);
                }
                i = (i + 1) % maxMatches;
            }
            this.next = candidate;
            this.haveNext = true;
            return true;
        }

        private boolean hasNullInTailSet(NavigableSet<E> set, E elem, boolean inclusive) {
            NavigableSet tailSet;
            try {
                tailSet = set.tailSet(elem, inclusive);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            return !tailSet.isEmpty();
        }
    }
}

