/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.util;

import com.google.common.base.Converter;
import java.util.Map;
import org.jsimpledb.util.ConvertedMapEntry;

class MapEntryConverter<K, V, WK, WV>
extends Converter<Map.Entry<K, V>, Map.Entry<WK, WV>> {
    private final Converter<K, WK> keyConverter;
    private final Converter<V, WV> valueConverter;

    MapEntryConverter(Converter<K, WK> keyConverter, Converter<V, WV> valueConverter) {
        this.keyConverter = keyConverter;
        this.valueConverter = valueConverter;
    }

    protected Map.Entry<WK, WV> doForward(Map.Entry<K, V> entry) {
        if (entry == null) {
            return null;
        }
        return new ConvertedMapEntry(this.keyConverter.reverse(), this.valueConverter.reverse(), entry);
    }

    protected Map.Entry<K, V> doBackward(Map.Entry<WK, WV> wentry) {
        if (wentry == null) {
            return null;
        }
        return new ConvertedMapEntry<K, V, WK, WV>(this.keyConverter, this.valueConverter, wentry);
    }
}

