/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.util;

import com.google.common.base.Preconditions;

public class MovingAverage {
    private final double alpha;
    private double average = Double.NaN;

    public MovingAverage(double alpha) {
        Preconditions.checkArgument((boolean)Double.isFinite(alpha));
        Preconditions.checkArgument((alpha >= 0.0 && alpha <= 1.0 ? 1 : 0) != 0);
        this.alpha = alpha;
    }

    public MovingAverage(double alpha, double initialValue) {
        this(alpha);
        this.add(initialValue);
    }

    public double get() {
        return this.average;
    }

    public void add(double value) {
        Preconditions.checkArgument((boolean)Double.isFinite(value));
        this.average = Double.isNaN(this.average) ? value : this.average + this.alpha * (value - this.average);
    }
}

