/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import java.util.function.Predicate;

public abstract class NavigableSetPager<E> {
    public static final int DEFAULT_PAGE_SIZE = 100;
    private int pageSize = 100;
    private boolean descending;
    private Predicate<? super E> filter;
    private Bound anchor;
    private Bound limit;
    private boolean backwards;
    private boolean dataBefore;
    private boolean dataAfter;

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        Preconditions.checkArgument((pageSize > 0 ? 1 : 0) != 0, (Object)"pageSize <= 0");
        this.pageSize = pageSize;
    }

    public boolean isDescending() {
        return this.descending;
    }

    public void setDescending(boolean descending) {
        if (this.descending != descending) {
            this.descending = descending;
            this.limit = null;
        }
    }

    public void setFilter(Predicate<? super E> filter) {
        this.filter = filter;
    }

    public boolean hasNextPage() {
        return this.backwards ? this.dataBefore : this.dataAfter;
    }

    public boolean hasPrevPage() {
        return this.backwards ? this.dataAfter : this.dataBefore;
    }

    public boolean nextPage() {
        return this.step(false);
    }

    public boolean prevPage() {
        return this.step(true);
    }

    private boolean step(boolean backwards) {
        if (!(backwards ^ this.backwards)) {
            if (this.limit == null) {
                return false;
            }
            this.anchor = this.limit;
        } else {
            if (this.anchor == null) {
                return false;
            }
            this.backwards = backwards;
        }
        this.limit = null;
        return true;
    }

    public void firstPage() {
        this.jump(false);
    }

    public void lastPage() {
        this.jump(true);
    }

    private void jump(boolean last) {
        this.anchor = null;
        this.limit = null;
        this.backwards = last;
        this.dataBefore = last;
        this.dataAfter = !last;
    }

    public void setCursor(E cursor) {
        this.anchor = new Bound(cursor);
        this.limit = null;
        this.backwards = false;
        this.dataBefore = true;
        this.dataAfter = true;
    }

    public List<E> readCurrentPage() {
        NavigableSet set = this.getNavigableSet();
        if (this.descending) {
            set = set.descendingSet();
        }
        NavigableSet anchorSet = this.anchor != null ? (this.backwards ? set.headSet(this.anchor.getValue(), false) : set.tailSet(this.anchor.getValue(), true)) : set;
        if (this.backwards) {
            anchorSet = anchorSet.descendingSet();
        }
        this.limit = null;
        List<E> page = new ArrayList<E>(this.pageSize);
        for (E item : anchorSet) {
            if (this.filter != null && !this.filter.test(item)) continue;
            if (this.backwards) {
                page.add(item);
            }
            if (page.size() >= this.pageSize) {
                this.limit = new Bound(item);
                break;
            }
            if (this.backwards) continue;
            page.add(item);
        }
        if (this.anchor != null && this.limit == null && page.isEmpty()) {
            this.anchor = null;
            this.backwards = !this.backwards;
            return this.readCurrentPage();
        }
        this.dataBefore = this.anchor != null ? (this.backwards ? !set.tailSet(this.anchor.getValue(), true).isEmpty() : !set.headSet(this.anchor.getValue(), false).isEmpty()) : false;
        this.dataAfter = this.limit != null ? (this.backwards ? !set.headSet(this.limit.getValue(), false).isEmpty() : true) : false;
        if (this.backwards) {
            page = Lists.reverse(page);
        }
        return page;
    }

    protected abstract NavigableSet<E> getNavigableSet();

    private class Bound {
        private final E value;

        Bound(E value) {
            this.value = value;
        }

        public E getValue() {
            return this.value;
        }
    }
}

