/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Comparator;
import java.util.NavigableSet;
import org.jsimpledb.util.DifferenceNavigableSet;
import org.jsimpledb.util.EmptyNavigableSet;
import org.jsimpledb.util.IntersectionNavigableSet;
import org.jsimpledb.util.SingletonNavigableSet;
import org.jsimpledb.util.UnionNavigableSet;

public final class NavigableSets {
    private NavigableSets() {
    }

    public static <E> NavigableSet<E> intersection(Iterable<? extends NavigableSet<E>> sets) {
        Preconditions.checkArgument((sets != null ? 1 : 0) != 0, (Object)"null sets");
        if (Iterables.find(sets, (Predicate)Predicates.instanceOf(EmptyNavigableSet.class), null) != null) {
            return new EmptyNavigableSet(null);
        }
        return new IntersectionNavigableSet(sets);
    }

    @SafeVarargs
    public static <E> NavigableSet<E> intersection(NavigableSet<E> ... sets) {
        Preconditions.checkArgument((sets != null ? 1 : 0) != 0, (Object)"null sets");
        return NavigableSets.intersection(Arrays.asList(sets));
    }

    @SafeVarargs
    public static <E> NavigableSet<E> union(NavigableSet<E> ... sets) {
        Preconditions.checkArgument((sets != null ? 1 : 0) != 0, (Object)"null sets");
        return NavigableSets.union(Arrays.asList(sets));
    }

    public static <E> NavigableSet<E> union(Iterable<? extends NavigableSet<E>> sets) {
        Preconditions.checkArgument((sets != null ? 1 : 0) != 0, (Object)"null sets");
        sets = Iterables.filter(sets, (Predicate)Predicates.not((Predicate)Predicates.instanceOf(EmptyNavigableSet.class)));
        if (!sets.iterator().hasNext()) {
            return new EmptyNavigableSet(null);
        }
        return new UnionNavigableSet(sets);
    }

    public static <E> NavigableSet<E> difference(NavigableSet<E> set1, NavigableSet<E> set2) {
        if (set1 instanceof EmptyNavigableSet || set2 instanceof EmptyNavigableSet) {
            return set1;
        }
        return new DifferenceNavigableSet<E>(set1, set2);
    }

    public static <E> NavigableSet<E> symmetricDifference(NavigableSet<E> set1, NavigableSet<E> set2) {
        if (set1 instanceof EmptyNavigableSet) {
            return set2;
        }
        if (set2 instanceof EmptyNavigableSet) {
            return set1;
        }
        return NavigableSets.difference(NavigableSets.union(set1, set2), NavigableSets.intersection(set1, set2));
    }

    public static <E> NavigableSet<E> singleton(E value) {
        return NavigableSets.singleton(null, value);
    }

    public static <E> NavigableSet<E> singleton(Comparator<? super E> comparator, E value) {
        return new SingletonNavigableSet<E>(comparator, value);
    }

    public static <E> NavigableSet<E> empty() {
        return NavigableSets.empty(null);
    }

    public static <E> NavigableSet<E> empty(Comparator<? super E> comparator) {
        return new EmptyNavigableSet<E>(comparator);
    }

    static <T> Comparator<T> getComparator(Comparator<T> comparator, boolean reversed) {
        if (comparator == null) {
            comparator = Comparator.naturalOrder();
        }
        return reversed ? comparator.reversed() : comparator;
    }
}

