/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.util;

import com.google.common.collect.Iterators;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import org.jsimpledb.util.AbstractNavigableSet;
import org.jsimpledb.util.Bounds;
import org.jsimpledb.util.EmptyNavigableSet;

class SingletonNavigableSet<E>
extends AbstractNavigableSet<E> {
    private final Comparator<? super E> comparator;
    private final E value;

    SingletonNavigableSet(Comparator<? super E> comparator, E value) {
        this(comparator, (E)value, new Bounds());
    }

    protected SingletonNavigableSet(Comparator<? super E> comparator, E value, Bounds<E> bounds) {
        super(bounds);
        this.comparator = comparator;
        if (comparator == null && !(value instanceof Comparable)) {
            throw new IllegalArgumentException("no Comparator provided but value type " + (value != null ? value.getClass().getName() : "null") + " does not implement Comparable");
        }
        this.value = value;
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public boolean contains(Object obj) {
        if (this.value == null) {
            return obj == null;
        }
        try {
            return this.comparator().compare(this.value, obj) == 0;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public Iterator<E> iterator() {
        return Iterators.singletonIterator(this.value);
    }

    @Override
    protected NavigableSet<E> createSubSet(boolean reverse, Bounds<E> newBounds) {
        Comparator newComparator = this.getComparator(reverse);
        return newBounds.isWithinBounds(newComparator, this.value) ? new SingletonNavigableSet(newComparator, this.value, newBounds) : new EmptyNavigableSet(newComparator, newBounds);
    }
}

