/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.util;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import org.jsimpledb.util.AbstractMultiNavigableSet;
import org.jsimpledb.util.Bounds;
import org.jsimpledb.util.UniqueIterator;

class UnionNavigableSet<E>
extends AbstractMultiNavigableSet<E> {
    UnionNavigableSet(Iterable<? extends NavigableSet<E>> sets) {
        super(sets);
    }

    protected UnionNavigableSet(Iterable<? extends NavigableSet<E>> sets, Comparator<? super E> comparator, Bounds<E> bounds) {
        super(sets, comparator, bounds);
    }

    @Override
    protected NavigableSet<E> createSubSet(boolean reverse, Bounds<E> newBounds, List<NavigableSet<E>> newList) {
        Comparator newComparator = this.getComparator(reverse);
        return new UnionNavigableSet<E>(newList, newComparator, newBounds);
    }

    @Override
    public boolean contains(Object obj) {
        for (NavigableSet set : this.list) {
            if (!set.contains(obj)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        Comparator comparator = this.getComparator(false);
        return new UniqueIterator(Iterators.mergeSorted((Iterable)Lists.transform((List)this.list, NavigableSet::iterator), comparator), comparator);
    }
}

