/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.bdb;

import com.google.common.base.Preconditions;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.io.Closeable;
import java.util.NoSuchElementException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jsimpledb.kv.AbstractKVStore;
import org.jsimpledb.kv.CloseableKVStore;
import org.jsimpledb.kv.KVPair;
import org.jsimpledb.kv.KVTransaction;
import org.jsimpledb.kv.KVTransactionException;
import org.jsimpledb.kv.RetryTransactionException;
import org.jsimpledb.kv.StaleTransactionException;
import org.jsimpledb.kv.bdb.BerkeleyKVDatabase;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.CloseableIterator;
import org.jsimpledb.util.CloseableTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BerkeleyKVTransaction
extends AbstractKVStore
implements KVTransaction,
Closeable {
    private static final byte[] MIN_KEY = ByteUtil.EMPTY;
    private static final byte[] MAX_KEY = new byte[]{-1};
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final BerkeleyKVDatabase store;
    private final Transaction tx;
    private final CursorConfig cursorConfig = new CursorConfig().setNonSticky(true);
    private final CloseableTracker cursorTracker = new CloseableTracker();
    private boolean readOnly;
    private boolean closed;

    BerkeleyKVTransaction(BerkeleyKVDatabase store, Transaction tx) {
        assert (store != null);
        assert (tx != null);
        this.store = store;
        this.tx = tx;
    }

    public BerkeleyKVDatabase getKVDatabase() {
        return this.store;
    }

    public Transaction getTransaction() {
        return this.tx;
    }

    public void setTimeout(long timeout) {
        Preconditions.checkArgument((timeout >= 0L ? 1 : 0) != 0, (Object)"timeout < 0");
        this.tx.setLockTimeout(timeout, TimeUnit.MILLISECONDS);
    }

    public Future<Void> watchKey(byte[] key) {
        throw new UnsupportedOperationException();
    }

    public synchronized byte[] get(byte[] key) {
        if (this.closed) {
            throw new StaleTransactionException((KVTransaction)this);
        }
        this.cursorTracker.poll();
        Preconditions.checkArgument((key.length == 0 || key[0] != -1 ? 1 : 0) != 0, (Object)"key starts with 0xff");
        DatabaseEntry value = new DatabaseEntry();
        try {
            OperationStatus status = this.store.getDatabase().get(this.tx, new DatabaseEntry(key), value, null);
            switch (status) {
                case SUCCESS: {
                    return value.getData();
                }
                case NOTFOUND: {
                    return null;
                }
            }
            throw this.weirdStatus(status, "get");
        }
        catch (DatabaseException e) {
            throw this.wrapException(e);
        }
    }

    public KVPair getAtLeast(byte[] minKey, byte[] maxKey) {
        try (CursorIterator i = this.getRange(minKey, maxKey, false);){
            KVPair kVPair = i.hasNext() ? i.next() : null;
            return kVPair;
        }
    }

    public KVPair getAtMost(byte[] maxKey, byte[] minKey) {
        try (CursorIterator i = this.getRange(minKey, maxKey, true);){
            KVPair kVPair = i.hasNext() ? i.next() : null;
            return kVPair;
        }
    }

    public synchronized CursorIterator getRange(byte[] minKey, byte[] maxKey, boolean reverse) {
        Cursor cursor;
        if (this.closed) {
            throw new StaleTransactionException((KVTransaction)this);
        }
        this.cursorTracker.poll();
        try {
            cursor = this.store.getDatabase().openCursor(this.tx, this.cursorConfig);
        }
        catch (DatabaseException e) {
            throw this.wrapException(e);
        }
        return new CursorIterator(cursor, minKey, maxKey, reverse);
    }

    public synchronized void put(byte[] key, byte[] value) {
        if (this.closed) {
            throw new StaleTransactionException((KVTransaction)this);
        }
        this.cursorTracker.poll();
        Preconditions.checkArgument((key.length == 0 || key[0] != -1 ? 1 : 0) != 0, (Object)"key starts with 0xff");
        try {
            this.store.getDatabase().put(this.tx, new DatabaseEntry(key), new DatabaseEntry(value));
        }
        catch (DatabaseException e) {
            throw this.wrapException(e);
        }
    }

    public synchronized void remove(byte[] key) {
        if (this.closed) {
            throw new StaleTransactionException((KVTransaction)this);
        }
        this.cursorTracker.poll();
        Preconditions.checkArgument((key.length == 0 || key[0] != -1 ? 1 : 0) != 0, (Object)"key starts with 0xff");
        try {
            this.store.getDatabase().delete(this.tx, new DatabaseEntry(key));
        }
        catch (DatabaseException e) {
            throw this.wrapException(e);
        }
    }

    public synchronized boolean isReadOnly() {
        return this.readOnly;
    }

    public synchronized void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public synchronized void commit() {
        if (this.closed) {
            throw new StaleTransactionException((KVTransaction)this);
        }
        this.close();
        try {
            if (this.readOnly) {
                this.tx.abort();
            } else {
                this.tx.commit();
            }
        }
        catch (DatabaseException e) {
            throw this.wrapException(e);
        }
    }

    public synchronized void rollback() {
        if (this.closed) {
            return;
        }
        this.close();
        try {
            this.tx.abort();
        }
        catch (DatabaseException e) {
            throw this.wrapException(e);
        }
    }

    public CloseableKVStore mutableSnapshot() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.cursorTracker.close();
        this.store.removeTransaction(this);
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.closed) {
                this.log.warn(this + " leaked without commit() or rollback()");
            }
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public KVTransactionException wrapException(DatabaseException e) {
        if (e instanceof LockConflictException) {
            return new RetryTransactionException((KVTransaction)this, (Throwable)e);
        }
        return new KVTransactionException((KVTransaction)this, (Throwable)e);
    }

    private KVTransactionException weirdStatus(OperationStatus status, String methodName) {
        return new KVTransactionException((KVTransaction)this, "unexpected status " + status + " from " + methodName + "()");
    }

    public final class CursorIterator
    implements CloseableIterator<KVPair> {
        private final Cursor cursor;
        private final byte[] minKey;
        private final byte[] maxKey;
        private final boolean reverse;
        private KVPair nextPair;
        private byte[] removeKey;
        private boolean canRemoveWithCursor;
        private boolean completed;
        private boolean initialized;

        CursorIterator(Cursor cursor, byte[] minKey, byte[] maxKey, boolean reverse) {
            assert (Thread.holdsLock(BerkeleyKVTransaction.this));
            assert (cursor != null);
            Preconditions.checkArgument((minKey == null || maxKey == null || ByteUtil.compare((byte[])minKey, (byte[])maxKey) <= 0 ? 1 : 0) != 0, (Object)"minKey > maxKey");
            this.cursor = cursor;
            this.minKey = minKey != null ? ByteUtil.min((byte[])minKey, (byte[])MAX_KEY) : MIN_KEY;
            this.maxKey = maxKey != null ? ByteUtil.min((byte[])maxKey, (byte[])MAX_KEY) : MAX_KEY;
            this.reverse = reverse;
            BerkeleyKVTransaction.this.cursorTracker.add((Object)this, (Closeable)this.cursor);
        }

        public synchronized boolean hasNext() {
            return this.findNext();
        }

        public synchronized KVPair next() {
            if (!this.findNext()) {
                throw new NoSuchElementException();
            }
            assert (this.nextPair != null);
            KVPair result = this.nextPair;
            this.removeKey = (byte[])result.getKey().clone();
            this.canRemoveWithCursor = true;
            this.nextPair = null;
            return result;
        }

        public synchronized void remove() {
            if (BerkeleyKVTransaction.this.closed) {
                throw new StaleTransactionException((KVTransaction)BerkeleyKVTransaction.this);
            }
            if (this.removeKey == null) {
                throw new IllegalStateException();
            }
            try {
                OperationStatus status = this.canRemoveWithCursor ? this.cursor.delete() : this.cursor.getDatabase().delete(BerkeleyKVTransaction.this.tx, new DatabaseEntry(this.removeKey));
                switch (status) {
                    case SUCCESS: 
                    case KEYEMPTY: {
                        break;
                    }
                    default: {
                        throw BerkeleyKVTransaction.this.weirdStatus(status, "delete");
                    }
                }
            }
            catch (DatabaseException e) {
                throw BerkeleyKVTransaction.this.wrapException(e);
            }
            this.removeKey = null;
        }

        public void close() {
            try {
                this.cursor.close();
            }
            catch (Throwable e) {
                BerkeleyKVTransaction.this.log.debug("caught exception closing iterator cursor (ignoring)", e);
            }
        }

        private boolean findNext() {
            assert (Thread.holdsLock(this));
            if (BerkeleyKVTransaction.this.closed) {
                throw new StaleTransactionException((KVTransaction)BerkeleyKVTransaction.this);
            }
            if (!this.initialized) {
                this.initialize();
            }
            assert (this.initialized);
            if (this.nextPair != null) {
                return true;
            }
            if (this.completed) {
                return false;
            }
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry value = new DatabaseEntry();
            this.canRemoveWithCursor = false;
            try {
                OperationStatus status = this.reverse ? this.cursor.getPrev(key, value, null) : this.cursor.getNext(key, value, null);
                switch (status) {
                    case SUCCESS: {
                        byte[] keyData = key.getData();
                        if (this.reverse ? ByteUtil.compare((byte[])keyData, (byte[])this.minKey) >= 0 : ByteUtil.compare((byte[])keyData, (byte[])this.maxKey) < 0) {
                            this.nextPair = new KVPair(keyData, value.getData());
                            return true;
                        }
                    }
                    case NOTFOUND: {
                        this.completed = true;
                        return false;
                    }
                }
                throw BerkeleyKVTransaction.this.weirdStatus(status, this.reverse ? "getPrev" : "getNext");
            }
            catch (DatabaseException e) {
                throw BerkeleyKVTransaction.this.wrapException(e);
            }
        }

        private void initialize() {
            assert (Thread.holdsLock(this));
            assert (!this.initialized);
            assert (!this.completed);
            assert (this.nextPair == null);
            if (this.reverse) {
                try {
                    OperationStatus status = this.cursor.getSearchKey(new DatabaseEntry(this.maxKey), new DatabaseEntry(), null);
                    switch (status) {
                        case SUCCESS: 
                        case NOTFOUND: {
                            break;
                        }
                        default: {
                            throw BerkeleyKVTransaction.this.weirdStatus(status, "getSearchKey");
                        }
                    }
                }
                catch (DatabaseException e) {
                    throw BerkeleyKVTransaction.this.wrapException(e);
                }
            }
            if (this.minKey.length > 0) {
                DatabaseEntry key = new DatabaseEntry(this.minKey);
                DatabaseEntry value = new DatabaseEntry();
                try {
                    OperationStatus status = this.cursor.getSearchKeyRange(key, value, null);
                    switch (status) {
                        case SUCCESS: {
                            byte[] keyData = key.getData();
                            if (ByteUtil.compare((byte[])keyData, (byte[])this.maxKey) < 0) {
                                this.nextPair = new KVPair(keyData, value.getData());
                                break;
                            }
                        }
                        case NOTFOUND: {
                            this.completed = true;
                            break;
                        }
                        default: {
                            throw BerkeleyKVTransaction.this.weirdStatus(status, "getSearchKeyRange");
                        }
                    }
                }
                catch (DatabaseException e) {
                    throw BerkeleyKVTransaction.this.wrapException(e);
                }
            }
            this.initialized = true;
        }
    }
}

