/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.cleaner.CleanerStatDefinition;
import com.sleepycat.je.dbi.DbiStatDefinition;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.evictor.EvictorStatDefinition;
import com.sleepycat.je.evictor.OffHeapStatDefinition;
import com.sleepycat.je.incomp.INCompStatDefinition;
import com.sleepycat.je.latch.LatchStatDefinition;
import com.sleepycat.je.log.LogStatDefinition;
import com.sleepycat.je.recovery.CheckpointStatDefinition;
import com.sleepycat.je.txn.LockStatDefinition;
import com.sleepycat.je.utilint.StatGroup;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class EnvironmentStats
implements Serializable {
    private static final long serialVersionUID = 1734048134L;
    private StatGroup incompStats = new StatGroup("Node Compression", "Removal and compression of internal btree nodes.");
    private StatGroup cacheStats = new StatGroup("Cache", "Current size, allocations, and eviction activity.");
    private StatGroup offHeapStats = new StatGroup("OffHeap", "Off-heap cache usage and eviction activity.");
    private StatGroup ckptStats = new StatGroup("Checkpoints", "Frequency and extent of checkpointing activity.");
    private StatGroup cleanerStats = new StatGroup("Cleaning", "Frequency and extent of log file cleaning activity.");
    private StatGroup logStats = new StatGroup("I/O", "Log file opens, fsyncs, reads, writes, cache misses.");
    private StatGroup lockStats = new StatGroup("Locks", "Locks held by data operations, latching contention on lock table.");
    private StatGroup envImplStats = new StatGroup("Environment", "General environment wide statistics.");
    private StatGroup throughputStats = new StatGroup("Op", "Thoughput statistics for JE calls.");

    public Collection<StatGroup> getStatGroups() {
        return Arrays.asList(this.cacheStats, this.offHeapStats, this.ckptStats, this.cleanerStats, this.logStats, this.lockStats, this.envImplStats, this.incompStats, this.throughputStats);
    }

    public Map<String, StatGroup> getStatGroupsMap() {
        HashMap<String, StatGroup> map = new HashMap<String, StatGroup>();
        map.put(this.cacheStats.getName(), this.cacheStats);
        map.put(this.offHeapStats.getName(), this.offHeapStats);
        map.put(this.ckptStats.getName(), this.ckptStats);
        map.put(this.cleanerStats.getName(), this.cleanerStats);
        map.put(this.logStats.getName(), this.logStats);
        map.put(this.lockStats.getName(), this.lockStats);
        map.put(this.envImplStats.getName(), this.envImplStats);
        map.put(this.incompStats.getName(), this.incompStats);
        map.put(this.throughputStats.getName(), this.throughputStats);
        return map;
    }

    public void setStatGroup(StatGroup sg) {
        if (sg.getName().equals("Node Compression")) {
            this.incompStats = sg;
        } else if (sg.getName().equals("Cache")) {
            this.cacheStats = sg;
        } else if (sg.getName().equals("OffHeap")) {
            this.offHeapStats = sg;
        } else if (sg.getName().equals("Checkpoints")) {
            this.ckptStats = sg;
        } else if (sg.getName().equals("Cleaning")) {
            this.cleanerStats = sg;
        } else if (sg.getName().equals("I/O")) {
            this.logStats = sg;
        } else if (sg.getName().equals("Locks")) {
            this.lockStats = sg;
        } else if (sg.getName().equals("Environment")) {
            this.envImplStats = sg;
        } else if (sg.getName().equals("Op")) {
            this.throughputStats = sg;
        } else {
            throw EnvironmentFailureException.unexpectedState("Invalid stat group name in setStatGroup " + sg.getName());
        }
    }

    public static String[] getStatGroupTitles() {
        return new String[]{"I/O", "Cache", "Cleaning", "Node Compression", "Checkpoints", "Environment", "Locks"};
    }

    public void setINCompStats(StatGroup stats) {
        this.incompStats = stats;
    }

    public void setCkptStats(StatGroup stats) {
        this.ckptStats = stats;
    }

    public void setCleanerStats(StatGroup stats) {
        this.cleanerStats = stats;
    }

    public void setLogStats(StatGroup stats) {
        this.logStats = stats;
    }

    public void setMBAndEvictorStats(StatGroup clonedMBStats, StatGroup clonedEvictorStats) {
        this.cacheStats = clonedEvictorStats;
        this.cacheStats.addAll(clonedMBStats);
    }

    public void setOffHeapStats(StatGroup stats) {
        this.offHeapStats = stats;
    }

    public void setLockStats(StatGroup stats) {
        this.lockStats = stats;
    }

    public void setEnvImplStats(StatGroup stats) {
        this.envImplStats = stats;
    }

    public long getCursorsBins() {
        return this.incompStats.getLong(INCompStatDefinition.INCOMP_CURSORS_BINS);
    }

    public long getEnvironmentCreationTime() {
        return this.envImplStats.getLong(DbiStatDefinition.ENVIMPL_CREATION_TIME);
    }

    public long getDbClosedBins() {
        return this.incompStats.getLong(INCompStatDefinition.INCOMP_DBCLOSED_BINS);
    }

    public long getInCompQueueSize() {
        return this.incompStats.getLong(INCompStatDefinition.INCOMP_QUEUE_SIZE);
    }

    public long getNonEmptyBins() {
        return this.incompStats.getLong(INCompStatDefinition.INCOMP_NON_EMPTY_BINS);
    }

    public long getProcessedBins() {
        return this.incompStats.getLong(INCompStatDefinition.INCOMP_PROCESSED_BINS);
    }

    public long getSplitBins() {
        return this.incompStats.getLong(INCompStatDefinition.INCOMP_SPLIT_BINS);
    }

    public long getLastCheckpointId() {
        return this.ckptStats.getLong(CheckpointStatDefinition.CKPT_LAST_CKPTID);
    }

    public long getNCheckpoints() {
        return this.ckptStats.getLong(CheckpointStatDefinition.CKPT_CHECKPOINTS);
    }

    public long getNFullINFlush() {
        return this.ckptStats.getLong(CheckpointStatDefinition.CKPT_FULL_IN_FLUSH);
    }

    public long getNFullBINFlush() {
        return this.ckptStats.getLong(CheckpointStatDefinition.CKPT_FULL_BIN_FLUSH);
    }

    public long getNDeltaINFlush() {
        return this.ckptStats.getLong(CheckpointStatDefinition.CKPT_DELTA_IN_FLUSH);
    }

    public long getLastCheckpointInterval() {
        return this.ckptStats.getLong(CheckpointStatDefinition.CKPT_LAST_CKPT_INTERVAL);
    }

    public long getLastCheckpointStart() {
        return this.ckptStats.getLong(CheckpointStatDefinition.CKPT_LAST_CKPT_START);
    }

    public long getLastCheckpointEnd() {
        return this.ckptStats.getLong(CheckpointStatDefinition.CKPT_LAST_CKPT_END);
    }

    public int getCleanerBacklog() {
        return this.cleanerStats.getInt(CleanerStatDefinition.CLEANER_BACKLOG);
    }

    public int getFileDeletionBacklog() {
        return this.cleanerStats.getInt(CleanerStatDefinition.CLEANER_FILE_DELETION_BACKLOG);
    }

    public int getLastKnownUtilization() {
        return this.cleanerStats.getInt(CleanerStatDefinition.CLEANER_LAST_KNOWN_UTILIZATION);
    }

    public float getLNSizeCorrectionFactor() {
        return 1.0f;
    }

    public float getCorrectedAvgLNSize() {
        return Float.NaN;
    }

    public float getEstimatedAvgLNSize() {
        return Float.NaN;
    }

    public long getNCleanerRuns() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_RUNS);
    }

    public long getNCleanerProbeRuns() {
        return 0L;
    }

    public long getNCleanerDeletions() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_DELETIONS);
    }

    public int getPendingLNQueueSize() {
        return this.cleanerStats.getInt(CleanerStatDefinition.CLEANER_PENDING_LN_QUEUE_SIZE);
    }

    public long getNCleanerDiskRead() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_DISK_READS);
    }

    public long getNCleanerEntriesRead() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_ENTRIES_READ);
    }

    public long getNINsObsolete() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_INS_OBSOLETE);
    }

    public long getNINsCleaned() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_INS_CLEANED);
    }

    public long getNINsDead() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_INS_DEAD);
    }

    public long getNINsMigrated() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_INS_MIGRATED);
    }

    public long getNBINDeltasObsolete() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_BIN_DELTAS_OBSOLETE);
    }

    public long getNBINDeltasCleaned() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_BIN_DELTAS_CLEANED);
    }

    public long getNBINDeltasDead() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_BIN_DELTAS_DEAD);
    }

    public long getNBINDeltasMigrated() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_BIN_DELTAS_MIGRATED);
    }

    public long getNLNsObsolete() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_LNS_OBSOLETE);
    }

    public long getNLNsCleaned() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_LNS_CLEANED);
    }

    public long getNLNsDead() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_LNS_DEAD);
    }

    public long getNLNsLocked() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_LNS_LOCKED);
    }

    public long getNLNsMigrated() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_LNS_MIGRATED);
    }

    public long getNLNsMarked() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_LNS_MARKED);
    }

    public long getNLNQueueHits() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_LNQUEUE_HITS);
    }

    public long getNPendingLNsProcessed() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_PENDING_LNS_PROCESSED);
    }

    public long getNMarkedLNsProcessed() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_MARKED_LNS_PROCESSED);
    }

    public long getNToBeCleanedLNsProcessed() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_TO_BE_CLEANED_LNS_PROCESSED);
    }

    public long getNClusterLNsProcessed() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_CLUSTER_LNS_PROCESSED);
    }

    public long getNPendingLNsLocked() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_PENDING_LNS_LOCKED);
    }

    public long getNRepeatIteratorReads() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_REPEAT_ITERATOR_READS);
    }

    public long getTotalLogSize() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_TOTAL_LOG_SIZE);
    }

    public long getNCacheMiss() {
        return this.logStats.getAtomicLong(LogStatDefinition.LBFP_MISS);
    }

    public long getEndOfLog() {
        return this.logStats.getLong(LogStatDefinition.LOGMGR_END_OF_LOG);
    }

    public long getNFSyncs() {
        return this.logStats.getAtomicLong(LogStatDefinition.FSYNCMGR_FSYNCS);
    }

    public long getNFSyncRequests() {
        return this.logStats.getLong(LogStatDefinition.FSYNCMGR_FSYNC_REQUESTS);
    }

    public long getNFSyncTimeouts() {
        return this.logStats.getLong(LogStatDefinition.FSYNCMGR_TIMEOUTS);
    }

    public long getNLogFSyncs() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_LOG_FSYNCS);
    }

    public int getNLogBuffers() {
        return this.logStats.getInt(LogStatDefinition.LBFP_LOG_BUFFERS);
    }

    public long getNRandomReads() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_RANDOM_READS);
    }

    public long getNRandomReadBytes() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_RANDOM_READ_BYTES);
    }

    public long getNRandomWrites() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_RANDOM_WRITES);
    }

    public long getNRandomWriteBytes() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_RANDOM_WRITE_BYTES);
    }

    public long getNSequentialReads() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_SEQUENTIAL_READS);
    }

    public long getNSequentialReadBytes() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_SEQUENTIAL_READ_BYTES);
    }

    public long getNSequentialWrites() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_SEQUENTIAL_WRITES);
    }

    public long getNSequentialWriteBytes() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_SEQUENTIAL_WRITE_BYTES);
    }

    public long getNBytesReadFromWriteQueue() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_BYTES_READ_FROM_WRITEQUEUE);
    }

    public long getNBytesWrittenFromWriteQueue() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_BYTES_WRITTEN_FROM_WRITEQUEUE);
    }

    public long getNReadsFromWriteQueue() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_READS_FROM_WRITEQUEUE);
    }

    public long getNWritesFromWriteQueue() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_WRITES_FROM_WRITEQUEUE);
    }

    public long getNWriteQueueOverflow() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_WRITEQUEUE_OVERFLOW);
    }

    public long getNWriteQueueOverflowFailures() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_WRITEQUEUE_OVERFLOW_FAILURES);
    }

    public long getBufferBytes() {
        return this.logStats.getLong(LogStatDefinition.LBFP_BUFFER_BYTES);
    }

    public long getNNotResident() {
        return this.logStats.getAtomicLong(LogStatDefinition.LBFP_NOT_RESIDENT);
    }

    public long getNRepeatFaultReads() {
        return this.logStats.getLong(LogStatDefinition.LOGMGR_REPEAT_FAULT_READS);
    }

    public long getNTempBufferWrites() {
        return this.logStats.getLong(LogStatDefinition.LOGMGR_TEMP_BUFFER_WRITES);
    }

    public int getNFileOpens() {
        return this.logStats.getInt(LogStatDefinition.FILEMGR_FILE_OPENS);
    }

    public int getNOpenFiles() {
        return this.logStats.getInt(LogStatDefinition.FILEMGR_OPEN_FILES);
    }

    public long getRequiredEvictBytes() {
        return 0L;
    }

    public long getNNodesScanned() {
        return 0L;
    }

    public long getNEvictPasses() {
        return this.cacheStats.getLong(EvictorStatDefinition.EVICTOR_EVICTION_RUNS);
    }

    public long getNNodesSelected() {
        return this.cacheStats.getLong(EvictorStatDefinition.EVICTOR_NODES_TARGETED);
    }

    public long getNNodesExplicitlyEvicted() {
        return this.cacheStats.getLong(EvictorStatDefinition.EVICTOR_NODES_EVICTED);
    }

    public long getNBINsStripped() {
        return this.cacheStats.getLong(EvictorStatDefinition.EVICTOR_NODES_STRIPPED);
    }

    public long getNBINsMutated() {
        return this.cacheStats.getLong(EvictorStatDefinition.EVICTOR_NODES_MUTATED);
    }

    public long getNEvictionRuns() {
        return this.cacheStats.getLong(EvictorStatDefinition.EVICTOR_EVICTION_RUNS);
    }

    public long getNNodesTargeted() {
        return this.cacheStats.getLong(EvictorStatDefinition.EVICTOR_NODES_TARGETED);
    }

    public long getNNodesEvicted() {
        return this.cacheStats.getLong(EvictorStatDefinition.EVICTOR_NODES_EVICTED);
    }

    public long getNRootNodesEvicted() {
        return this.cacheStats.getLong(EvictorStatDefinition.EVICTOR_ROOT_NODES_EVICTED);
    }

    public long getNDirtyNodesEvicted() {
        return this.cacheStats.getLong(EvictorStatDefinition.EVICTOR_DIRTY_NODES_EVICTED);
    }

    public long getNLNsEvicted() {
        return this.cacheStats.getLong(EvictorStatDefinition.EVICTOR_LNS_EVICTED);
    }

    public long getNNodesStripped() {
        return this.cacheStats.getLong(EvictorStatDefinition.EVICTOR_NODES_STRIPPED);
    }

    public long getNNodesMutated() {
        return this.cacheStats.getLong(EvictorStatDefinition.EVICTOR_NODES_MUTATED);
    }

    public long getNNodesPutBack() {
        return this.cacheStats.getLong(EvictorStatDefinition.EVICTOR_NODES_PUT_BACK);
    }

    public long getNNodesMovedToDirtyLRU() {
        return this.cacheStats.getLong(EvictorStatDefinition.EVICTOR_NODES_MOVED_TO_PRI2_LRU);
    }

    public long getNNodesSkipped() {
        return this.cacheStats.getLong(EvictorStatDefinition.EVICTOR_NODES_SKIPPED);
    }

    public long getNThreadUnavailable() {
        return this.cacheStats.getAtomicLong(EvictorStatDefinition.THREAD_UNAVAILABLE);
    }

    public int getNSharedCacheEnvironments() {
        return this.cacheStats.getInt(EvictorStatDefinition.EVICTOR_SHARED_CACHE_ENVS);
    }

    public long getNLNsFetch() {
        return this.cacheStats.getAtomicLong(EvictorStatDefinition.LN_FETCH);
    }

    public long getNUpperINsFetch() {
        return this.cacheStats.getAtomicLong(EvictorStatDefinition.UPPER_IN_FETCH);
    }

    public long getNBINsFetch() {
        return this.cacheStats.getAtomicLong(EvictorStatDefinition.BIN_FETCH);
    }

    public long getNLNsFetchMiss() {
        return this.cacheStats.getAtomicLong(EvictorStatDefinition.LN_FETCH_MISS);
    }

    public long getNUpperINsFetchMiss() {
        return this.cacheStats.getAtomicLong(EvictorStatDefinition.UPPER_IN_FETCH_MISS);
    }

    public long getNBINsFetchMiss() {
        return this.cacheStats.getAtomicLong(EvictorStatDefinition.BIN_FETCH_MISS);
    }

    public long getNBINDeltasFetchMiss() {
        return this.cacheStats.getAtomicLong(EvictorStatDefinition.BIN_DELTA_FETCH_MISS);
    }

    public float getNBINsFetchMissRatio() {
        return this.cacheStats.getFloat(EvictorStatDefinition.BIN_FETCH_MISS_RATIO);
    }

    public long getNFullBINsMiss() {
        return this.cacheStats.getAtomicLong(EvictorStatDefinition.FULL_BIN_MISS);
    }

    public long getNBINDeltaBlindOps() {
        return this.cacheStats.getAtomicLong(EvictorStatDefinition.BIN_DELTA_BLIND_OPS);
    }

    public long getNCachedUpperINs() {
        return this.cacheStats.getLong(EvictorStatDefinition.CACHED_UPPER_INS);
    }

    public long getNCachedBINs() {
        return this.cacheStats.getLong(EvictorStatDefinition.CACHED_BINS);
    }

    public long getNCachedBINDeltas() {
        return this.cacheStats.getLong(EvictorStatDefinition.CACHED_BIN_DELTAS);
    }

    public long getNINSparseTarget() {
        return this.cacheStats.getLong(EvictorStatDefinition.CACHED_IN_SPARSE_TARGET);
    }

    public long getNINNoTarget() {
        return this.cacheStats.getLong(EvictorStatDefinition.CACHED_IN_NO_TARGET);
    }

    public long getNINCompactKeyIN() {
        return this.cacheStats.getLong(EvictorStatDefinition.CACHED_IN_COMPACT_KEY);
    }

    public long getDirtyLRUSize() {
        return this.cacheStats.getLong(EvictorStatDefinition.PRI2_LRU_SIZE);
    }

    public long getMixedLRUSize() {
        return this.cacheStats.getLong(EvictorStatDefinition.PRI1_LRU_SIZE);
    }

    public long getNBINsEvictedEvictorThread() {
        return 0L;
    }

    public long getNBINsEvictedManual() {
        return 0L;
    }

    public long getNBINsEvictedCritical() {
        return 0L;
    }

    public long getNBINsEvictedCacheMode() {
        return 0L;
    }

    public long getNBINsEvictedDaemon() {
        return 0L;
    }

    public long getNUpperINsEvictedEvictorThread() {
        return 0L;
    }

    public long getNUpperINsEvictedManual() {
        return 0L;
    }

    public long getNUpperINsEvictedCritical() {
        return 0L;
    }

    public long getNUpperINsEvictedCacheMode() {
        return 0L;
    }

    public long getNUpperINsEvictedDaemon() {
        return 0L;
    }

    public long getNBatchesEvictorThread() {
        return 0L;
    }

    public long getNBatchesManual() {
        return 0L;
    }

    public long getNBatchesCacheMode() {
        return 0L;
    }

    public long getNBatchesCritical() {
        return 0L;
    }

    public long getNBatchesDaemon() {
        return 0L;
    }

    public long getNBytesEvictedEvictorThread() {
        return this.cacheStats.getLong(Evictor.EvictionSource.EVICTORTHREAD.getNumBytesEvictedStatDef());
    }

    public long getNBytesEvictedManual() {
        return this.cacheStats.getLong(Evictor.EvictionSource.MANUAL.getNumBytesEvictedStatDef());
    }

    public long getNBytesEvictedCacheMode() {
        return this.cacheStats.getLong(Evictor.EvictionSource.CACHEMODE.getNumBytesEvictedStatDef());
    }

    public long getNBytesEvictedCritical() {
        return this.cacheStats.getLong(Evictor.EvictionSource.CRITICAL.getNumBytesEvictedStatDef());
    }

    public long getNBytesEvictedDeamon() {
        return this.cacheStats.getLong(Evictor.EvictionSource.DAEMON.getNumBytesEvictedStatDef());
    }

    public long getAvgBatchEvictorThread() {
        return 0L;
    }

    public long getAvgBatchManual() {
        return 0L;
    }

    public long getAvgBatchCacheMode() {
        return 0L;
    }

    public long getAvgBatchCritical() {
        return 0L;
    }

    public long getAvgBatchDaemon() {
        return 0L;
    }

    public long getSharedCacheTotalBytes() {
        return this.cacheStats.getLong(DbiStatDefinition.MB_SHARED_CACHE_TOTAL_BYTES);
    }

    public long getCacheTotalBytes() {
        return this.cacheStats.getLong(DbiStatDefinition.MB_TOTAL_BYTES);
    }

    public long getDataBytes() {
        return this.cacheStats.getLong(DbiStatDefinition.MB_DATA_BYTES);
    }

    public long getDataAdminBytes() {
        return this.cacheStats.getLong(DbiStatDefinition.MB_DATA_ADMIN_BYTES);
    }

    public long getDOSBytes() {
        return this.cacheStats.getLong(DbiStatDefinition.MB_DOS_BYTES);
    }

    public long getAdminBytes() {
        return this.cacheStats.getLong(DbiStatDefinition.MB_ADMIN_BYTES);
    }

    public long getLockBytes() {
        return this.cacheStats.getLong(DbiStatDefinition.MB_LOCK_BYTES);
    }

    public long getCacheDataBytes() {
        return this.getCacheTotalBytes() - this.getBufferBytes();
    }

    public long getOffHeapAllocFailures() {
        return this.cacheStats.getLong(OffHeapStatDefinition.ALLOC_FAILURE);
    }

    public long getOffHeapAllocOverflows() {
        return this.cacheStats.getLong(OffHeapStatDefinition.ALLOC_OVERFLOW);
    }

    public long getOffHeapThreadUnavailable() {
        return this.cacheStats.getLong(OffHeapStatDefinition.THREAD_UNAVAILABLE);
    }

    public long getOffHeapNodesTargeted() {
        return this.offHeapStats.getLong(OffHeapStatDefinition.NODES_TARGETED);
    }

    public long getOffHeapNodesEvicted() {
        return this.cacheStats.getLong(OffHeapStatDefinition.NODES_EVICTED);
    }

    public long getOffHeapDirtyNodesEvicted() {
        return this.cacheStats.getLong(OffHeapStatDefinition.DIRTY_NODES_EVICTED);
    }

    public long getOffHeapNodesStripped() {
        return this.cacheStats.getLong(OffHeapStatDefinition.NODES_STRIPPED);
    }

    public long getOffHeapNodesMutated() {
        return this.cacheStats.getLong(OffHeapStatDefinition.NODES_MUTATED);
    }

    public long getOffHeapNodesSkipped() {
        return this.cacheStats.getLong(OffHeapStatDefinition.NODES_SKIPPED);
    }

    public long getOffHeapLNsEvicted() {
        return this.offHeapStats.getLong(OffHeapStatDefinition.LNS_EVICTED);
    }

    public long getOffHeapLNsLoaded() {
        return this.offHeapStats.getLong(OffHeapStatDefinition.LNS_LOADED);
    }

    public long getOffHeapLNsStored() {
        return this.offHeapStats.getLong(OffHeapStatDefinition.LNS_STORED);
    }

    public long getOffHeapBINsLoaded() {
        return this.offHeapStats.getLong(OffHeapStatDefinition.BINS_LOADED);
    }

    public long getOffHeapBINsStored() {
        return this.offHeapStats.getLong(OffHeapStatDefinition.BINS_STORED);
    }

    public int getOffHeapCachedLNs() {
        return this.offHeapStats.getInt(OffHeapStatDefinition.CACHED_LNS);
    }

    public int getOffHeapCachedBINs() {
        return this.offHeapStats.getInt(OffHeapStatDefinition.CACHED_BINS);
    }

    public int getOffHeapCachedBINDeltas() {
        return this.offHeapStats.getInt(OffHeapStatDefinition.CACHED_BIN_DELTAS);
    }

    public long getOffHeapTotalBytes() {
        return this.offHeapStats.getLong(OffHeapStatDefinition.TOTAL_BYTES);
    }

    public long getOffHeapTotalBlocks() {
        return this.offHeapStats.getInt(OffHeapStatDefinition.TOTAL_BLOCKS);
    }

    public long getOffHeapLRUSize() {
        return this.offHeapStats.getInt(OffHeapStatDefinition.TOTAL_BLOCKS);
    }

    public long getRelatchesRequired() {
        return this.envImplStats.getLong(DbiStatDefinition.ENVIMPL_RELATCHES_REQUIRED);
    }

    public int getNOwners() {
        return this.lockStats.getInt(LockStatDefinition.LOCK_OWNERS);
    }

    public int getNReadLocks() {
        return this.lockStats.getInt(LockStatDefinition.LOCK_READ_LOCKS);
    }

    public int getNTotalLocks() {
        return this.lockStats.getInt(LockStatDefinition.LOCK_TOTAL);
    }

    public int getNWaiters() {
        return this.lockStats.getInt(LockStatDefinition.LOCK_WAITERS);
    }

    public int getNWriteLocks() {
        return this.lockStats.getInt(LockStatDefinition.LOCK_WRITE_LOCKS);
    }

    public long getNRequests() {
        return this.lockStats.getLong(LockStatDefinition.LOCK_REQUESTS);
    }

    public long getNWaits() {
        return this.lockStats.getLong(LockStatDefinition.LOCK_WAITS);
    }

    public int getNAcquiresNoWaiters() {
        return this.lockStats.getInt(LatchStatDefinition.LATCH_NO_WAITERS);
    }

    public int getNAcquiresSelfOwned() {
        return this.lockStats.getInt(LatchStatDefinition.LATCH_SELF_OWNED);
    }

    public int getNAcquiresWithContention() {
        return this.lockStats.getInt(LatchStatDefinition.LATCH_CONTENTION);
    }

    public int getNAcquiresNoWaitSuccessful() {
        return this.lockStats.getInt(LatchStatDefinition.LATCH_NOWAIT_SUCCESS);
    }

    public int getNAcquiresNoWaitUnSuccessful() {
        return this.lockStats.getInt(LatchStatDefinition.LATCH_NOWAIT_UNSUCCESS);
    }

    public int getNReleases() {
        return this.lockStats.getInt(LatchStatDefinition.LATCH_RELEASES);
    }

    public long getNBinDeltaGetOps() {
        return this.throughputStats.getAtomicLong(DbiStatDefinition.THROUGHPUT_BIN_DELTA_GETS);
    }

    public long getNBinDeltaInsertOps() {
        return this.throughputStats.getAtomicLong(DbiStatDefinition.THROUGHPUT_BIN_DELTA_INSERTS);
    }

    public long getNBinDeltaUpdateOps() {
        return this.throughputStats.getAtomicLong(DbiStatDefinition.THROUGHPUT_BIN_DELTA_UPDATES);
    }

    public long getNBinDeltaDeleteOps() {
        return this.throughputStats.getAtomicLong(DbiStatDefinition.THROUGHPUT_BIN_DELTA_DELETES);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.logStats.toString());
        sb.append(this.cacheStats.toString());
        sb.append(this.offHeapStats.toString());
        sb.append(this.cleanerStats.toString());
        sb.append(this.incompStats.toString());
        sb.append(this.ckptStats.toString());
        sb.append(this.envImplStats.toString());
        sb.append(this.lockStats.toString());
        return sb.toString();
    }

    public String toStringVerbose() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.logStats.toStringVerbose());
        sb.append(this.cacheStats.toStringVerbose());
        sb.append(this.offHeapStats.toStringVerbose());
        sb.append(this.cleanerStats.toStringVerbose());
        sb.append(this.incompStats.toStringVerbose());
        sb.append(this.ckptStats.toStringVerbose());
        sb.append(this.envImplStats.toStringVerbose());
        sb.append(this.lockStats.toStringVerbose());
        return sb.toString();
    }

    public Map<String, String> getTips() {
        HashMap<String, String> tipsMap = new HashMap<String, String>();
        this.cacheStats.addToTipMap(tipsMap);
        this.offHeapStats.addToTipMap(tipsMap);
        this.ckptStats.addToTipMap(tipsMap);
        this.cleanerStats.addToTipMap(tipsMap);
        this.logStats.addToTipMap(tipsMap);
        this.lockStats.addToTipMap(tipsMap);
        this.envImplStats.addToTipMap(tipsMap);
        return tipsMap;
    }
}

