/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.JoinConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.GetMode;
import com.sleepycat.je.dbi.RecordVersion;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.DatabaseUtil;
import com.sleepycat.je.utilint.Pair;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;

public class JoinCursor
implements Closeable {
    private JoinConfig config;
    private Database priDb;
    private Cursor[] secCursors;
    private DatabaseEntry[] cursorScratchEntries;
    private DatabaseEntry scratchEntry;
    private DatabaseEntry firstSecKey;
    private boolean[] cursorFetchedFirst;

    JoinCursor(Locker locker, Database primaryDb, final Cursor[] cursors, JoinConfig configParam) throws DatabaseException {
        this.priDb = primaryDb;
        this.config = configParam != null ? configParam.clone() : JoinConfig.DEFAULT;
        this.scratchEntry = new DatabaseEntry();
        this.firstSecKey = new DatabaseEntry();
        this.cursorScratchEntries = new DatabaseEntry[cursors.length];
        for (int i = 0; i < cursors.length; ++i) {
            this.cursorScratchEntries[i] = new DatabaseEntry();
        }
        this.cursorFetchedFirst = new boolean[cursors.length];
        Cursor[] sortedCursors = new Cursor[cursors.length];
        System.arraycopy(cursors, 0, sortedCursors, 0, cursors.length);
        if (!this.config.getNoSort()) {
            final long[] counts = new long[cursors.length];
            for (int i = 0; i < cursors.length; ++i) {
                counts[i] = cursors[i].countEstimateInternal();
                assert (counts[i] >= 0L);
            }
            Arrays.sort(sortedCursors, new Comparator<Cursor>(){

                @Override
                public int compare(Cursor o1, Cursor o2) {
                    long count1 = -1L;
                    long count2 = -1L;
                    for (int i = 0; i < cursors.length && (count1 < 0L || count2 < 0L); ++i) {
                        if (cursors[i] == o1) {
                            count1 = counts[i];
                            continue;
                        }
                        if (cursors[i] != o2) continue;
                        count2 = counts[i];
                    }
                    assert (count1 >= 0L && count2 >= 0L);
                    long cmp = count1 - count2;
                    return cmp < 0L ? -1 : (cmp > 0L ? 1 : 0);
                }
            });
        }
        try {
            this.secCursors = new Cursor[cursors.length];
            for (int i = 0; i < cursors.length; ++i) {
                this.secCursors[i] = sortedCursors[i].dup(true);
            }
        }
        catch (DatabaseException e) {
            this.close(e);
        }
    }

    @Override
    public void close() throws DatabaseException {
        if (this.priDb == null) {
            return;
        }
        this.close(null);
    }

    private void close(DatabaseException firstException) throws DatabaseException {
        this.priDb = null;
        for (int i = 0; i < this.secCursors.length; ++i) {
            block4: {
                if (this.secCursors[i] == null) continue;
                try {
                    this.secCursors[i].close();
                }
                catch (DatabaseException e) {
                    if (firstException != null) break block4;
                    firstException = e;
                }
            }
            this.secCursors[i] = null;
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    Cursor[] getSortedCursors() {
        return this.secCursors;
    }

    public Database getDatabase() {
        return this.priDb;
    }

    public JoinConfig getConfig() {
        return this.config.clone();
    }

    public OperationStatus getNext(DatabaseEntry key, LockMode lockMode) throws DatabaseException {
        this.secCursors[0].checkEnv();
        DatabaseUtil.checkForNullDbt(key, "key", false);
        this.secCursors[0].trace(Level.FINEST, "JoinCursor.getNext(key): ", lockMode);
        return this.retrieveNext(key, null, lockMode);
    }

    public OperationStatus getNext(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.secCursors[0].checkEnv();
        DatabaseUtil.checkForNullDbt(key, "key", false);
        DatabaseUtil.checkForNullDbt(data, "data", false);
        this.secCursors[0].trace(Level.FINEST, "JoinCursor.getNext(key,data): ", lockMode);
        return this.retrieveNext(key, data, lockMode);
    }

    private OperationStatus retrieveNext(DatabaseEntry keyParam, DatabaseEntry dataParam, LockMode lockMode) throws DatabaseException {
        DatabaseEntry candidateKey;
        block11: {
            Pair<OperationStatus, RecordVersion> result;
            OperationStatus status;
            boolean readUncommitted = this.secCursors[0].isReadUncommittedMode(lockMode);
            block0: while (true) {
                Cursor secCursor = this.secCursors[0];
                candidateKey = this.cursorScratchEntries[0];
                if (!this.cursorFetchedFirst[0]) {
                    status = secCursor.getCurrentInternal(this.firstSecKey, candidateKey, lockMode);
                    if (readUncommitted && status == OperationStatus.KEYEMPTY) {
                        this.cursorFetchedFirst[0] = true;
                        continue;
                    }
                    this.cursorFetchedFirst[0] = true;
                } else {
                    status = secCursor.retrieveNext(this.firstSecKey, candidateKey, lockMode, GetMode.NEXT_DUP);
                }
                if (status != OperationStatus.SUCCESS) {
                    return status;
                }
                for (int i = 1; i < this.secCursors.length; ++i) {
                    secCursor = this.secCursors[i];
                    DatabaseEntry secKey = this.cursorScratchEntries[i];
                    if (!this.cursorFetchedFirst[i]) {
                        status = secCursor.getCurrentInternal(secKey, this.scratchEntry, lockMode);
                        if (readUncommitted && status == OperationStatus.KEYEMPTY && (status = secCursor.retrieveNext(secKey, this.scratchEntry, lockMode, GetMode.NEXT_DUP)) != OperationStatus.SUCCESS) {
                            return status;
                        }
                        assert (status == OperationStatus.SUCCESS);
                        this.cursorFetchedFirst[i] = true;
                    }
                    this.scratchEntry.setData(secKey.getData(), secKey.getOffset(), secKey.getSize());
                    status = secCursor.search(this.scratchEntry, candidateKey, lockMode, CursorImpl.SearchMode.BOTH);
                    if (status != OperationStatus.SUCCESS) continue block0;
                }
                if (dataParam == null) break block11;
                result = this.secCursors[0].readPrimaryAfterGet(this.priDb, this.firstSecKey, candidateKey, dataParam, lockMode, readUncommitted, false);
                status = result.first();
                if (status != OperationStatus.KEYEMPTY) break;
            }
            assert (status == OperationStatus.SUCCESS);
            RecordVersion version = result.second();
            for (int i = 0; i < this.secCursors.length; ++i) {
                Cursor c = this.secCursors[i];
                if (!c.isSecondaryCursor()) continue;
                c.cursorImpl.setSecondaryCurrentVersion(version);
            }
        }
        keyParam.setData(candidateKey.getData(), candidateKey.getOffset(), candidateKey.getSize());
        return OperationStatus.SUCCESS;
    }
}

