/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.FileSummary;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileReader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.entry.BINDeltaLogEntry;
import com.sleepycat.je.log.entry.INLogEntry;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.log.entry.OldBINDeltaLogEntry;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeLocation;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class UtilizationFileReader
extends FileReader {
    private final Map<Long, FileSummary> summaries = new HashMap<Long, FileSummary>();
    private final Map<DatabaseId, DatabaseImpl> dbCache = new HashMap<DatabaseId, DatabaseImpl>();
    private final DbTree dbTree;

    private UtilizationFileReader(EnvironmentImpl envImpl, int readBufferSize, long startLsn, long finishLsn) throws DatabaseException {
        super(envImpl, readBufferSize, true, startLsn, null, -1L, finishLsn);
        this.dbTree = envImpl.getDbTree();
    }

    @Override
    protected boolean isTargetEntry() {
        return this.currentEntryHeader.getType() != LogEntryType.LOG_FILE_HEADER.getTypeNum() && !this.currentEntryHeader.isInvisible();
    }

    @Override
    protected boolean processEntry(ByteBuffer entryBuffer) throws DatabaseException {
        LogEntryType lastEntryType = LogEntryType.findType(this.currentEntryHeader.getType());
        LogEntry entry = lastEntryType.getNewLogEntry();
        entry.readEntry(this.envImpl, this.currentEntryHeader, entryBuffer);
        ExtendedFileSummary summary = (ExtendedFileSummary)this.summaries.get(this.window.currentFileNum());
        if (summary == null) {
            summary = new ExtendedFileSummary();
            this.summaries.put(this.window.currentFileNum(), summary);
        }
        int size = this.getLastEntrySize();
        ++summary.totalCount;
        summary.totalSize += size;
        if (entry instanceof LNLogEntry) {
            LNLogEntry lnEntry = (LNLogEntry)entry;
            DatabaseImpl dbImpl = this.getActiveDb(lnEntry.getDbId());
            boolean isActive = dbImpl != null && !lnEntry.isImmediatelyObsolete(dbImpl) && this.isLNActive(lnEntry, dbImpl);
            this.applyLN(summary, size, isActive);
        } else if (entry instanceof BINDeltaLogEntry || entry instanceof OldBINDeltaLogEntry) {
            ++summary.totalINCount;
            summary.totalINSize += size;
            ++summary.obsoleteINCount;
            summary.recalcObsoleteINSize += size;
        } else if (entry instanceof INLogEntry) {
            INLogEntry inEntry = (INLogEntry)entry;
            DatabaseImpl dbImpl = this.getActiveDb(inEntry.getDbId());
            boolean isActive = dbImpl != null && this.isINActive(inEntry, dbImpl);
            this.applyIN(summary, size, isActive);
        }
        return true;
    }

    private DatabaseImpl getActiveDb(DatabaseId dbId) {
        DatabaseImpl dbImpl = this.dbTree.getDb(dbId, -1L, this.dbCache);
        if (dbImpl == null) {
            return null;
        }
        if (dbImpl.isDeleteFinished()) {
            return null;
        }
        return dbImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLNActive(LNLogEntry<?> lnEntry, DatabaseImpl dbImpl) {
        lnEntry.postFetchInit(dbImpl);
        byte[] key = lnEntry.getKey();
        Tree tree = dbImpl.getTree();
        TreeLocation location = new TreeLocation();
        boolean parentFound = tree.getParentBINForChildLN(location, key, false, false, CacheMode.DEFAULT);
        BIN bin = location.bin;
        try {
            if (!parentFound || bin.isEntryKnownDeleted(location.index)) {
                boolean bl = false;
                return bl;
            }
            int index = location.index;
            long treeLsn = bin.getLsn(index);
            if (treeLsn == -1L) {
                boolean bl = false;
                return bl;
            }
            long logLsn = this.getLastLsn();
            boolean bl = treeLsn == logLsn;
            return bl;
        }
        finally {
            if (bin != null) {
                bin.releaseLatch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isINActive(INLogEntry<?> inEntry, DatabaseImpl dbImpl) {
        long logLsn = this.getLastLsn();
        IN logIn = inEntry.getIN(dbImpl);
        logIn.setDatabase(dbImpl);
        Tree tree = dbImpl.getTree();
        if (logIn.isRoot()) {
            return logLsn == tree.getRootLsn();
        }
        logIn.latch(CacheMode.DEFAULT);
        SearchResult result = tree.getParentINForChildIN(logIn, true, true, CacheMode.DEFAULT);
        if (!result.exactParentFound) {
            return false;
        }
        try {
            long treeLsn = result.parent.getLsn(result.index);
            if (treeLsn == -1L) {
                boolean bl = false;
                return bl;
            }
            if (treeLsn == logLsn) {
                boolean bl = true;
                return bl;
            }
            if (!logIn.isBIN()) {
                boolean bl = false;
                return bl;
            }
            IN treeIn = result.parent.fetchIN(result.index, CacheMode.DEFAULT);
            treeLsn = treeIn.getLastFullLsn();
            boolean bl = treeLsn == logLsn;
            return bl;
        }
        finally {
            result.parent.releaseLatch();
        }
    }

    private void applyLN(ExtendedFileSummary summary, int size, boolean isActive) {
        ++summary.totalLNCount;
        summary.totalLNSize += size;
        if (!isActive) {
            ++summary.obsoleteLNCount;
            summary.recalcObsoleteLNSize += size;
        }
    }

    private void applyIN(ExtendedFileSummary summary, int size, boolean isActive) {
        ++summary.totalINCount;
        summary.totalINSize += size;
        if (!isActive) {
            ++summary.obsoleteINCount;
            summary.recalcObsoleteINSize += size;
        }
    }

    private void cleanUp() {
        this.dbTree.releaseDbs(this.dbCache);
    }

    public static Map<Long, FileSummary> calcFileSummaryMap(EnvironmentImpl envImpl) {
        return UtilizationFileReader.calcFileSummaryMap(envImpl, -1L, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, FileSummary> calcFileSummaryMap(EnvironmentImpl envImpl, long startLsn, long finishLsn) {
        int readBufferSize = envImpl.getConfigManager().getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
        UtilizationFileReader reader = new UtilizationFileReader(envImpl, readBufferSize, startLsn, finishLsn);
        try {
            while (reader.readNextEntry()) {
            }
            Map<Long, FileSummary> map = reader.summaries;
            return map;
        }
        finally {
            reader.cleanUp();
        }
    }

    private static class NodeInfo {
        ExtendedFileSummary summary;
        int size;
        long dbId;

        private NodeInfo() {
        }
    }

    private static class ExtendedFileSummary
    extends FileSummary {
        private int recalcObsoleteINSize;
        private int recalcObsoleteLNSize;

        private ExtendedFileSummary() {
        }

        @Override
        public int getObsoleteLNSize() {
            return this.recalcObsoleteLNSize;
        }

        @Override
        public int getObsoleteINSize() {
            return this.recalcObsoleteINSize;
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(super.toString());
            buf.append("<extended-info recalcObsoleteINSize=\"");
            buf.append(this.recalcObsoleteINSize);
            buf.append("\" recalcObsoleteLNSize=\"");
            buf.append(this.recalcObsoleteLNSize);
            buf.append("\"/>");
            return buf.toString();
        }
    }
}

