/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log.entry;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DupKeyData;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogEntryHeader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.entry.BaseReplicableEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.VersionedLN;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.VLSN;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class LNLogEntry<T extends LN>
extends BaseReplicableEntry<T> {
    private static final byte ABORT_KD_MASK = 1;
    private static final byte EMBEDDED_LN_MASK = 2;
    private static final byte HAVE_ABORT_KEY_MASK = 4;
    private static final byte HAVE_ABORT_DATA_MASK = 8;
    private static final byte HAVE_ABORT_VLSN_MASK = 16;
    public static final int MIN_LOG_SIZE = 16;
    public static final int LAST_FORMAT_CHANGE = 11;
    public static final int PREV_FORMAT_CHANGE = 8;
    private DatabaseId dbId;
    private Txn txn;
    private long abortLsn = -1L;
    private boolean abortKnownDeleted;
    private byte[] abortKey = null;
    private byte[] abortData = null;
    private long abortVLSN = -1L;
    private boolean haveAbortKey;
    private boolean haveAbortData;
    private boolean haveAbortVLSN;
    private boolean embeddedLN;
    private LN ln;
    private byte[] key;
    private DupStatus dupStatus;
    private final Constructor<VersionedLN> versionedLNConstructor;

    public static <T extends LN> LNLogEntry<T> create(Class<T> cls) {
        return new LNLogEntry<T>(cls);
    }

    LNLogEntry(Class<T> cls) {
        super(cls);
        this.versionedLNConstructor = cls == LN.class ? LNLogEntry.getNoArgsConstructor(VersionedLN.class) : null;
    }

    public LNLogEntry(LogEntryType entryType, DatabaseId dbId, Txn txn, long abortLsn, boolean abortKD, byte[] abortKey, byte[] abortData, long abortVLSN, byte[] key, T ln, boolean embeddedLN) {
        this.setLogType(entryType);
        this.dbId = dbId;
        this.txn = txn;
        this.abortLsn = abortLsn;
        this.abortKnownDeleted = abortKD;
        this.abortKey = abortKey;
        this.abortData = abortData;
        this.abortVLSN = abortVLSN;
        this.haveAbortKey = abortKey != null;
        this.haveAbortData = abortData != null;
        this.haveAbortVLSN = !VLSN.isNull(abortVLSN);
        this.embeddedLN = embeddedLN;
        this.key = key;
        this.ln = ln;
        this.versionedLNConstructor = null;
        assert (entryType.isTransactional() == (txn != null));
    }

    private void reset() {
        this.txn = null;
        this.abortLsn = -1L;
        this.abortKey = null;
        this.abortData = null;
        this.abortVLSN = -1L;
        this.ln = null;
        this.key = null;
    }

    @Override
    public void readEntry(EnvironmentImpl envImpl, LogEntryHeader header, ByteBuffer entryBuffer) {
        assert (this.getClass() == LNLogEntry.class);
        boolean keyIsLastSerializedField = header.getVersion() >= 8 || this.entryType.isUserLNType();
        this.readBaseLNEntry(envImpl, header, entryBuffer, keyIsLastSerializedField);
    }

    final void readBaseLNEntry(EnvironmentImpl envImpl, LogEntryHeader header, ByteBuffer entryBuffer, boolean keyIsLastSerializedField) {
        this.reset();
        int logVersion = header.getVersion();
        boolean unpacked = logVersion < 6;
        int recStartPosition = entryBuffer.position();
        if (logVersion < 6) {
            this.ln = this.newLNInstance(envImpl);
            this.ln.readFromLog(entryBuffer, logVersion);
        }
        this.dbId = new DatabaseId();
        this.dbId.readFromLog(entryBuffer, logVersion);
        if (logVersion < 6) {
            this.key = LogUtils.readByteArray(entryBuffer, true);
        }
        byte flags = 0;
        if (this.entryType.isTransactional()) {
            this.abortLsn = LogUtils.readLong(entryBuffer, unpacked);
            if (DbLsn.getFileNumber(this.abortLsn) == DbLsn.getFileNumber(-1L)) {
                this.abortLsn = -1L;
            }
            flags = entryBuffer.get();
            this.txn = new Txn();
            this.txn.readFromLog(entryBuffer, logVersion);
        } else if (logVersion >= 11) {
            flags = entryBuffer.get();
        }
        this.embeddedLN = (flags & 2) != 0;
        this.abortKnownDeleted = (flags & 1) != 0;
        this.haveAbortKey = (flags & 4) != 0;
        this.haveAbortData = (flags & 8) != 0;
        boolean bl = this.haveAbortVLSN = (flags & 0x10) != 0;
        if (logVersion >= 11) {
            if (this.haveAbortKey) {
                this.abortKey = LogUtils.readByteArray(entryBuffer, false);
            }
            if (this.haveAbortData) {
                this.abortData = LogUtils.readByteArray(entryBuffer, false);
            }
            if (this.haveAbortVLSN) {
                this.abortVLSN = LogUtils.readPackedLong(entryBuffer);
            }
        }
        if (logVersion >= 6) {
            int keySize;
            this.ln = this.newLNInstance(envImpl);
            this.ln.readFromLog(entryBuffer, logVersion);
            if (keyIsLastSerializedField) {
                int bytesWritten = entryBuffer.position() - recStartPosition;
                keySize = header.getItemSize() - bytesWritten;
            } else {
                keySize = LogUtils.readPackedInt(entryBuffer);
            }
            this.key = LogUtils.readBytesNoLength(entryBuffer, keySize);
        }
        if (header.getVLSN() != null) {
            this.ln.setVLSNSequence(header.getVLSN().getSequence());
        }
        this.dupStatus = logVersion < 8 ? DupStatus.NEED_CONVERSION : DupStatus.UNKNOWN;
    }

    LN newLNInstance(EnvironmentImpl envImpl) {
        if (this.versionedLNConstructor != null && envImpl.getPreserveVLSN()) {
            return LNLogEntry.newInstanceOfType(this.versionedLNConstructor);
        }
        return (LN)this.newInstanceOfType();
    }

    @Override
    public StringBuilder dumpEntry(StringBuilder sb, boolean verbose) {
        this.dbId.dumpLog(sb, verbose);
        this.ln.dumpKey(sb, this.key);
        this.ln.dumpLog(sb, verbose);
        sb.append("<embeddedLN val=\"");
        sb.append(this.embeddedLN);
        sb.append("\"/>");
        if (this.entryType.isTransactional()) {
            this.txn.dumpLog(sb, verbose);
            sb.append("<abortLSN val=\"");
            sb.append(DbLsn.getNoFormatString(this.abortLsn));
            sb.append("\"/>");
            sb.append("<abortKD val=\"");
            sb.append(this.abortKnownDeleted ? "true" : "false");
            sb.append("\"/>");
            if (this.haveAbortKey) {
                sb.append(Key.dumpString(this.abortKey, "abortKey", 0));
            }
            if (this.haveAbortData) {
                sb.append(Key.dumpString(this.abortData, "abortData", 0));
            }
            if (this.haveAbortVLSN) {
                sb.append("<abortVLSN v=\"");
                sb.append(this.abortVLSN);
                sb.append("\"/>");
            }
        }
        return sb;
    }

    @Override
    public void dumpRep(StringBuilder sb) {
        if (this.entryType.isTransactional()) {
            sb.append(" txn=").append(this.txn.getId());
        }
    }

    @Override
    public LN getMainItem() {
        return this.ln;
    }

    @Override
    public long getTransactionId() {
        if (this.entryType.isTransactional()) {
            return this.txn.getId();
        }
        return 0L;
    }

    @Override
    public int getLastFormatChange() {
        return 11;
    }

    private int getPrevFormatChange() {
        return 8;
    }

    @Override
    public int getSize() {
        assert (this.getClass() == LNLogEntry.class);
        return this.getBaseLNEntrySize(11, true, false);
    }

    @Override
    public int getSize(int logVersion) {
        assert (this.getClass() == LNLogEntry.class);
        return this.getBaseLNEntrySize(logVersion, true, true);
    }

    final int getBaseLNEntrySize(int logVersion, boolean keyIsLastSerializedField, boolean forReplication) {
        int prevFormatChange = this.getPrevFormatChange();
        if (logVersion < prevFormatChange) {
            throw new IllegalArgumentException("The requested log version, " + logVersion + ", is older than the previous format change, " + prevFormatChange + ", for class " + this.getClass().getName());
        }
        int len = this.key.length;
        int size = this.ln.getLogSize() + this.dbId.getLogSize() + len;
        if (!keyIsLastSerializedField) {
            size += LogUtils.getPackedIntLogSize(len);
        }
        if (this.entryType.isTransactional()) {
            size += LogUtils.getPackedLongLogSize(this.abortLsn);
            size += this.txn.getLogSize();
            ++size;
        } else if (!forReplication) {
            ++size;
        }
        if (!forReplication) {
            if (this.haveAbortKey) {
                size += LogUtils.getByteArrayLogSize(this.abortKey);
            }
            if (this.haveAbortData) {
                size += LogUtils.getByteArrayLogSize(this.abortData);
            }
            if (this.haveAbortVLSN) {
                size += LogUtils.getPackedLongLogSize(this.abortVLSN);
            }
        }
        return size;
    }

    @Override
    public void writeEntry(ByteBuffer destBuffer) {
        this.writeBaseLNEntry(destBuffer, 11, true, false);
    }

    @Override
    public void writeEntry(ByteBuffer destBuffer, int logVersion) {
        assert (this.getClass() == LNLogEntry.class);
        this.writeBaseLNEntry(destBuffer, logVersion, true, true);
    }

    final void writeBaseLNEntry(ByteBuffer destBuffer, int logVersion, boolean keyIsLastSerializedField, boolean forReplication) {
        int prevFormatChange = this.getPrevFormatChange();
        if (logVersion < prevFormatChange) {
            throw new IllegalArgumentException("The requested log version, " + logVersion + ", is older than the previous format change, " + prevFormatChange + ", for class " + this.getClass().getName());
        }
        assert (this.ln.getLastFormatChange() <= 11 && this.dbId.getLastFormatChange() <= 11) : "Format of loggable newer than format of entry";
        this.dbId.writeToLog(destBuffer, logVersion);
        byte flags = 0;
        if (!forReplication) {
            if (this.embeddedLN) {
                flags = (byte)(flags | 2);
            }
            if (this.haveAbortKey) {
                flags = (byte)(flags | 4);
            }
            if (this.haveAbortData) {
                flags = (byte)(flags | 8);
            }
            if (this.haveAbortVLSN) {
                flags = (byte)(flags | 0x10);
            }
        }
        if (this.entryType.isTransactional()) {
            LogUtils.writePackedLong(destBuffer, this.abortLsn);
            if (this.abortKnownDeleted) {
                flags = (byte)(flags | 1);
            }
            destBuffer.put(flags);
            assert (this.txn.getLastFormatChange() <= 11) : "Format of loggable newer than format of entry";
            this.txn.writeToLog(destBuffer, logVersion);
        } else if (!forReplication) {
            destBuffer.put(flags);
        } else {
            assert (false);
            destBuffer.put(flags);
        }
        if (!forReplication) {
            if (this.haveAbortKey) {
                LogUtils.writeByteArray(destBuffer, this.abortKey);
            }
            if (this.haveAbortData) {
                LogUtils.writeByteArray(destBuffer, this.abortData);
            }
            if (this.haveAbortVLSN) {
                LogUtils.writePackedLong(destBuffer, this.abortVLSN);
            }
        }
        this.ln.writeToLog(destBuffer, logVersion);
        if (!keyIsLastSerializedField) {
            LogUtils.writePackedInt(destBuffer, this.key.length);
        }
        LogUtils.writeBytesNoLength(destBuffer, this.key);
    }

    @Override
    public boolean isImmediatelyObsolete(DatabaseImpl dbImpl) {
        return this.ln.isDeleted() || this.embeddedLN || dbImpl.isLNImmediatelyObsolete();
    }

    @Override
    public boolean isDeleted() {
        return this.ln.isDeleted();
    }

    @Override
    public void postLogWork(LogEntryHeader header, long justLoggedLsn, VLSN vlsn) {
        if (this.entryType.isTransactional()) {
            this.txn.addLogInfo(justLoggedLsn);
        }
        if (vlsn != null) {
            this.ln.setVLSNSequence(vlsn.getSequence());
        }
    }

    @Override
    public void postFetchInit(DatabaseImpl dbImpl) {
        this.postFetchInit(dbImpl.getSortedDuplicates());
    }

    public void postFetchInit(boolean isDupDb) {
        boolean needConversion = this.dupStatus == DupStatus.NEED_CONVERSION;
        DupStatus dupStatus = this.dupStatus = isDupDb ? DupStatus.DUP_DB : DupStatus.NOT_DUP_DB;
        if (!needConversion) {
            return;
        }
        if (this.dupStatus == DupStatus.NOT_DUP_DB) {
            return;
        }
        this.key = this.combineDupKeyData();
    }

    byte[] combineDupKeyData() {
        assert (!this.ln.isDeleted());
        return DupKeyData.combine(this.key, this.ln.setEmpty());
    }

    public void getUserKeyData(DatabaseEntry keyParam, DatabaseEntry dataParam) {
        this.requireKnownDupStatus();
        if (this.dupStatus == DupStatus.DUP_DB) {
            DupKeyData.split(new DatabaseEntry(this.key), keyParam, dataParam);
        } else {
            if (keyParam != null) {
                keyParam.setData(this.key);
            }
            if (dataParam != null) {
                dataParam.setData(this.ln.getData());
            }
        }
    }

    public boolean isEmbeddedLN() {
        return this.embeddedLN;
    }

    public LN getLN() {
        this.requireKnownDupStatus();
        return this.ln;
    }

    public byte[] getKey() {
        this.requireKnownDupStatus();
        return this.key;
    }

    public byte[] getData() {
        return this.ln.getData();
    }

    public byte[] getEmbeddedData() {
        if (!this.isEmbeddedLN()) {
            return null;
        }
        if (this.ln.isDeleted()) {
            return Key.EMPTY_KEY;
        }
        return this.ln.getData();
    }

    private void requireKnownDupStatus() {
        if (this.dupStatus != DupStatus.DUP_DB && this.dupStatus != DupStatus.NOT_DUP_DB) {
            throw EnvironmentFailureException.unexpectedState("postFetchInit was not called");
        }
    }

    public int getUnconvertedDataLength() {
        return this.ln.getData().length;
    }

    public int getUnconvertedKeyLength() {
        return this.key.length;
    }

    @Override
    public DatabaseId getDbId() {
        return this.dbId;
    }

    public long getAbortLsn() {
        return this.abortLsn;
    }

    public boolean getAbortKnownDeleted() {
        return this.abortKnownDeleted;
    }

    public byte[] getAbortKey() {
        return this.abortKey;
    }

    public byte[] getAbortData() {
        return this.abortData;
    }

    public long getAbortVLSN() {
        return this.abortVLSN;
    }

    public Long getTxnId() {
        if (this.entryType.isTransactional()) {
            return this.txn.getId();
        }
        return null;
    }

    public Txn getUserTxn() {
        if (this.entryType.isTransactional()) {
            return this.txn;
        }
        return null;
    }

    @Override
    public boolean logicalEquals(LogEntry other) {
        if (!(other instanceof LNLogEntry)) {
            return false;
        }
        LNLogEntry otherEntry = (LNLogEntry)other;
        if (!this.dbId.logicalEquals(otherEntry.dbId)) {
            return false;
        }
        if (this.txn != null ? !this.txn.logicalEquals(otherEntry.txn) : otherEntry.txn != null) {
            return false;
        }
        if (!Arrays.equals(this.key, otherEntry.key)) {
            return false;
        }
        return this.ln.logicalEquals(otherEntry.ln);
    }

    static enum DupStatus {
        UNKNOWN,
        NEED_CONVERSION,
        DUP_DB,
        NOT_DUP_DB;

    }
}

