/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.arbiter;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentLockedException;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.EnvironmentNotFoundException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.rep.RepInternal;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.ReplicationConfig;
import com.sleepycat.je.rep.ReplicationMutableConfig;
import com.sleepycat.je.rep.arbiter.ArbiterConfig;
import com.sleepycat.je.rep.arbiter.ArbiterMutableConfig;
import com.sleepycat.je.rep.arbiter.ArbiterStats;
import com.sleepycat.je.rep.arbiter.impl.ArbiterImpl;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.utilint.DatabaseUtil;
import java.io.File;
import java.util.concurrent.TimeUnit;

public class Arbiter {
    private ArbiterImpl ai;
    private final ReplicatedEnvironment repEnv;
    private final ArbiterConfig ac;
    private final String ARB_CONFIG = "ArbiterConfig";
    private final String ARB_HOME = "ArbiterHome";

    public Arbiter(ArbiterConfig arbiterConfig) throws EnvironmentNotFoundException, EnvironmentLockedException, DatabaseException, IllegalArgumentException {
        this.ac = arbiterConfig.clone();
        this.verifyParameters(this.ac);
        File envHome = new File(this.ac.getArbiterHome());
        if (!envHome.exists()) {
            throw new IllegalArgumentException("The specified environment directory " + envHome.getAbsolutePath() + " does not exist.");
        }
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setReadOnly(true);
        envConfig.setTransactional(true);
        envConfig.setConfigParam(EnvironmentParams.ENV_RECOVERY.getName(), "false");
        envConfig.setConfigParam(EnvironmentParams.ENV_SETUP_LOGGER.getName(), "true");
        if (this.ac.isConfigParamSet(EnvironmentParams.JE_FILE_LEVEL.getName())) {
            envConfig.setConfigParam(EnvironmentParams.JE_FILE_LEVEL.getName(), this.ac.getFileLoggingLevel());
        }
        if (this.ac.isConfigParamSet(EnvironmentParams.JE_CONSOLE_LEVEL.getName())) {
            envConfig.setConfigParam(EnvironmentParams.JE_CONSOLE_LEVEL.getName(), this.ac.getConsoleLoggingLevel());
        }
        ReplicationConfig repConfig = new ReplicationConfig();
        repConfig.setGroupName(this.ac.getGroupName());
        repConfig.setNodeName(this.ac.getNodeName());
        repConfig.setNodeHostPort(this.ac.getNodeHostPort());
        repConfig.setHelperHosts(this.ac.getHelperHosts());
        repConfig.setConfigParam(RepParams.ARBITER_USE.getName(), "true");
        repConfig.setConfigParam(RepParams.ENV_UNKNOWN_STATE_TIMEOUT.getName(), this.ac.getUnknownStateTimeout(TimeUnit.SECONDS) + " s");
        repConfig.setRepNetConfig(this.ac.getRepNetConfig());
        repConfig.setConfigParam(RepParams.REPLICA_MESSAGE_QUEUE_SIZE.getName(), Integer.toString(this.ac.getMessageQueueSize()));
        repConfig.setConfigParam(RepParams.REPLICA_TIMEOUT.getName(), this.ac.getChannelTimeout(TimeUnit.SECONDS) + " s");
        repConfig.setConfigParam(RepParams.PRE_HEARTBEAT_TIMEOUT.getName(), this.ac.getPreHeartbeatTimeout(TimeUnit.SECONDS) + " s");
        repConfig.setConfigParam(RepParams.REPSTREAM_OPEN_TIMEOUT.getName(), this.ac.getStreamOpenTimeout(TimeUnit.SECONDS) + " s");
        repConfig.setConfigParam(RepParams.HEARTBEAT_INTERVAL.getName(), Integer.toString(this.ac.getHeartbeatInterval()));
        repConfig.setConfigParam(RepParams.REPLICA_RECEIVE_BUFFER_SIZE.getName(), Integer.toString(this.ac.getReceiveBufferSize()));
        repConfig.setConfigParam(RepParams.ENABLE_GROUP_ACKS.getName(), Boolean.toString(this.ac.getEnableGroupAcks()));
        this.repEnv = RepInternal.createInternalEnvHandle(envHome, repConfig, envConfig);
        try {
            this.ai = new ArbiterImpl(envHome, RepInternal.getRepImpl(this.repEnv));
            this.ai.runArbiter();
        }
        catch (Throwable t) {
            this.shutdown();
            throw t;
        }
    }

    public ArbiterMutableConfig getArbiterMutableConfig() {
        return this.ac.getArbiterMutableConfig();
    }

    public void setArbiterMutableConfig(ArbiterMutableConfig config) throws DatabaseException {
        ReplicationMutableConfig rmc = this.repEnv.getRepMutableConfig();
        rmc.setHelperHosts(config.getHelperHosts());
        this.repEnv.setRepMutableConfig(rmc);
        this.ai.refreshHelperHosts();
        EnvironmentMutableConfig emc = this.repEnv.getMutableConfig();
        if (config.isConfigParamSet(EnvironmentParams.JE_FILE_LEVEL.getName())) {
            emc.setConfigParam("com.sleepycat.je.util.FileHandler.level", config.getFileLoggingLevel());
        }
        if (config.isConfigParamSet(EnvironmentParams.JE_CONSOLE_LEVEL.getName())) {
            emc.setConfigParam("com.sleepycat.je.util.ConsoleHandler.level", config.getConsoleLoggingLevel());
        }
        this.repEnv.setMutableConfig(emc);
    }

    public ArbiterStats getStats(StatsConfig config) throws DatabaseException {
        if (this.ai == null) {
            return null;
        }
        StatsConfig useConfig = config == null ? StatsConfig.DEFAULT : config;
        return new ArbiterStats(this.ai.loadStats(useConfig));
    }

    public void shutdown() throws DatabaseException {
        if (this.ai != null) {
            this.ai.shutdown();
            try {
                this.ai.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.repEnv != null) {
            this.repEnv.close();
        }
    }

    private void verifyParameters(ArbiterConfig ac) throws IllegalArgumentException {
        DatabaseUtil.checkForNullParam(ac, "ArbiterConfig");
        DatabaseUtil.checkForNullParam(ac.getArbiterHome(), "ArbiterHome");
        DatabaseUtil.checkForNullParam(ac.getGroupName(), "je.rep.groupName");
        DatabaseUtil.checkForNullParam(ac.getNodeHostPort(), "je.rep.nodeHostPort");
        DatabaseUtil.checkForNullParam(ac.getHelperHosts(), "je.rep.helperHosts");
    }
}

