/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.cleaner.LocalUtilizationTracker;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.evictor.OffHeapCache;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogItem;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.tree.BINDeltaBloomFilter;
import com.sleepycat.je.tree.BINReference;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.INKeyRep;
import com.sleepycat.je.tree.INLongRep;
import com.sleepycat.je.tree.INTargetRep;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.MapLN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.TreeWalkerStatsAccumulator;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.utilint.DatabaseUtil;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.SizeofMarker;
import com.sleepycat.je.utilint.TinyHashSet;
import com.sleepycat.je.utilint.VLSN;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public class BIN
extends IN {
    private static final String BEGIN_TAG = "<bin>";
    private static final String END_TAG = "</bin>";
    private static final INLongRep.EmptyRep EMPTY_LAST_LOGGED_SIZES = new INLongRep.EmptyRep(1, false);
    private static final INLongRep.EmptyRep EMPTY_VLSNS = new INLongRep.EmptyRep(5, false);
    private static final INLongRep.EmptyRep EMPTY_OFFHEAP_LN_IDS = new INLongRep.EmptyRep(8, true);
    private TinyHashSet<CursorImpl> cursorSet;
    private int fullBinNEntries = -1;
    private int fullBinMaxEntries = -1;
    byte[] bloomFilter;
    private long lastDeltaVersion = -1L;
    private INLongRep vlsnCache = EMPTY_VLSNS;
    private INLongRep lastLoggedSizes = EMPTY_LAST_LOGGED_SIZES;
    private INLongRep offHeapLNIds = EMPTY_OFFHEAP_LN_IDS;
    private int offHeapLruId = -1;
    public static boolean TEST_NO_LAST_LOGGED_SIZES = false;

    public BIN() {
    }

    public BIN(DatabaseImpl db, byte[] identifierKey, int capacity, int level) {
        super(db, identifierKey, capacity, level);
    }

    public BIN(SizeofMarker marker) {
        super(marker);
    }

    @Override
    protected IN createNewInstance(byte[] identifierKey, int maxEntries, int level) {
        return new BIN(this.getDatabase(), identifierKey, maxEntries, level);
    }

    public BINReference createReference() {
        return new BINReference(this.getNodeId(), this.getDatabase().getId(), this.getIdentifierKey());
    }

    @Override
    public boolean isBIN() {
        return true;
    }

    @Override
    boolean isAlwaysLatchedExclusively() {
        return true;
    }

    @Override
    public String shortClassName() {
        return "BIN";
    }

    @Override
    public String beginTag() {
        return BEGIN_TAG;
    }

    @Override
    public String endTag() {
        return END_TAG;
    }

    boolean isVLSNCachingEnabled() {
        return !this.databaseImpl.getSortedDuplicates() && this.getEnv().getCacheVLSN();
    }

    public void setCachedVLSN(int idx, long vlsn) {
        if (!this.isVLSNCachingEnabled()) {
            return;
        }
        this.setCachedVLSNUnconditional(idx, vlsn);
    }

    void setCachedVLSNUnconditional(int idx, long vlsn) {
        this.vlsnCache = this.vlsnCache.set(idx, vlsn == -1L ? 0L : vlsn, this);
    }

    void setCachedVLSNDuringLogrecRead(int idx, long vlsn) {
        this.vlsnCache = this.vlsnCache.set(idx, vlsn == -1L ? 0L : vlsn, this);
    }

    long getCachedVLSN(int idx) {
        long vlsn = this.vlsnCache.get(idx);
        return vlsn == 0L ? -1L : vlsn;
    }

    public long getVLSN(int idx, boolean allowFetch, CacheMode cacheMode) {
        LN ln = (LN)this.getTarget(idx);
        if (ln != null) {
            return ln.getVLSNSequence();
        }
        long vlsn = this.getCachedVLSN(idx);
        if (!VLSN.isNull(vlsn)) {
            return vlsn;
        }
        OffHeapCache ohCache = this.getOffHeapCache();
        if (ohCache != null && !VLSN.isNull(vlsn = ohCache.loadVLSN(this, idx))) {
            return vlsn;
        }
        if (!allowFetch || this.isEmbeddedLN(idx)) {
            return vlsn;
        }
        ln = this.fetchLN(idx, cacheMode);
        return ln.getVLSNSequence();
    }

    public INLongRep getVLSNCache() {
        return this.vlsnCache;
    }

    @Override
    boolean isLastLoggedSizeStored(int idx) {
        return this.mayHaveLastLoggedSizeStored() && !this.isEmbeddedLN(idx);
    }

    @Override
    boolean mayHaveLastLoggedSizeStored() {
        if (DatabaseUtil.TEST && TEST_NO_LAST_LOGGED_SIZES && !this.databaseImpl.getDbType().isInternal()) {
            return false;
        }
        return !this.databaseImpl.isLNImmediatelyObsolete();
    }

    @Override
    public void setLastLoggedSize(int idx, int lastLoggedSize) {
        if (lastLoggedSize < 0 || !this.isLastLoggedSizeStored(idx)) {
            return;
        }
        this.setLastLoggedSizeUnconditional(idx, lastLoggedSize);
    }

    @Override
    public void clearLastLoggedSize(int idx) {
        this.setLastLoggedSizeUnconditional(idx, 0);
    }

    @Override
    void setLastLoggedSizeUnconditional(int idx, int lastLoggedSize) {
        this.lastLoggedSizes = this.lastLoggedSizes.set(idx, lastLoggedSize, this);
    }

    @Override
    public int getLastLoggedSize(int idx) {
        if (this.isLastLoggedSizeStored(idx)) {
            return (int)this.lastLoggedSizes.get(idx);
        }
        return 0;
    }

    public int getLastLoggedSizeUnconditional(int idx) {
        return (int)this.lastLoggedSizes.get(idx);
    }

    public void setOffHeapLNId(int idx, long memId) {
        if (this.offHeapLNIds.get(idx) == memId) {
            return;
        }
        this.offHeapLNIds = this.offHeapLNIds.set(idx, memId, this);
        this.makeStaleIfOffHeap();
    }

    public void clearOffHeapLNIds() {
        this.offHeapLNIds = this.offHeapLNIds.clear(this, EMPTY_OFFHEAP_LN_IDS);
    }

    public long getOffHeapLNIdsMemorySize() {
        return this.offHeapLNIds.getMemorySize();
    }

    public long getOffHeapLNId(int idx) {
        return this.offHeapLNIds.get(idx);
    }

    public boolean hasOffHeapLNs() {
        return !this.offHeapLNIds.isEmpty();
    }

    public void setOffHeapLruId(int id) {
        assert (id >= 0 || !this.hasOffHeapLNs());
        this.offHeapLruId = id;
    }

    public int getOffHeapLruId() {
        return this.offHeapLruId;
    }

    void freeOffHeapLN(int idx) {
        OffHeapCache ohCache = this.getOffHeapCache();
        if (ohCache == null) {
            return;
        }
        ohCache.freeLN(this, idx);
    }

    @Override
    void setTarget(int idx, Node target) {
        Node oldTarget;
        if (target == null && (oldTarget = this.getTarget(idx)) instanceof LN) {
            this.setCachedVLSN(idx, ((LN)oldTarget).getVLSNSequence());
        }
        super.setTarget(idx, target);
    }

    @Override
    void appendEntryFromOtherNode(IN from, int fromIdx) {
        super.appendEntryFromOtherNode(from, fromIdx);
        BIN fromBin = (BIN)from;
        int idx = this.nEntries - 1;
        this.setCachedVLSNUnconditional(idx, fromBin.getCachedVLSN(fromIdx));
        this.setLastLoggedSizeUnconditional(idx, from.getLastLoggedSize(fromIdx));
        OffHeapCache ohCache = this.getOffHeapCache();
        if (ohCache != null) {
            this.offHeapLNIds = this.offHeapLNIds.set(idx, fromBin.offHeapLNIds.get(fromIdx), this);
            ohCache.ensureOffHeapLNsInLRU(this);
        }
    }

    @Override
    void copyEntries(int from, int to, int n) {
        super.copyEntries(from, to, n);
        this.vlsnCache = this.vlsnCache.copy(from, to, n, this);
        this.lastLoggedSizes = this.lastLoggedSizes.copy(from, to, n, this);
        this.offHeapLNIds = this.offHeapLNIds.copy(from, to, n, this);
    }

    @Override
    void clearEntry(int idx) {
        super.clearEntry(idx);
        this.setCachedVLSNUnconditional(idx, -1L);
        this.setLastLoggedSizeUnconditional(idx, 0);
        this.offHeapLNIds.set(idx, 0L, this);
    }

    public Set<CursorImpl> getCursorSet() {
        if (this.cursorSet == null) {
            return Collections.emptySet();
        }
        return this.cursorSet.copy();
    }

    public void addCursor(CursorImpl cursor) {
        assert (this.isLatchExclusiveOwner());
        if (this.cursorSet == null) {
            this.cursorSet = new TinyHashSet();
        }
        this.cursorSet.add(cursor);
    }

    public void removeCursor(CursorImpl cursor) {
        assert (this.isLatchExclusiveOwner());
        if (this.cursorSet == null) {
            return;
        }
        this.cursorSet.remove(cursor);
        if (this.cursorSet.size() == 0) {
            this.cursorSet = null;
        }
    }

    public int nCursors() {
        TinyHashSet<CursorImpl> cursors = this.cursorSet;
        if (cursors == null) {
            return 0;
        }
        return cursors.size();
    }

    @Override
    void adjustCursors(IN newSibling, int newSiblingLow, int newSiblingHigh) {
        assert (newSibling.isLatchExclusiveOwner());
        assert (this.isLatchExclusiveOwner());
        if (this.cursorSet == null) {
            return;
        }
        int adjustmentDelta = newSiblingHigh - newSiblingLow;
        Iterator<CursorImpl> iter = this.cursorSet.iterator();
        while (iter.hasNext()) {
            CursorImpl cursor = iter.next();
            int cIdx = cursor.getIndex();
            cursor.assertBIN(this);
            assert (newSibling instanceof BIN);
            BIN ns = (BIN)newSibling;
            if (newSiblingLow == 0) {
                if (cIdx < newSiblingHigh) {
                    iter.remove();
                    cursor.setBIN(ns);
                    ns.addCursor(cursor);
                    continue;
                }
                cursor.setIndex(cIdx - adjustmentDelta);
                continue;
            }
            if (cIdx < newSiblingLow) continue;
            cursor.setIndex(cIdx - newSiblingLow);
            iter.remove();
            cursor.setBIN(ns);
            ns.addCursor(cursor);
        }
    }

    public void verifyCursors() {
        if (this.cursorSet == null) {
            return;
        }
        for (CursorImpl cursor : this.cursorSet) {
            cursor.assertBIN(this);
        }
    }

    @Override
    void adjustCursorsForInsert(int insertIndex) {
        assert (this.isLatchExclusiveOwner());
        if (this.cursorSet == null) {
            return;
        }
        for (CursorImpl cursor : this.cursorSet) {
            int cIdx = cursor.getIndex();
            if (insertIndex > cIdx) continue;
            cursor.setIndex(cIdx + 1);
        }
    }

    @Override
    IN splitSpecial(IN parent, int parentIndex, IN grandParent, int maxEntriesPerNode, byte[] key, boolean leftSide, CacheMode cacheMode) throws DatabaseException {
        int nEntries = this.getNEntries();
        int index = this.findEntry(key, true, false);
        boolean exact = (index & 0x10000) != 0;
        if (leftSide && (index &= 0xFFFEFFFF) < 0) {
            return this.splitInternal(parent, parentIndex, grandParent, maxEntriesPerNode, 1, cacheMode);
        }
        if (!leftSide && !exact && index == nEntries - 1) {
            return this.splitInternal(parent, parentIndex, grandParent, maxEntriesPerNode, nEntries - 1, cacheMode);
        }
        return this.split(parent, parentIndex, grandParent, maxEntriesPerNode, cacheMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compress(LocalUtilizationTracker localTracker) throws DatabaseException {
        if (!this.databaseImpl.getEnv().isValid()) {
            return false;
        }
        if (this.nCursors() > 0) {
            throw EnvironmentFailureException.unexpectedState();
        }
        if (this.isBINDelta()) {
            throw EnvironmentFailureException.unexpectedState();
        }
        boolean setNewIdKey = false;
        boolean anyLocksDenied = false;
        DatabaseImpl db = this.getDatabase();
        EnvironmentImpl envImpl = db.getEnv();
        for (int i = 0; i < this.getNEntries(); ++i) {
            if (!this.isEntryPendingDeleted(i) && !this.isEntryKnownDeleted(i)) continue;
            BasicLocker lockingTxn = BasicLocker.createBasicLocker(envImpl);
            lockingTxn.setPreemptable(false);
            try {
                LN ln;
                LockResult lockRet;
                long lsn = this.getLsn(i);
                if (lsn != -1L && (lockRet = lockingTxn.nonBlockingLock(lsn, LockType.READ, false, db)).getLockGrant() == LockGrantType.DENIED) {
                    anyLocksDenied = true;
                    continue;
                }
                if (this.entryKeys.compareKeys(this.getIdentifierKey(), this.keyPrefix, i, this.haveEmbeddedData(i), this.getKeyComparator()) == 0) {
                    setNewIdKey = true;
                }
                if (db.isDeferredWriteMode() && (ln = (LN)this.getTarget(i)) != null && ln.isDirty() && !DbLsn.isTransient(lsn)) {
                    if (db.isTemporary()) {
                        if (localTracker != null) {
                            localTracker.countObsoleteNode(lsn, ln.getGenericLogType(), this.getLastLoggedSize(i), db);
                        } else {
                            envImpl.getLogManager().countObsoleteNode(lsn, ln.getGenericLogType(), this.getLastLoggedSize(i), db, true);
                        }
                    } else {
                        this.logDirtyLN(i, ln, true);
                    }
                }
                boolean deleteSuccess = this.deleteEntry(i, true);
                assert (deleteSuccess);
                --i;
                continue;
            }
            finally {
                lockingTxn.operationEnd();
            }
        }
        if (this.getNEntries() != 0 && setNewIdKey) {
            this.setIdentifierKey(this.getKey(0));
        }
        if (this.getNEntries() == 0) {
            this.updateLRU(CacheMode.MAKE_COLD);
        }
        return !anyLocksDenied;
    }

    public void queueSlotDeletion() {
        if (this.shouldLogDelta()) {
            return;
        }
        this.getEnv().addToCompressorQueue(this, false);
    }

    @Override
    public boolean isCompressible() {
        return !this.isBINDelta();
    }

    @Override
    boolean validateSubtreeBeforeDelete(int index) {
        assert (!this.isBINDelta());
        return true;
    }

    @Override
    boolean isValidForDelete() throws DatabaseException {
        assert (this.isLatchExclusiveOwner());
        if (this.isBINDelta()) {
            return false;
        }
        int numValidEntries = 0;
        for (int i = 0; i < this.getNEntries(); ++i) {
            if (this.isEntryKnownDeleted(i)) continue;
            ++numValidEntries;
        }
        if (numValidEntries > 0) {
            return false;
        }
        return this.nCursors() <= 0;
    }

    @Override
    public long compactMemory() {
        long oldSize = this.inMemorySize;
        super.compactMemory();
        this.offHeapLNIds = this.offHeapLNIds.compact(this, EMPTY_OFFHEAP_LN_IDS);
        return oldSize - this.inMemorySize;
    }

    @Override
    public long computeMemorySize() {
        long size = super.computeMemorySize();
        if (this.vlsnCache != null) {
            size += this.vlsnCache.getMemorySize();
        }
        if (this.lastLoggedSizes != null) {
            size += this.lastLoggedSizes.getMemorySize();
        }
        if (this.offHeapLNIds != null) {
            size += this.offHeapLNIds.getMemorySize();
        }
        if (this.bloomFilter != null) {
            size += (long)BINDeltaBloomFilter.getMemorySize(this.bloomFilter);
        }
        return size;
    }

    @Override
    protected long printMemorySize() {
        long inTotal = super.printMemorySize();
        long vlsnCacheOverhead = this.vlsnCache.getMemorySize();
        long logSizesOverhead = this.lastLoggedSizes.getMemorySize();
        long offHeapLNIdOverhead = this.offHeapLNIds.getMemorySize();
        long binTotal = inTotal + vlsnCacheOverhead + logSizesOverhead + offHeapLNIdOverhead;
        System.out.format("BIN: %d vlsns: %d logSizes: %d offHeapLNIds: %d %n", binTotal, vlsnCacheOverhead, logSizesOverhead, offHeapLNIdOverhead);
        return binTotal;
    }

    @Override
    protected long getFixedMemoryOverhead() {
        return MemoryBudget.BIN_FIXED_OVERHEAD;
    }

    @Override
    public long getTreeAdminMemorySize() {
        if (this.getDatabase().getId().equals(DbTree.ID_DB_ID)) {
            long treeAdminMem = 0L;
            for (int i = 0; i < this.getMaxEntries(); ++i) {
                Node n = this.getTarget(i);
                if (n == null) continue;
                MapLN mapLN = (MapLN)n;
                treeAdminMem += mapLN.getDatabase().getTreeAdminMemory();
            }
            return treeAdminMem;
        }
        return 0L;
    }

    @Override
    public long partialEviction() {
        long lnEvictionBytes = this.evictLNs();
        if (lnEvictionBytes != 0L) {
            return lnEvictionBytes;
        }
        return this.discardVLSNCache();
    }

    public long discardVLSNCache() {
        long vlsnBytes = this.vlsnCache.getMemorySize();
        if (vlsnBytes > 0L) {
            int numEntries = this.getNEntries();
            for (int i = 0; i < numEntries; ++i) {
                if (!this.isEmbeddedLN(i)) continue;
                return 0L;
            }
            this.vlsnCache = EMPTY_VLSNS;
            this.updateMemorySize(0L - vlsnBytes);
        }
        return vlsnBytes;
    }

    public long evictLNs() throws DatabaseException {
        assert (this.isLatchExclusiveOwner()) : "BIN must be latched before evicting LNs";
        if (this.nCursors() > 0) {
            return 0x4000000000000000L;
        }
        long totalRemoved = 0L;
        long numLNsEvicted = 0L;
        boolean haveNonEvictableLN = false;
        for (int i = 0; i < this.getNEntries(); ++i) {
            if (this.getTarget(i) == null) continue;
            long lnRemoved = this.evictLNInternal(i, false);
            if (lnRemoved < 0L) {
                haveNonEvictableLN = true;
                continue;
            }
            totalRemoved += lnRemoved;
            ++numLNsEvicted;
        }
        if (totalRemoved > 0L) {
            this.updateMemorySize(totalRemoved, 0L);
            totalRemoved += this.compactMemory();
        }
        this.getEvictor().incNumLNsEvicted(numLNsEvicted);
        if (haveNonEvictableLN) {
            return totalRemoved | 0x4000000000000000L;
        }
        return totalRemoved;
    }

    public void evictLN(int index) {
        this.evictLN(index, false);
    }

    public void evictLN(int index, boolean ifFetchedCold) throws DatabaseException {
        long removed = this.evictLNInternal(index, ifFetchedCold);
        if (removed > 0L) {
            this.updateMemorySize(removed, 0L);
            this.compactMemory();
        }
    }

    private long evictLNInternal(int index, boolean ifFetchedCold) throws DatabaseException {
        Node n = this.getTarget(index);
        assert (n == null || n instanceof LN);
        if (n == null) {
            return 0L;
        }
        LN ln = (LN)n;
        if (ifFetchedCold && !ln.getFetchedCold()) {
            return 0L;
        }
        if (!ln.isEvictable(this.getLsn(index))) {
            return -1L;
        }
        this.logDirtyLN(index, ln, false);
        this.setTarget(index, null);
        ln.releaseMemoryBudget();
        OffHeapCache ohCache = this.getOffHeapCache();
        if (ohCache != null) {
            ohCache.storeEvictedLN(this, index, ln);
        }
        return n.getMemorySizeIncludedByParent();
    }

    @Override
    public void logDirtyChildren() throws DatabaseException {
        for (int i = 0; i < this.getNEntries(); ++i) {
            Node node = this.getTarget(i);
            if (node == null) continue;
            this.logDirtyLN(i, (LN)node, true);
        }
    }

    private void logDirtyLN(int idx, LN ln, boolean allowEviction) throws DatabaseException {
        boolean force;
        long currLsn = this.getLsn(idx);
        boolean bl = force = this.getDatabase().isDeferredWriteMode() && DbLsn.isTransientOrNull(currLsn);
        if (force || ln.isDirty()) {
            DatabaseImpl dbImpl = this.getDatabase();
            EnvironmentImpl envImpl = dbImpl.getEnv();
            assert (dbImpl.isDeferredWriteMode() || ln instanceof MapLN);
            LogItem logItem = ln.log(envImpl, dbImpl, null, null, this.isEmbeddedLN(idx), this.getKey(idx), this.isEmbeddedLN(idx), currLsn, this.getLastLoggedSize(idx), false, true, ReplicationContext.NO_REPLICATE);
            this.updateEntry(idx, logItem.lsn, ln.getVLSNSequence(), logItem.size);
            CursorImpl.lockAfterLsnChange(dbImpl, currLsn, logItem.lsn, null);
            if (allowEviction && (this.databaseImpl.isLNImmediatelyObsolete() || this.isEmbeddedLN(idx))) {
                this.evictLN(idx);
            }
        }
    }

    @Override
    public LogEntryType getLogType() {
        return LogEntryType.LOG_BIN;
    }

    @Override
    public long getLastDeltaLsn() {
        return this.lastDeltaVersion;
    }

    public void setLastDeltaLsn(long lsn) {
        this.lastDeltaVersion = lsn;
    }

    public int getFullBinNEntries() {
        if (this.isBINDelta()) {
            return this.fullBinNEntries;
        }
        return this.nEntries;
    }

    public void setFullBinNEntries(int n) {
        assert (this.isBINDelta(false));
        this.fullBinNEntries = n;
    }

    void incFullBinNEntries() {
        assert (this.isBINDelta());
        ++this.fullBinNEntries;
    }

    public int getFullBinMaxEntries() {
        if (this.isBINDelta()) {
            return this.fullBinMaxEntries;
        }
        return this.getMaxEntries();
    }

    public void setFullBinMaxEntries(int n) {
        assert (this.isBINDelta(false));
        this.fullBinMaxEntries = n;
    }

    int getDeltaCapacity(int numDirtyEntries) {
        boolean blindOps;
        boolean bl = blindOps = this.getEnv().allowBlindOps() || this.getEnv().allowBlindPuts();
        if (this.isBINDelta()) {
            return this.getMaxEntries();
        }
        if (blindOps) {
            return this.getNEntries() * this.databaseImpl.getBinDeltaPercent() / 100;
        }
        return numDirtyEntries;
    }

    boolean allowBlindPuts() {
        boolean res = this.getEnv().allowBlindPuts();
        if (res) {
            res = res && this.databaseImpl.hasBtreeBinaryEqualityComparator();
            res = res && this.databaseImpl.hasDuplicateBinaryEqualityComparator();
        }
        return res;
    }

    byte[] createBloomFilter() {
        assert (this.bloomFilter == null || this.isBINDelta());
        boolean blindPuts = this.allowBlindPuts();
        if (!blindPuts) {
            assert (this.bloomFilter == null);
            return null;
        }
        if (this.bloomFilter != null) {
            return this.bloomFilter;
        }
        if (this.isBINDelta()) {
            return null;
        }
        int numKeys = this.getNEntries() - this.getNDeltas();
        int nbytes = BINDeltaBloomFilter.getByteSize(numKeys);
        byte[] bf = new byte[nbytes];
        BINDeltaBloomFilter.HashContext hc = new BINDeltaBloomFilter.HashContext();
        if (this.keyPrefix != null) {
            hc.hashKeyPrefix(this.keyPrefix);
        }
        for (int i = 0; i < this.getNEntries(); ++i) {
            if (this.isDirty(i)) continue;
            byte[] suffix = this.entryKeys.getKey(i, this.haveEmbeddedData(i));
            if (suffix == null) {
                suffix = Key.EMPTY_KEY;
            }
            BINDeltaBloomFilter.add(bf, suffix, hc);
        }
        return bf;
    }

    public boolean mayHaveKeyInFullBin(byte[] key) {
        assert (this.isBINDelta());
        if (this.bloomFilter == null) {
            return true;
        }
        return BINDeltaBloomFilter.contains(this.bloomFilter, key);
    }

    int getBloomFilterLogSize() {
        if (!this.allowBlindPuts()) {
            return 0;
        }
        if (this.isBINDelta()) {
            if (this.bloomFilter != null) {
                return BINDeltaBloomFilter.getLogSize(this.bloomFilter);
            }
            return 0;
        }
        assert (this.bloomFilter == null);
        int numKeys = this.getNEntries() - this.getNDeltas();
        return BINDeltaBloomFilter.getLogSize(numKeys);
    }

    boolean isDeltaProhibited() {
        return this.getProhibitNextDelta() || this.getDatabase().isDeferredWriteMode() || this.getLastFullLsn() == -1L;
    }

    public boolean shouldLogDelta() {
        if (this.isBINDelta()) {
            assert (!this.isDeltaProhibited());
            return true;
        }
        if (this.isDeltaProhibited()) {
            return false;
        }
        int numDeltas = this.getNDeltas();
        if (numDeltas <= 0) {
            return false;
        }
        int deltaLimit = this.getNEntries() * this.databaseImpl.getBinDeltaPercent() / 100;
        return numDeltas <= deltaLimit;
    }

    public boolean canMutateToBINDelta() {
        return !this.isBINDelta() && this.shouldLogDelta() && this.nCursors() == 0;
    }

    public long mutateToBINDelta() {
        assert (this.isLatchExclusiveOwner());
        assert (this.canMutateToBINDelta());
        if (this.getInListResident()) {
            this.getEnv().getInMemoryINs().updateBINDeltaStat(1);
        }
        long oldSize = this.getInMemorySize();
        int nDeltas = this.getNDeltas();
        int capacity = this.getDeltaCapacity(nDeltas);
        this.bloomFilter = this.createBloomFilter();
        this.initBINDelta(this, nDeltas, capacity, true);
        return oldSize - this.getInMemorySize();
    }

    public BIN cloneBINDelta() {
        assert (this.isBINDelta());
        BIN bin = new BIN(this.databaseImpl, this.getIdentifierKey(), 0, this.getLevel());
        bin.nodeId = this.nodeId;
        bin.flags = this.flags;
        bin.lastFullVersion = this.lastFullVersion;
        int nDeltas = this.getNDeltas();
        this.initBINDelta(bin, nDeltas, nDeltas, false);
        return bin;
    }

    private void initBINDelta(BIN destBIN, int nDeltas, int capacity, boolean copyTargets) {
        long[] longLSNs = null;
        byte[] compactLSNs = null;
        if (this.entryLsnLongArray == null) {
            compactLSNs = new byte[nDeltas * 4];
        } else {
            longLSNs = new long[nDeltas];
        }
        long[] vlsns = new long[nDeltas];
        int[] sizes = new int[nDeltas];
        byte[][] keys = new byte[nDeltas][];
        byte[] states = new byte[nDeltas];
        long[] memIds = null;
        Node[] targets = null;
        if (copyTargets) {
            targets = new Node[nDeltas];
            memIds = new long[nDeltas];
        }
        int j = 0;
        for (int i = 0; i < this.getNEntries(); ++i) {
            if (!this.isDirty(i)) {
                this.freeOffHeapLN(i);
                continue;
            }
            if (this.entryLsnLongArray == null) {
                int doff = j << 2;
                int soff = i << 2;
                compactLSNs[doff] = this.entryLsnByteArray[soff];
                compactLSNs[doff + 1] = this.entryLsnByteArray[soff + 1];
                compactLSNs[doff + 2] = this.entryLsnByteArray[soff + 2];
                compactLSNs[doff + 3] = this.entryLsnByteArray[soff + 3];
            } else {
                longLSNs[j] = this.getLsn(i);
            }
            keys[j] = (byte[])this.entryKeys.get(i);
            states[j] = this.getState(i);
            if (targets != null) {
                targets[j] = this.getTarget(i);
            }
            if (memIds != null) {
                memIds[j] = this.getOffHeapLNId(i);
            }
            vlsns[j] = this.getCachedVLSN(i);
            sizes[j] = this.getLastLoggedSize(i);
            ++j;
        }
        destBIN.fullBinNEntries = this.getFullBinNEntries();
        destBIN.fullBinMaxEntries = this.getFullBinMaxEntries();
        destBIN.resetContent(capacity, nDeltas, this.baseFileNumber, compactLSNs, longLSNs, states, this.keyPrefix, keys, targets, sizes, memIds, vlsns);
        destBIN.setBINDelta(true);
        destBIN.compactMemory();
    }

    private void resetContent(int capacity, int newNEntries, long baseFileNumber, byte[] compactLSNs, long[] longLSNs, byte[] states, byte[] keyPrefix, byte[][] keys, Node[] targets, int[] loggedSizes, long[] memIds, long[] vlsns) {
        this.updateRepCacheStats(false);
        this.nEntries = newNEntries;
        this.baseFileNumber = baseFileNumber;
        if (longLSNs == null) {
            this.entryLsnByteArray = new byte[capacity << 2];
            this.entryLsnLongArray = null;
        } else {
            this.entryLsnByteArray = null;
            this.entryLsnLongArray = new long[capacity];
        }
        this.keyPrefix = keyPrefix;
        this.entryKeys = new INKeyRep.Default(capacity);
        this.entryTargets = INTargetRep.NONE;
        this.vlsnCache = EMPTY_VLSNS;
        this.lastLoggedSizes = EMPTY_LAST_LOGGED_SIZES;
        this.offHeapLNIds = EMPTY_OFFHEAP_LN_IDS;
        this.updateRepCacheStats(true);
        this.entryStates = new byte[capacity];
        for (int i = 0; i < newNEntries; ++i) {
            if (longLSNs == null) {
                int off = i << 2;
                this.entryLsnByteArray[off] = compactLSNs[off];
                this.entryLsnByteArray[off + 1] = compactLSNs[off + 1];
                this.entryLsnByteArray[off + 2] = compactLSNs[off + 2];
                this.entryLsnByteArray[off + 3] = compactLSNs[off + 3];
            } else {
                this.entryLsnLongArray[i] = longLSNs[i];
            }
            this.entryKeys = (INKeyRep)this.entryKeys.set(i, keys[i], this);
            this.entryStates[i] = states[i];
            if (targets != null) {
                this.entryTargets = (INTargetRep)this.entryTargets.set(i, targets[i], this);
            }
            if (memIds != null) {
                this.setOffHeapLNId(i, memIds[i]);
            }
            this.setLastLoggedSizeUnconditional(i, loggedSizes[i]);
            this.setCachedVLSNUnconditional(i, vlsns[i]);
        }
        this.updateMemorySize(this.inMemorySize, this.computeMemorySize());
    }

    @Override
    public void mutateToFullBIN() {
        if (!this.isBINDelta()) {
            return;
        }
        BIN fullBIN = this.fetchFullBIN(this.databaseImpl);
        this.mutateToFullBIN(fullBIN);
        Evictor e = this.getEvictor();
        if (e == null) {
            return;
        }
        e.incFullBINMissStats();
    }

    public void mutateToFullBIN(BIN fullBIN) {
        int index;
        assert (this.isLatchExclusiveOwner());
        assert (this.isBINDelta()) : this;
        Object keys = null;
        int i = 0;
        if (this.cursorSet != null) {
            keys = new byte[this.cursorSet.size()][];
            for (CursorImpl cursor : this.cursorSet) {
                index = cursor.getIndex();
                if (index >= 0 && index < this.getNEntries()) {
                    keys[i] = cursor.getCurrentKey(true);
                }
                ++i;
            }
        }
        this.reconstituteBIN(this.databaseImpl, fullBIN);
        this.resetContent(fullBIN);
        this.setBINDelta(false);
        this.compactMemory();
        if (this.cursorSet != null) {
            i = 0;
            for (CursorImpl cursor : this.cursorSet) {
                if (keys[i] != null) {
                    index = this.findEntry(keys[i], true, false);
                    if ((index & 0x10000) == 0) {
                        throw EnvironmentFailureException.unexpectedState(this.getEnv(), "Failed to reposition cursor during mutation of a BIN delta to a full BIN");
                    }
                    assert ((index &= 0xFFFEFFFF) >= 0 && index < this.getNEntries());
                    cursor.setIndex(index);
                }
                ++i;
            }
        }
        if (this.getInListResident()) {
            this.getEnv().getInMemoryINs().updateBINDeltaStat(-1);
        }
    }

    private BIN fetchFullBIN(DatabaseImpl dbImpl) {
        EnvironmentImpl envImpl = dbImpl.getEnv();
        long lsn = this.getLastFullLsn();
        try {
            return (BIN)envImpl.getLogManager().getEntryHandleFileNotFound(lsn);
        }
        catch (EnvironmentFailureException e) {
            e.addErrorMessage(BIN.makeFetchErrorMsg(null, this, lsn, (byte)0));
            throw e;
        }
        catch (RuntimeException e) {
            throw new EnvironmentFailureException(envImpl, EnvironmentFailureReason.LOG_INTEGRITY, BIN.makeFetchErrorMsg(e.toString(), this, lsn, (byte)0), e);
        }
    }

    private void resetContent(BIN other) {
        this.updateRepCacheStats(false);
        this.nEntries = other.nEntries;
        this.baseFileNumber = other.baseFileNumber;
        this.entryLsnByteArray = other.entryLsnByteArray;
        this.entryLsnLongArray = other.entryLsnLongArray;
        this.keyPrefix = other.keyPrefix;
        this.entryKeys = other.entryKeys;
        this.entryTargets = other.entryTargets;
        this.entryStates = other.entryStates;
        this.lastLoggedSizes = other.lastLoggedSizes;
        this.offHeapLNIds = other.offHeapLNIds;
        assert (this.getOffHeapLruId() >= 0 || !this.hasOffHeapLNs());
        this.vlsnCache = other.vlsnCache;
        this.bloomFilter = null;
        this.updateMemorySize(this.inMemorySize, this.computeMemorySize());
        this.updateRepCacheStats(true);
    }

    public BIN reconstituteBIN(DatabaseImpl dbImpl) {
        BIN fullBIN = this.fetchFullBIN(dbImpl);
        this.reconstituteBIN(dbImpl, fullBIN);
        return fullBIN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconstituteBIN(DatabaseImpl dbImpl, BIN fullBIN) {
        fullBIN.setDatabase(dbImpl);
        fullBIN.latch(CacheMode.UNCHANGED);
        if (this.databaseImpl == null) {
            this.setDatabase(dbImpl);
        }
        assert (fullBIN.getOffHeapLruId() < 0);
        assert (!fullBIN.hasOffHeapLNs());
        try {
            fullBIN.setLastFullLsn(this.getLastFullLsn());
            for (int i = 0; i < this.getNEntries(); ++i) {
                assert (this.isDirty(i)) : this;
                fullBIN.applyDelta(this.getKey(i), this.getData(i), this.getLsn(i), this.getState(i), this.getLastLoggedSize(i), this.getOffHeapLNId(i), this.getCachedVLSN(i), this.getTarget(i));
            }
            fullBIN.setDirty(false);
        }
        finally {
            fullBIN.releaseLatch();
        }
    }

    void applyDelta(byte[] key, byte[] data, long lsn, byte state, int lastLoggedSize, long ohLnId, long vlsn, Node child) {
        int foundIndex = this.findEntry(key, true, false);
        if (foundIndex >= 0 && (foundIndex & 0x10000) != 0) {
            this.applyDeltaSlot(foundIndex &= 0xFFFEFFFF, child, lsn, lastLoggedSize, state, key, data);
        } else {
            int result = this.insertEntry1(child, key, data, lsn, state, false);
            assert ((result & 0x20000) != 0);
            foundIndex = result & 0xFFFDFFFF;
            this.setLastLoggedSizeUnconditional(foundIndex, lastLoggedSize);
        }
        this.setCachedVLSNUnconditional(foundIndex, vlsn);
        this.setOffHeapLNId(foundIndex, ohLnId);
    }

    @Override
    void accumulateStats(TreeWalkerStatsAccumulator acc) {
        acc.processBIN(this, this.getNodeId(), this.getLevel());
    }
}

