/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.dbi.DupKeyData;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.INArrayRep;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.utilint.SizeofMarker;
import java.util.Comparator;

public abstract class INKeyRep
extends INArrayRep<INKeyRep, Type, byte[]> {
    public abstract int length();

    public abstract boolean accountsForKeyByteMemUsage();

    public abstract INKeyRep set(int var1, byte[] var2, byte[] var3, IN var4);

    public abstract INKeyRep setData(int var1, byte[] var2, IN var3);

    public abstract byte[] getData(int var1);

    public abstract byte[] getKey(int var1, boolean var2);

    public abstract byte[] getFullKey(byte[] var1, int var2, boolean var3);

    public abstract int compareKeys(byte[] var1, byte[] var2, int var3, boolean var4, Comparator<byte[]> var5);

    public static class MaxKeySize
    extends INKeyRep {
        private static final int LENGTH_BYTES = 1;
        public static final byte DEFAULT_MAX_KEY_LENGTH = 16;
        public static final int MAX_KEYS = 256;
        private static final byte NULL_KEY = 127;
        private final byte[] keys;
        private final short fixedKeyLen;

        public MaxKeySize(int nodeMaxEntries, short maxKeyLen) {
            assert (maxKeyLen < 255);
            this.fixedKeyLen = (short)(maxKeyLen + 1);
            this.keys = new byte[this.fixedKeyLen * nodeMaxEntries];
            for (int i = 0; i < nodeMaxEntries; ++i) {
                INKeyRep rep = this.set(i, null, null);
                assert (rep == this);
            }
        }

        public MaxKeySize(SizeofMarker marker) {
            this.keys = null;
            this.fixedKeyLen = 0;
        }

        @Override
        public Type getType() {
            return Type.MAX_KEY_SIZE;
        }

        @Override
        public int length() {
            return this.keys.length / this.fixedKeyLen;
        }

        @Override
        public INKeyRep set(int idx, byte[] key, IN parent) {
            int slotOff = idx * this.fixedKeyLen;
            if (key == null) {
                this.keys[slotOff] = 127;
                return this;
            }
            if (key.length >= this.fixedKeyLen) {
                Default newRep = this.expandToDefaultRep(parent);
                return newRep.set(idx, key, parent);
            }
            this.keys[slotOff] = (byte)(key.length + -128);
            System.arraycopy(key, 0, this.keys, ++slotOff, key.length);
            return this;
        }

        @Override
        public INKeyRep set(int idx, byte[] key, byte[] data, IN parent) {
            if (data == null || data.length == 0) {
                return this.set(idx, key, parent);
            }
            byte[] twoPartKey = DupKeyData.combine(key, data);
            return this.set(idx, twoPartKey, parent);
        }

        @Override
        public INKeyRep setData(int idx, byte[] data, IN parent) {
            return this.set(idx, this.getKey(idx, true), data, parent);
        }

        private Default expandToDefaultRep(IN parent) {
            int capacity = this.length();
            Default newRep = new Default(capacity);
            for (int i = 0; i < capacity; ++i) {
                byte[] k = this.get(i);
                INKeyRep rep = newRep.set(i, k, parent);
                assert (rep == newRep);
            }
            this.noteRepChange(newRep, parent);
            return newRep;
        }

        @Override
        public byte[] get(int idx) {
            int slotOff = idx * this.fixedKeyLen;
            if (this.keys[slotOff] == 127) {
                return null;
            }
            int slotLen = this.keys[slotOff] - -128;
            byte[] info = new byte[slotLen];
            System.arraycopy(this.keys, ++slotOff, info, 0, slotLen);
            return info;
        }

        @Override
        public byte[] getData(int idx) {
            int slotOff = idx * this.fixedKeyLen;
            assert (this.keys[slotOff] != 127);
            int slotLen = this.keys[slotOff] - -128;
            return DupKeyData.getData(this.keys, ++slotOff, slotLen);
        }

        @Override
        public byte[] getKey(int idx, boolean embeddedData) {
            int slotOff = idx * this.fixedKeyLen;
            if (this.keys[slotOff] == 127) {
                assert (!embeddedData);
                return Key.EMPTY_KEY;
            }
            int slotLen = this.keys[slotOff] - -128;
            ++slotOff;
            if (embeddedData) {
                return DupKeyData.getKey(this.keys, slotOff, slotLen);
            }
            byte[] key = new byte[slotLen];
            System.arraycopy(this.keys, slotOff, key, 0, slotLen);
            return key;
        }

        @Override
        public byte[] getFullKey(byte[] prefix, int idx, boolean embeddedData) {
            if (prefix == null || prefix.length == 0) {
                return this.getKey(idx, embeddedData);
            }
            int slotOff = idx * this.fixedKeyLen;
            if (this.keys[slotOff] == 127) {
                assert (!embeddedData);
                return prefix;
            }
            int slotLen = this.keys[slotOff] - -128;
            int prefixLen = prefix.length;
            int suffixLen = embeddedData ? DupKeyData.getKeyLength(this.keys, ++slotOff, slotLen) : slotLen;
            byte[] key = new byte[suffixLen + prefixLen];
            System.arraycopy(prefix, 0, key, 0, prefixLen);
            System.arraycopy(this.keys, slotOff, key, prefixLen, suffixLen);
            return key;
        }

        @Override
        public int compareKeys(byte[] searchKey, byte[] prefix, int idx, boolean embeddedData, Comparator<byte[]> comparator) {
            if (comparator != null) {
                byte[] myKey = this.getFullKey(prefix, idx, embeddedData);
                return Key.compareKeys(searchKey, myKey, comparator);
            }
            int cmp = 0;
            if (prefix == null || prefix.length == 0) {
                return this.compareSuffixes(searchKey, 0, searchKey.length, idx, embeddedData);
            }
            if (searchKey.length <= prefix.length) {
                return Key.compareUnsignedBytes(searchKey, 0, searchKey.length, prefix, 0, searchKey.length);
            }
            cmp = Key.compareUnsignedBytes(searchKey, 0, prefix.length, prefix, 0, prefix.length);
            if (cmp == 0) {
                int searchKeyOff = prefix.length;
                int searchKeyLen = searchKey.length - prefix.length;
                return this.compareSuffixes(searchKey, searchKeyOff, searchKeyLen, idx, embeddedData);
            }
            return cmp;
        }

        private int compareSuffixes(byte[] searchKey, int searchKeyOff, int searchKeyLen, int idx, boolean embeddedData) {
            int myKeyOff = idx * this.fixedKeyLen;
            int myKeyLen = 0;
            if (this.keys[myKeyOff] != 127) {
                myKeyLen = this.keys[myKeyOff] - -128;
                ++myKeyOff;
                if (embeddedData) {
                    myKeyLen = DupKeyData.getKeyLength(this.keys, myKeyOff, myKeyLen);
                }
            } else {
                assert (!embeddedData);
                ++myKeyOff;
            }
            return Key.compareUnsignedBytes(searchKey, searchKeyOff, searchKeyLen, this.keys, myKeyOff, myKeyLen);
        }

        @Override
        public INKeyRep copy(int from, int to, int n, IN parent) {
            System.arraycopy(this.keys, from * this.fixedKeyLen, this.keys, to * this.fixedKeyLen, n * this.fixedKeyLen);
            return this;
        }

        @Override
        public INKeyRep compact(IN parent) {
            return this;
        }

        @Override
        public long calculateMemorySize() {
            return MemoryBudget.MAX_KEY_SIZE_KEYVALS_OVERHEAD + MemoryBudget.byteArraySize(this.keys.length);
        }

        private static long calculateMemorySize(int maxKeys, int maxKeySize) {
            return MemoryBudget.MAX_KEY_SIZE_KEYVALS_OVERHEAD + MemoryBudget.byteArraySize(maxKeys * (maxKeySize + 1));
        }

        @Override
        public boolean accountsForKeyByteMemUsage() {
            return true;
        }

        @Override
        void updateCacheStats(boolean increment, Evictor evictor) {
            if (increment) {
                evictor.getNINCompactKey().incrementAndGet();
            } else {
                evictor.getNINCompactKey().decrementAndGet();
            }
        }
    }

    public static class Default
    extends INKeyRep {
        private final byte[][] keys;

        Default(int nodeMaxEntries) {
            this.keys = new byte[nodeMaxEntries][];
        }

        public Default(SizeofMarker marker) {
            this.keys = null;
        }

        @Override
        public Type getType() {
            return Type.DEFAULT;
        }

        @Override
        public int length() {
            return this.keys.length;
        }

        @Override
        public INKeyRep set(int idx, byte[] key, IN parent) {
            this.keys[idx] = key;
            return this;
        }

        @Override
        public INKeyRep set(int idx, byte[] key, byte[] data, IN parent) {
            this.keys[idx] = data == null || data.length == 0 ? key : DupKeyData.combine(key, data);
            return this;
        }

        @Override
        public INKeyRep setData(int idx, byte[] data, IN parent) {
            return this.set(idx, this.getKey(idx, true), data, parent);
        }

        @Override
        public byte[] get(int idx) {
            return this.keys[idx];
        }

        @Override
        public byte[] getData(int idx) {
            assert (this.keys[idx] != null);
            return DupKeyData.getData(this.keys[idx], 0, this.keys[idx].length);
        }

        @Override
        public byte[] getKey(int idx, boolean embeddedData) {
            byte[] suffix = this.keys[idx];
            if (suffix == null) {
                return Key.EMPTY_KEY;
            }
            if (embeddedData) {
                return DupKeyData.getKey(suffix, 0, suffix.length);
            }
            return suffix;
        }

        @Override
        public byte[] getFullKey(byte[] prefix, int idx, boolean embeddedData) {
            if (prefix == null || prefix.length == 0) {
                return this.getKey(idx, embeddedData);
            }
            byte[] suffix = this.keys[idx];
            if (suffix == null) {
                assert (!embeddedData);
                suffix = Key.EMPTY_KEY;
            }
            int prefixLen = prefix.length;
            int suffixLen = embeddedData ? DupKeyData.getKeyLength(suffix, 0, suffix.length) : suffix.length;
            byte[] key = new byte[prefixLen + suffixLen];
            System.arraycopy(prefix, 0, key, 0, prefixLen);
            System.arraycopy(suffix, 0, key, prefixLen, suffixLen);
            return key;
        }

        @Override
        public int compareKeys(byte[] searchKey, byte[] prefix, int idx, boolean embeddedData, Comparator<byte[]> comparator) {
            if (comparator != null) {
                byte[] myKey = this.getFullKey(prefix, idx, embeddedData);
                return Key.compareKeys(searchKey, myKey, comparator);
            }
            int cmp = 0;
            if (prefix == null || prefix.length == 0) {
                return this.compareSuffixes(searchKey, 0, searchKey.length, idx, embeddedData);
            }
            if (searchKey.length <= prefix.length) {
                return Key.compareUnsignedBytes(searchKey, 0, searchKey.length, prefix, 0, searchKey.length);
            }
            cmp = Key.compareUnsignedBytes(searchKey, 0, prefix.length, prefix, 0, prefix.length);
            if (cmp == 0) {
                int searchKeyOffset = prefix.length;
                int searchKeyLen = searchKey.length - prefix.length;
                return this.compareSuffixes(searchKey, searchKeyOffset, searchKeyLen, idx, embeddedData);
            }
            return cmp;
        }

        private int compareSuffixes(byte[] searchKey, int searchKeyOff, int searchKeyLen, int idx, boolean embeddedData) {
            int myKeyLen;
            byte[] myKey = this.keys[idx];
            if (myKey == null) {
                myKey = Key.EMPTY_KEY;
                myKeyLen = 0;
            } else {
                myKeyLen = embeddedData ? DupKeyData.getKeyLength(myKey, 0, myKey.length) : myKey.length;
            }
            return Key.compareUnsignedBytes(searchKey, searchKeyOff, searchKeyLen, myKey, 0, myKeyLen);
        }

        @Override
        public INKeyRep copy(int from, int to, int n, IN parent) {
            System.arraycopy(this.keys, from, this.keys, to, n);
            return this;
        }

        @Override
        public INKeyRep compact(IN parent) {
            if (this.keys.length > 256) {
                return this;
            }
            int compactMaxKeyLength = parent.getCompactMaxKeyLength();
            if (compactMaxKeyLength <= 0) {
                return this;
            }
            int keyCount = 0;
            int maxKeyLength = 0;
            int defaultKeyBytes = 0;
            for (byte[] key : this.keys) {
                if (key == null) continue;
                ++keyCount;
                if (key.length > maxKeyLength && (maxKeyLength = key.length) > compactMaxKeyLength) {
                    return this;
                }
                defaultKeyBytes += MemoryBudget.byteArraySize(key.length);
            }
            if (keyCount == 0) {
                return this;
            }
            long defaultSizeWithKeys = this.calculateMemorySize() + (long)defaultKeyBytes;
            if (defaultSizeWithKeys > MaxKeySize.calculateMemorySize(this.keys.length, maxKeyLength)) {
                return this.compactToMaxKeySizeRep(maxKeyLength, parent);
            }
            return this;
        }

        private MaxKeySize compactToMaxKeySizeRep(int maxKeyLength, IN parent) {
            MaxKeySize newRep = new MaxKeySize(this.keys.length, (short)maxKeyLength);
            for (int i = 0; i < this.keys.length; ++i) {
                INKeyRep rep = newRep.set(i, this.keys[i], parent);
                assert (rep == newRep);
            }
            this.noteRepChange(newRep, parent);
            return newRep;
        }

        @Override
        public long calculateMemorySize() {
            return MemoryBudget.DEFAULT_KEYVALS_OVERHEAD + MemoryBudget.objectArraySize(this.keys.length);
        }

        @Override
        public boolean accountsForKeyByteMemUsage() {
            return false;
        }

        @Override
        void updateCacheStats(boolean increment, Evictor evictor) {
        }
    }

    public static enum Type {
        DEFAULT,
        MAX_KEY_SIZE;

    }
}

