/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.utilint.StringUtils;
import java.util.Comparator;

public final class Key
implements Comparable<Key> {
    public static DumpType DUMP_TYPE = DumpType.BINARY;
    public static final byte[] EMPTY_KEY = new byte[0];
    private byte[] key;

    public Key(byte[] key) {
        if (key == null) {
            this.key = null;
        } else {
            this.key = new byte[key.length];
            System.arraycopy(key, 0, this.key, 0, key.length);
        }
    }

    public static byte[] makeKey(DatabaseEntry dbt) {
        byte[] entryKey = dbt.getData();
        if (entryKey == null) {
            return EMPTY_KEY;
        }
        byte[] newKey = new byte[dbt.getSize()];
        System.arraycopy(entryKey, dbt.getOffset(), newKey, 0, dbt.getSize());
        return newKey;
    }

    public byte[] getKey() {
        return this.key;
    }

    @Override
    public int compareTo(Key argKey) {
        return Key.compareUnsignedBytes(this.key, argKey.key);
    }

    public boolean equals(Object o) {
        return o instanceof Key && this.compareTo((Key)o) == 0;
    }

    public int hashCode() {
        int code = 0;
        for (int i = 0; i < this.key.length; ++i) {
            code += this.key[i];
        }
        return code;
    }

    public static int compareKeys(byte[] key1, int off1, int len1, byte[] key2, int off2, int len2, Comparator<byte[]> comparator) {
        byte[] b;
        if (comparator == null) {
            return Key.compareUnsignedBytes(key1, off1, len1, key2, off2, len2);
        }
        if (off1 != 0 || len1 != key1.length) {
            b = new byte[len1];
            System.arraycopy(key1, off1, b, 0, len1);
            key1 = b;
        }
        if (off2 != 0 || len2 != key2.length) {
            b = new byte[len2];
            System.arraycopy(key2, off2, b, 0, len2);
            key2 = b;
        }
        return comparator.compare(key1, key2);
    }

    public static int compareKeys(byte[] key1, byte[] key2, Comparator<byte[]> comparator) {
        if (comparator != null) {
            return comparator.compare(key1, key2);
        }
        return Key.compareUnsignedBytes(key1, key2);
    }

    public static int compareKeys(DatabaseEntry entry1, DatabaseEntry entry2, Comparator<byte[]> comparator) {
        byte[] key1 = Key.makeKey(entry1);
        byte[] key2 = Key.makeKey(entry2);
        if (comparator != null) {
            return comparator.compare(key1, key2);
        }
        return Key.compareUnsignedBytes(key1, key2);
    }

    private static int compareUnsignedBytes(byte[] key1, byte[] key2) {
        return Key.compareUnsignedBytes(key1, 0, key1.length, key2, 0, key2.length);
    }

    public static int compareUnsignedBytes(byte[] key1, int off1, int len1, byte[] key2, int off2, int len2) {
        int limit = Math.min(len1, len2);
        for (int i = 0; i < limit; ++i) {
            byte b1 = key1[i + off1];
            byte b2 = key2[i + off2];
            if (b1 == b2) continue;
            return (b1 & 0xFF) - (b2 & 0xFF);
        }
        return len1 - len2;
    }

    public static int getKeyPrefixLength(byte[] key1, int a1Len, byte[] key2) {
        assert (key1 != null && key2 != null);
        int a2Len = key2.length;
        int limit = Math.min(a1Len, a2Len);
        for (int i = 0; i < limit; ++i) {
            byte b1 = key1[i];
            byte b2 = key2[i];
            if (b1 == b2) continue;
            return i;
        }
        return limit;
    }

    public static byte[] createKeyPrefix(byte[] key1, byte[] key2) {
        int len = Key.getKeyPrefixLength(key1, key1.length, key2);
        if (len == 0) {
            return null;
        }
        byte[] ret = new byte[len];
        System.arraycopy(key1, 0, ret, 0, len);
        return ret;
    }

    public static String dumpString(byte[] key, int nspaces) {
        return Key.dumpString(key, "key", nspaces);
    }

    public static String dumpString(byte[] key, String xmltag, int nspaces) {
        StringBuilder sb = new StringBuilder();
        sb.append(TreeUtils.indent(nspaces));
        sb.append("<").append(xmltag).append(" v=\"");
        sb.append(Key.getNoFormatString(key));
        sb.append("\"/>");
        return sb.toString();
    }

    public static String getNoFormatString(byte[] key) {
        StringBuilder sb = new StringBuilder();
        if (DUMP_TYPE == DumpType.BINARY || DUMP_TYPE == DumpType.HEX) {
            if (key == null) {
                sb.append("<null>");
            } else {
                sb.append(DUMP_TYPE.dumpByteArray(key));
            }
        } else if (DUMP_TYPE == DumpType.TEXT) {
            sb.append(key == null ? "" : StringUtils.fromUTF8(key));
        } else if (DUMP_TYPE == DumpType.OBFUSCATE) {
            int len = key.length;
            sb.append("[").append(len).append(len == 1 ? " byte]" : " bytes]");
        }
        return sb.toString();
    }

    public static abstract class DumpType {
        private String name;
        public static final DumpType BINARY = new DumpType("BINARY"){

            @Override
            void dumpByteArrayInternal(StringBuilder sb, byte[] b) {
                for (int i = 0; i < b.length; ++i) {
                    sb.append(b[i] & 0xFF).append(" ");
                }
            }
        };
        public static final DumpType HEX = new DumpType("HEX"){

            @Override
            void dumpByteArrayInternal(StringBuilder sb, byte[] b) {
                for (int i = 0; i < b.length; ++i) {
                    sb.append(Integer.toHexString(b[i] & 0xFF)).append(" ");
                }
            }
        };
        public static final DumpType TEXT = new DumpType("TEXT"){

            @Override
            void dumpByteArrayInternal(StringBuilder sb, byte[] b) {
                sb.append(StringUtils.fromUTF8(b));
            }
        };
        public static final DumpType OBFUSCATE = new DumpType("OBFUSCATE"){

            @Override
            void dumpByteArrayInternal(StringBuilder sb, byte[] b) {
                int len = b.length;
                sb.append("[").append(len).append(len == 1 ? " byte]" : " bytes]");
            }
        };

        private DumpType(String name) {
            this.name = name;
        }

        public String dumpByteArray(byte[] b) {
            StringBuilder sb = new StringBuilder();
            if (b != null) {
                this.dumpByteArrayInternal(sb, b);
            } else {
                sb.append("null");
            }
            return sb.toString();
        }

        public String toString() {
            return this.name;
        }

        abstract void dumpByteArrayInternal(StringBuilder var1, byte[] var2);
    }
}

