/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.EntryBinding;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.JoinCursor;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.BasicIndex;
import com.sleepycat.persist.BasicIterator;
import com.sleepycat.persist.ForwardCursor;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.SecondaryIndex;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class EntityJoin<PK, E> {
    private PrimaryIndex<PK, E> primary;
    private List<Condition> conditions;

    public EntityJoin(PrimaryIndex<PK, E> index) {
        this.primary = index;
        this.conditions = new ArrayList<Condition>();
    }

    public <SK> void addCondition(SecondaryIndex<SK, PK, E> index, SK key) {
        DatabaseEntry keyEntry = new DatabaseEntry();
        index.getKeyBinding().objectToEntry(key, keyEntry);
        Database db = index.getKeysDatabase();
        if (db == null) {
            db = index.getDatabase();
        }
        this.conditions.add(new Condition(db, keyEntry));
    }

    public ForwardCursor<E> entities() throws DatabaseException {
        return this.entities(null, null);
    }

    public ForwardCursor<E> entities(Transaction txn, CursorConfig config) throws DatabaseException {
        return new JoinForwardCursor(txn, config, false);
    }

    public ForwardCursor<PK> keys() throws DatabaseException {
        return this.keys(null, null);
    }

    public ForwardCursor<PK> keys(Transaction txn, CursorConfig config) throws DatabaseException {
        return new JoinForwardCursor(txn, config, true);
    }

    private class JoinForwardCursor<V>
    implements ForwardCursor<V> {
        private Cursor[] cursors;
        private JoinCursor joinCursor;
        private boolean doKeys;

        JoinForwardCursor(Transaction txn, CursorConfig config, boolean doKeys) throws DatabaseException {
            this.doKeys = doKeys;
            try {
                this.cursors = new Cursor[EntityJoin.this.conditions.size()];
                for (int i = 0; i < this.cursors.length; ++i) {
                    Condition cond = (Condition)EntityJoin.this.conditions.get(i);
                    Cursor cursor = cond.openCursor(txn, config);
                    if (cursor == null) {
                        this.doClose(null);
                        return;
                    }
                    this.cursors[i] = cursor;
                }
                this.joinCursor = EntityJoin.this.primary.getDatabase().join(this.cursors, null);
            }
            catch (DatabaseException e) {
                this.doClose(e);
            }
        }

        @Override
        public V next() throws DatabaseException {
            return this.next(null);
        }

        @Override
        public V next(LockMode lockMode) throws DatabaseException {
            if (this.joinCursor == null) {
                return null;
            }
            if (this.doKeys) {
                DatabaseEntry key = new DatabaseEntry();
                OperationStatus status = this.joinCursor.getNext(key, lockMode);
                if (status == OperationStatus.SUCCESS) {
                    EntryBinding binding = EntityJoin.this.primary.getKeyBinding();
                    return (V)binding.entryToObject(key);
                }
            } else {
                DatabaseEntry key = new DatabaseEntry();
                DatabaseEntry data = new DatabaseEntry();
                OperationStatus status = this.joinCursor.getNext(key, data, lockMode);
                if (status == OperationStatus.SUCCESS) {
                    EntityBinding binding = EntityJoin.this.primary.getEntityBinding();
                    return (V)binding.entryToObject(key, data);
                }
            }
            return null;
        }

        @Override
        public Iterator<V> iterator() {
            return this.iterator(null);
        }

        @Override
        public Iterator<V> iterator(LockMode lockMode) {
            return new BasicIterator(this, lockMode);
        }

        @Override
        public void close() throws DatabaseException {
            this.doClose(null);
        }

        private void doClose(DatabaseException firstException) throws DatabaseException {
            block7: {
                if (this.joinCursor != null) {
                    try {
                        this.joinCursor.close();
                        this.joinCursor = null;
                    }
                    catch (DatabaseException e) {
                        if (firstException != null) break block7;
                        firstException = e;
                    }
                }
            }
            for (int i = 0; i < this.cursors.length; ++i) {
                Cursor cursor = this.cursors[i];
                if (cursor == null) continue;
                try {
                    cursor.close();
                    this.cursors[i] = null;
                    continue;
                }
                catch (DatabaseException e) {
                    if (firstException != null) continue;
                    firstException = e;
                }
            }
            if (firstException != null) {
                throw firstException;
            }
        }
    }

    private static class Condition {
        private Database db;
        private DatabaseEntry key;

        Condition(Database db, DatabaseEntry key) {
            this.db = db;
            this.key = key;
        }

        Cursor openCursor(Transaction txn, CursorConfig config) throws DatabaseException {
            OperationStatus status;
            Cursor cursor = this.db.openCursor(txn, config);
            try {
                DatabaseEntry data = BasicIndex.NO_RETURN_ENTRY;
                status = cursor.getSearchKey(this.key, data, null);
            }
            catch (DatabaseException e) {
                try {
                    cursor.close();
                }
                catch (DatabaseException ignored) {
                    // empty catch block
                }
                throw e;
            }
            if (status == OperationStatus.SUCCESS) {
                return cursor;
            }
            cursor.close();
            return null;
        }
    }
}

