/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.vaadin.app;

import com.google.common.reflect.TypeToken;
import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.fieldgroup.BeanFieldGroup;
import com.vaadin.data.fieldgroup.FieldGroup;
import com.vaadin.data.util.AbstractProperty;
import com.vaadin.data.util.MethodProperty;
import com.vaadin.data.util.ObjectProperty;
import com.vaadin.data.util.PropertysetItem;
import com.vaadin.data.util.converter.Converter;
import com.vaadin.server.Sizeable;
import com.vaadin.server.VaadinSession;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomField;
import com.vaadin.ui.DefaultFieldFactory;
import com.vaadin.ui.Field;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Notification;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.dellroad.stuff.spring.RetryTransaction;
import org.dellroad.stuff.vaadin7.EnumComboBox;
import org.dellroad.stuff.vaadin7.FieldBuilder;
import org.dellroad.stuff.vaadin7.VaadinUtil;
import org.jsimpledb.CopyState;
import org.jsimpledb.Counter;
import org.jsimpledb.JClass;
import org.jsimpledb.JCounterField;
import org.jsimpledb.JField;
import org.jsimpledb.JFieldSwitch;
import org.jsimpledb.JFieldSwitchAdapter;
import org.jsimpledb.JListField;
import org.jsimpledb.JMapField;
import org.jsimpledb.JObject;
import org.jsimpledb.JSetField;
import org.jsimpledb.JSimpleField;
import org.jsimpledb.JTransaction;
import org.jsimpledb.ValidationException;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.Transaction;
import org.jsimpledb.core.util.ObjIdMap;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.vaadin.ConfirmWindow;
import org.jsimpledb.vaadin.NullableField;
import org.jsimpledb.vaadin.ReloadableJObjectContainer;
import org.jsimpledb.vaadin.SimpleFieldConverter;
import org.jsimpledb.vaadin.app.JObjectEditorWindow$AjcClosure1;
import org.jsimpledb.vaadin.app.JObjectEditorWindow$AjcClosure3;
import org.jsimpledb.vaadin.app.SimpleFieldFieldBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.UnexpectedRollbackException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.aspectj.AnnotationTransactionAspect;

public class JObjectEditorWindow
extends ConfirmWindow {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final JObject jobj;
    private final JClass<?> jclass;
    private final boolean create;
    private final Component titleComponent;
    private final ParseSession session;
    private final FieldGroup fieldGroup = new FieldGroup();
    private final TreeMap<String, Field<?>> fieldMap = new TreeMap();
    private ReloadableJObjectContainer reloadContainer;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public JObjectEditorWindow(UI ui, ParseSession session, JClass<?> jclass) {
        this(ui, session, jclass, null, null);
    }

    public JObjectEditorWindow(UI ui, ParseSession session, JClass<?> jclass, JObject jobj, Component titleComponent) {
        super(ui, String.valueOf(jobj != null ? "Edit " : "New ") + jclass.getName());
        this.setWidth(600.0f, Sizeable.Unit.PIXELS);
        this.setHeight(450.0f, Sizeable.Unit.PIXELS);
        this.jclass = jclass;
        this.jobj = jobj != null ? jobj : this.doCreateForEdit();
        this.create = jobj == null;
        this.session = session;
        this.titleComponent = titleComponent;
        PropertysetItem item = new PropertysetItem();
        BeanFieldGroup beanFieldGroup = FieldBuilder.buildFieldGroup((Object)this.jobj);
        for (Object id : beanFieldGroup.getBoundPropertyIds()) {
            String fieldName = (String)id;
            Field field = beanFieldGroup.getField(id);
            Property property = beanFieldGroup.getItemDataSource().getItemProperty(id);
            this.fieldMap.put(fieldName, field);
            item.addItemProperty((Object)fieldName, property);
        }
        SortedMap jfieldMap = jclass.getJFieldsByName();
        for (Map.Entry entry : jfieldMap.entrySet()) {
            String fieldName = (String)entry.getKey();
            JField jfield = (JField)entry.getValue();
            Field<?> field = this.fieldMap.get(fieldName);
            if (field == null) {
                field = this.buildFieldField(fieldName, jfield);
                this.fieldMap.put(fieldName, field);
            }
            item.addItemProperty((Object)fieldName, this.buildFieldProperty(this.jobj, jfield));
            field.setCaption(this.buildCaption(jfield.getName(), !(field instanceof CheckBox)));
        }
        this.fieldGroup.setItemDataSource((Item)item);
        for (Map.Entry<Object, Object> entry : this.fieldMap.entrySet()) {
            this.fieldGroup.bind((Field)entry.getValue(), entry.getKey());
        }
    }

    public void setReloadContainerAfterCommit(ReloadableJObjectContainer container) {
        this.reloadContainer = container;
    }

    protected void addContent(VerticalLayout layout) {
        if (this.titleComponent != null) {
            layout.addComponent(this.titleComponent);
        }
        FormLayout formLayout = new FormLayout();
        for (Field<?> field : this.fieldMap.values()) {
            formLayout.addComponent(field);
        }
        layout.addComponent((Component)formLayout);
    }

    protected boolean execute() {
        try {
            this.fieldGroup.commit();
        }
        catch (FieldGroup.CommitException e) {
            Notification.show((String)"Invalid value(s)", null, (Notification.Type)Notification.Type.WARNING_MESSAGE);
            throw new RuntimeException(e);
        }
        try {
            return this.writeBack();
        }
        catch (UnexpectedRollbackException unexpectedRollbackException) {
            this.log.debug("ignoring UnexpectedRollbackException presumably caused by validation failure");
            return false;
        }
    }

    @RetryTransaction
    @Transactional(value="jsimpledbGuiTransactionManager")
    private JObject doCreateForEdit() {
        Object[] objectArray = new Object[]{this};
        return (JObject)AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new JObjectEditorWindow$AjcClosure1(objectArray), ajc$tjp_0);
    }

    @RetryTransaction
    @Transactional(value="jsimpledbGuiTransactionManager")
    protected boolean writeBack() {
        Object[] objectArray = new Object[]{this};
        return Conversions.booleanValue((Object)AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new JObjectEditorWindow$AjcClosure3(objectArray), ajc$tjp_1));
    }

    private Field<?> buildFieldField(String fieldName, JField jfield) {
        return (Field)jfield.visit((JFieldSwitch)new JFieldSwitchAdapter<Field<?>>(){

            public Field<?> caseJSimpleField(JSimpleField jfield) {
                boolean allowNull = jfield.getGetter().getAnnotation(NotNull.class) == null && !jfield.getTypeToken().isPrimitive();
                return new SimpleFieldFieldBuilder(JObjectEditorWindow.this.jobj.getTransaction(), jfield, JObjectEditorWindow.this.session, allowNull).buildField();
            }

            public Field<?> caseJCounterField(JCounterField jfield) {
                TextField field = new TextField();
                field.setWidth("100%");
                field.setNullSettingAllowed(false);
                field.setConverter((Converter)new SimpleFieldConverter(JObjectEditorWindow.this.jclass.getJSimpleDB().getDatabase().getFieldTypeRegistry().getFieldType(TypeToken.of(Long.TYPE))));
                return field;
            }

            public Field<?> caseJSetField(JSetField jfield) {
                return new PlaceHolderField((JField)jfield);
            }

            public Field<?> caseJListField(JListField jfield) {
                return new PlaceHolderField((JField)jfield);
            }

            public Field<?> caseJMapField(JMapField jfield) {
                return new PlaceHolderField((JField)jfield);
            }
        });
    }

    private Property<?> buildFieldProperty(final JObject jobj, JField jfield) {
        return (Property)jfield.visit((JFieldSwitch)new JFieldSwitchAdapter<Property<?>>(){

            public Property<?> caseJSimpleField(JSimpleField jfield) {
                return new MethodProperty(jfield.getTypeToken().getRawType(), (Object)jobj, jfield.getGetter(), jfield.getSetter());
            }

            public Property<?> caseJCounterField(JCounterField jfield) {
                return new CounterProperty(jfield.getValue(jobj));
            }

            public Property<?> caseJSetField(JSetField jfield) {
                return new CollectionProperty(jfield.getValue(jobj));
            }

            public Property<?> caseJListField(JListField jfield) {
                return new CollectionProperty(jfield.getValue(jobj));
            }

            public Property<?> caseJMapField(JMapField jfield) {
                return new ObjectProperty(null, Void.class);
            }
        });
    }

    private <T extends Enum> EnumComboBox createEnumComboBox(Class<T> enumType, boolean allowNull) {
        return new EnumComboBox(enumType, allowNull);
    }

    private <T> SimpleFieldConverter<T> buildSimpleFieldConverter(FieldType<T> fieldType) {
        return new SimpleFieldConverter(fieldType);
    }

    private String buildCaption(String fieldName, boolean includeColon) {
        return String.valueOf(DefaultFieldFactory.createCaptionByPropertyId((Object)fieldName)) + (includeColon ? ":" : "");
    }

    private <T> NullableField<T> addNullButton(Field<T> field) {
        return new NullableField(field);
    }

    static {
        JObjectEditorWindow.ajc$preClinit();
    }

    static final /* synthetic */ JObject doCreateForEdit_aroundBody0(JObjectEditorWindow ajc$this) {
        return (JObject)JTransaction.getCurrent().getSnapshotTransaction().create(ajc$this.jclass);
    }

    static final /* synthetic */ boolean writeBack_aroundBody2(JObjectEditorWindow ajc$this) {
        JObject target;
        JTransaction jtx = JTransaction.getCurrent();
        final ObjId id = ajc$this.jobj.getObjId();
        JObject jObject = target = ajc$this.create ? (JObject)jtx.create(ajc$this.jclass) : jtx.get(id);
        if (!ajc$this.create && !target.exists()) {
            Notification.show((String)("Object " + id + " no longer exists"), null, (Notification.Type)Notification.Type.WARNING_MESSAGE);
            return true;
        }
        ajc$this.jobj.copyTo(jtx, new CopyState(new ObjIdMap(Collections.singletonMap(id, target.getObjId()))), new String[0]);
        try {
            jtx.validate();
        }
        catch (ValidationException e) {
            Notification.show((String)"Validation failed", (String)e.getMessage(), (Notification.Type)Notification.Type.ERROR_MESSAGE);
            jtx.getTransaction().setRollbackOnly();
            return false;
        }
        if (ajc$this.reloadContainer != null) {
            ajc$this.reloadContainer.reloadAfterCommit();
        }
        final VaadinSession vaadinSession = VaadinUtil.getCurrentSession();
        jtx.getTransaction().addCallback((Transaction.Callback)new Transaction.CallbackAdapter(){

            public void afterCommit() {
                VaadinUtil.invoke((VaadinSession)vaadinSession, () -> Notification.show((String)(String.valueOf(JObjectEditorWindow.this.create ? "Created" : "Updated") + " object " + id)));
            }
        });
        return true;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JObjectEditorWindow.java", JObjectEditorWindow.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "doCreateForEdit", "org.jsimpledb.vaadin.app.JObjectEditorWindow", "", "", "", "org.jsimpledb.JObject"), 201);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "writeBack", "org.jsimpledb.vaadin.app.JObjectEditorWindow", "", "", "", "boolean"), 207);
    }

    private static class CollectionProperty
    extends AbstractProperty<Collection> {
        private final Collection collection;

        CollectionProperty(Collection collection) {
            this.collection = collection;
        }

        public Class<Collection> getType() {
            return Collection.class;
        }

        public Collection getValue() {
            return this.collection;
        }

        public void setValue(Collection value) {
            throw new UnsupportedOperationException();
        }
    }

    private static class CounterProperty
    extends AbstractProperty<Long> {
        private final Counter counter;

        CounterProperty(Counter counter) {
            this.counter = counter;
        }

        public Class<Long> getType() {
            return Long.class;
        }

        public Long getValue() {
            return this.counter.get();
        }

        public void setValue(Long value) {
            this.counter.set(value != null ? value : 0L);
        }
    }

    private static class PlaceHolderField
    extends CustomField<Object> {
        private final JField jfield;

        PlaceHolderField(JField jfield) {
            this.jfield = jfield;
        }

        public Class<Object> getType() {
            return Object.class;
        }

        protected Label initContent() {
            return new Label("TODO: editor for field `" + this.jfield.getName() + "'");
        }
    }
}

