/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.vaadin.app;

import com.google.common.base.Preconditions;
import java.io.File;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.Arrays;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.FragmentConfiguration;
import org.eclipse.jetty.webapp.MetaInfConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebInfConfiguration;
import org.eclipse.jetty.webapp.WebXmlConfiguration;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.app.AbstractMain;
import org.jsimpledb.core.Database;
import org.jsimpledb.vaadin.app.GUIConfig;

public class Main
extends AbstractMain
implements GUIConfig {
    private static final int DEFAULT_HTTP_PORT = 8080;
    private static Main instance;
    private JSimpleDB jdb;
    private Server server;
    private int port = 8080;
    private URI root;

    protected boolean parseOption(String option, ArrayDeque<String> params) {
        switch (option) {
            case "--root": {
                if (params.isEmpty()) {
                    this.usageError();
                }
                this.root = new File(params.removeFirst()).toURI();
                break;
            }
            case "--port": {
                if (params.isEmpty()) {
                    this.usageError();
                }
                this.port = Integer.parseInt(params.removeFirst());
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            Preconditions.checkState((instance == null ? 1 : 0) != 0, (Object)"only one instance of this class is expected");
            instance = this;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            ArrayDeque<String> params = new ArrayDeque<String>(Arrays.asList(args));
            int result = this.parseOptions(params);
            if (result != -1) {
                return result;
            }
            switch (params.size()) {
                case 0: {
                    break;
                }
                default: {
                    this.usageError();
                    return 1;
                }
            }
            if (this.schemaClasses == null) {
                System.err.println(String.valueOf(this.getName()) + ": no schema classes defined; please specify using `--pkg'");
                return 1;
            }
            if (this.root == null) {
                block15: {
                    try {
                        URI uri = this.getClass().getResource("/WEB-INF/web.xml").toURI();
                        this.root = uri.toString().startsWith("jar:") ? new URI(uri.toString().substring(0, uri.toString().lastIndexOf(33) + 2)) : this.getClass().getResource("/WEB-INF/web.xml").toURI().resolve("..");
                    }
                    catch (Exception e) {
                        if (!this.isVerbose()) break block15;
                        e.printStackTrace(System.err);
                    }
                }
                if (this.root == null) {
                    System.err.println(String.valueOf(this.getName()) + ": can't determine install directory; please specify `--root dir'");
                    return 1;
                }
            }
            this.log.debug("using root directory " + this.root);
            Database db = this.startupKVDatabase();
            try {
                this.jdb = this.getJSimpleDBFactory(db).newJSimpleDB();
                this.server = new Server(this.port);
                WebAppContext context = new WebAppContext();
                context.setBaseResource(Resource.newResource((URI)this.root));
                context.setConfigurations(new Configuration[]{new AnnotationConfiguration(), new WebXmlConfiguration(), new WebInfConfiguration(), new PlusConfiguration(), new MetaInfConfiguration(), new FragmentConfiguration(), new EnvConfiguration()});
                context.setContextPath("/");
                context.setParentLoaderPriority(true);
                this.server.setHandler((Handler)context);
                this.server.start();
                this.server.join();
                return 0;
            }
            finally {
                this.shutdownKVDatabase();
            }
        }
    }

    @Override
    public JSimpleDB getJSimpleDB() {
        return this.jdb;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    protected String getName() {
        return "jsimpledb-gui";
    }

    protected void usageMessage() {
        System.err.println("Usage:");
        System.err.println("  " + this.getName() + " --pkg package [options]");
        System.err.println("Options:");
        this.outputFlags(new String[][]{{"--port port", "Specify HTTP port (default 8080)"}, {"--root directory", "Specify GUI install directory"}});
    }

    public static void main(String[] args) throws Exception {
        new Main().doMain(args);
    }

    public static synchronized Main getInstance() {
        return instance;
    }
}

