/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.fdb;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import org.jsimpledb.kv.KVDatabase;
import org.jsimpledb.kv.KVImplementation;
import org.jsimpledb.kv.fdb.FoundationKVDatabase;
import org.jsimpledb.kv.mvcc.AtomicKVStore;
import org.jsimpledb.util.ByteUtil;

public class FoundationKVImplementation
extends KVImplementation {
    public String[][] getCommandLineOptions() {
        return new String[][]{{"--fdb file", "Use FoundationDB key/value database with specified cluster file"}, {"--fdb-prefix prefix", "Specify FoundationDB key prefix (a hex string, otherwise UTF-8 encoded)"}};
    }

    public Config parseCommandLineOptions(ArrayDeque<String> options) {
        String clusterFile = this.parseCommandLineOption(options, "--fdb");
        if (clusterFile == null) {
            return null;
        }
        if (!new File(clusterFile).exists()) {
            throw new IllegalArgumentException("file `" + clusterFile + "' does not exist");
        }
        Config config = new Config(clusterFile);
        String prefix = this.parseCommandLineOption(options, "--fdb-prefix");
        if (prefix != null) {
            try {
                config.setPrefix(ByteUtil.parse((String)prefix));
            }
            catch (IllegalArgumentException e) {
                config.setPrefix(prefix.getBytes(StandardCharsets.UTF_8));
            }
        }
        return config;
    }

    public FoundationKVDatabase createKVDatabase(Object configuration, KVDatabase kvdb, AtomicKVStore kvstore) {
        Config config = (Config)configuration;
        FoundationKVDatabase fdb = new FoundationKVDatabase();
        fdb.setClusterFilePath(config.getClusterFile());
        fdb.setKeyPrefix(config.getPrefix());
        return fdb;
    }

    public String getDescription(Object configuration) {
        Config config = (Config)configuration;
        String desc = "FoundationDB " + new File(config.getClusterFile()).getName();
        byte[] prefix = config.getPrefix();
        if (prefix != null && prefix.length > 0) {
            desc = desc + " [0x" + ByteUtil.toString((byte[])prefix) + "]";
        }
        return desc;
    }

    private static class Config {
        private String clusterFile;
        private byte[] prefix;

        Config(String clusterFile) {
            if (clusterFile == null) {
                throw new IllegalArgumentException("null clusterFile");
            }
            this.clusterFile = clusterFile;
        }

        public String getClusterFile() {
            return this.clusterFile;
        }

        public byte[] getPrefix() {
            return this.prefix;
        }

        public void setPrefix(byte[] prefix) {
            this.prefix = prefix;
        }
    }
}

