/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.vaadin.app;

import com.vaadin.annotations.PreserveOnRefresh;
import com.vaadin.annotations.Push;
import com.vaadin.annotations.Theme;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.server.ThemeResource;
import com.vaadin.server.VaadinRequest;
import com.vaadin.shared.ui.MarginInfo;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Link;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import org.jsimpledb.vaadin.SizedLabel;
import org.jsimpledb.vaadin.app.HorizontalLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreserveOnRefresh
@Push
@Theme(value="jsdb")
public abstract class AbstractUI
extends UI {
    private static final float UPPER_BAR_HEIGHT = 44.0f;
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final VerticalLayout rootLayout = new VerticalLayout();

    public void init(VaadinRequest request) {
        this.getPage().setTitle(this.getTitle());
        this.setContent((Component)this.rootLayout);
        this.rootLayout.setSpacing(true);
        this.rootLayout.setSizeFull();
        this.rootLayout.setMargin(new MarginInfo(false, true, true, true));
        this.rootLayout.addComponent(this.buildRootUpperBar());
        this.rootLayout.addComponent((Component)new HorizontalLine(3.0f));
        Component lowerPanel = this.buildLowerPanel();
        this.rootLayout.addComponent(lowerPanel);
        this.rootLayout.setExpandRatio(lowerPanel, 1.0f);
        this.rootLayout.setComponentAlignment(lowerPanel, Alignment.MIDDLE_CENTER);
    }

    protected String getTitle() {
        return "JSimpleDB";
    }

    protected Component getTopRightLabel() {
        return null;
    }

    protected Component buildRootUpperBar() {
        Link logo = new Link(null, (Resource)new ExternalResource("main"));
        logo.setIcon((Resource)new ThemeResource("img/jsimpledb-logo-48x48.png"));
        HorizontalLayout logoLayout = new HorizontalLayout();
        logoLayout.addStyleName("jsdb-upper-bar-company-logo-layout");
        logoLayout.setWidth(48.0f, Sizeable.Unit.PIXELS);
        logoLayout.addComponent((Component)logo);
        logoLayout.setComponentAlignment((Component)logo, Alignment.BOTTOM_LEFT);
        SizedLabel titleLabel = new SizedLabel(this.getTitle());
        titleLabel.addStyleName("jsdb-title");
        HorizontalLayout layout = new HorizontalLayout();
        layout.setSpacing(true);
        layout.setWidth("100%");
        layout.setHeight(44.0f, Sizeable.Unit.PIXELS);
        layout.addComponent((Component)logoLayout);
        layout.setComponentAlignment((Component)logoLayout, Alignment.BOTTOM_LEFT);
        layout.addComponent((Component)titleLabel);
        layout.setExpandRatio((Component)titleLabel, 1.0f);
        layout.setComponentAlignment((Component)titleLabel, Alignment.BOTTOM_CENTER);
        Component topRightLabel = this.getTopRightLabel();
        if (topRightLabel != null) {
            layout.addComponent(topRightLabel);
            layout.setComponentAlignment(topRightLabel, Alignment.BOTTOM_RIGHT);
        }
        return layout;
    }

    protected Component buildLowerPanel() {
        VerticalLayout layout = new VerticalLayout();
        layout.setSizeFull();
        layout.setMargin(false);
        layout.setSpacing(true);
        Component mainPanel = this.buildMainPanel();
        mainPanel.setSizeFull();
        layout.addComponent(mainPanel);
        layout.setComponentAlignment(mainPanel, Alignment.TOP_CENTER);
        layout.setExpandRatio(mainPanel, 1.0f);
        HorizontalLayout footerLayout = new HorizontalLayout();
        footerLayout.setWidth("100%");
        footerLayout.setSpacing(true);
        Label spacer = new Label();
        footerLayout.addComponent((Component)spacer);
        footerLayout.setExpandRatio((Component)spacer, 1.0f);
        footerLayout.addComponent((Component)new SizedLabel("JSimpleDB Viewer"));
        layout.addComponent((Component)footerLayout);
        return layout;
    }

    protected abstract Component buildMainPanel();
}

