/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.vaadin.app;

import com.google.common.base.Preconditions;
import com.vaadin.data.Property;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Notification;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.dellroad.stuff.spring.RetryTransaction;
import org.jsimpledb.CopyState;
import org.jsimpledb.JClass;
import org.jsimpledb.JObject;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.JTransaction;
import org.jsimpledb.UntypedJObject;
import org.jsimpledb.core.DeletedObjectException;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.ReferencedObjectException;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.vaadin.JObjectChooser;
import org.jsimpledb.vaadin.ReloadableJObjectContainer;
import org.jsimpledb.vaadin.SizedLabel;
import org.jsimpledb.vaadin.app.GUIConfig;
import org.jsimpledb.vaadin.app.JObjectEditorWindow;
import org.jsimpledb.vaadin.app.MainPanel$AjcClosure1;
import org.jsimpledb.vaadin.app.MainPanel$AjcClosure3;
import org.jsimpledb.vaadin.app.MainPanel$AjcClosure5;
import org.jsimpledb.vaadin.app.MainPanel$AjcClosure7;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.aspectj.AnnotationTransactionAspect;

public class MainPanel
extends VerticalLayout {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final JSimpleDB jdb;
    private final ParseSession session;
    private final JObjectChooser objectChooser;
    private final Button editButton = new Button("Edit", (Button.ClickListener & Serializable)e -> this.editButtonClicked());
    private final Button newButton = new Button("New", (Button.ClickListener & Serializable)e -> this.newButtonClicked());
    private final Button deleteButton = new Button("Delete", (Button.ClickListener & Serializable)e -> this.deleteButtonClicked());
    private final Button upgradeButton = new Button("Upgrade", (Button.ClickListener & Serializable)e -> this.upgradeButtonClicked());
    private final Button refreshButton = new Button("Refresh", (Button.ClickListener & Serializable)e -> this.refreshButtonClicked());
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public MainPanel(GUIConfig guiConfig) {
        this(new GUISession(guiConfig));
    }

    public MainPanel(ParseSession session) {
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (Object)"null session");
        this.session = session;
        this.jdb = session.getJSimpleDB();
        Preconditions.checkArgument((this.jdb != null ? 1 : 0) != 0, (Object)"session is not a JSimpleDB session");
        this.objectChooser = new JObjectChooser(this.session, null, true);
        this.objectChooser.addValueChangeListener((Property.ValueChangeListener & Serializable)e -> this.selectObject(this.objectChooser.getObjId()));
    }

    public void attach() {
        super.attach();
        this.setMargin(false);
        this.setSpacing(true);
        this.setHeight("100%");
        this.addComponent((Component)this.objectChooser.getObjectPanel());
        HorizontalLayout buttonRow = new HorizontalLayout();
        buttonRow.setSpacing(true);
        buttonRow.setWidth("100%");
        SizedLabel versionLabel = new SizedLabel("Schema Version " + this.jdb.getActualVersion());
        buttonRow.addComponent((Component)versionLabel);
        buttonRow.setComponentAlignment((Component)versionLabel, Alignment.MIDDLE_LEFT);
        Label spacer1 = new Label();
        buttonRow.addComponent((Component)spacer1);
        buttonRow.setExpandRatio((Component)spacer1, 1.0f);
        buttonRow.addComponent((Component)this.editButton);
        buttonRow.addComponent((Component)this.newButton);
        buttonRow.addComponent((Component)this.deleteButton);
        buttonRow.addComponent((Component)this.upgradeButton);
        buttonRow.addComponent((Component)this.refreshButton);
        this.addComponent((Component)buttonRow);
        this.setComponentAlignment((Component)buttonRow, Alignment.TOP_RIGHT);
        this.addComponent((Component)this.objectChooser.getShowForm());
        Label spacer2 = new Label();
        this.addComponent((Component)spacer2);
        this.setExpandRatio((Component)spacer2, 1.0f);
    }

    public ParseSession getParseSession() {
        return this.session;
    }

    public JObjectChooser getJObjectChooser() {
        return this.objectChooser;
    }

    protected void selectObject(ObjId id) {
        this.newButton.setEnabled(this.objectChooser.getJClass() != null);
        if (id == null) {
            this.editButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.upgradeButton.setEnabled(false);
        } else {
            this.editButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
            this.upgradeButton.setEnabled(this.canUpgrade(id));
        }
    }

    private void refreshButtonClicked() {
        this.objectChooser.getJObjectContainer().reload();
    }

    private void editButtonClicked() {
        ObjId id = this.objectChooser.getObjId();
        if (id == null) {
            return;
        }
        this.log.info("editing object " + id);
        JObject jobj = this.doCopyForEdit(id);
        if (jobj == null) {
            Notification.show((String)("Object " + id + " no longer exists"), null, (Notification.Type)Notification.Type.WARNING_MESSAGE);
            return;
        }
        if (jobj instanceof UntypedJObject) {
            Notification.show((String)("Can't edit object " + id + " having unknown object type"), (String)("Storage ID " + id.getStorageId() + " not defined in the current schema version"), (Notification.Type)Notification.Type.WARNING_MESSAGE);
            return;
        }
        Object refLabel = this.objectChooser.getJObjectContainer().getContainerProperty((Object)id, (Object)"$label").getValue();
        Component titleComponent = refLabel instanceof Component ? (Component)refLabel : new Label("" + refLabel);
        JObjectEditorWindow editor = new JObjectEditorWindow(this.getUI(), this.session, this.jdb.getJClass(id), jobj, titleComponent);
        editor.setReloadContainerAfterCommit((ReloadableJObjectContainer)this.objectChooser.getJObjectContainer());
        editor.show();
    }

    @RetryTransaction
    @Transactional(value="jsimpledbGuiTransactionManager")
    private JObject doCopyForEdit(ObjId id) {
        ObjId objId = id;
        Object[] objectArray = new Object[]{this, objId};
        return (JObject)AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new MainPanel$AjcClosure1(objectArray), ajc$tjp_0);
    }

    private void newButtonClicked() {
        JClass jclass = this.objectChooser.getJClass();
        if (jclass == null) {
            Notification.show((String)"Can't create object having unknown type", (String)"Please select an object type first", (Notification.Type)Notification.Type.WARNING_MESSAGE);
            return;
        }
        this.log.info("creating new object of type " + jclass.getType().getName());
        new JObjectEditorWindow(this.getUI(), this.session, jclass).show();
    }

    private void deleteButtonClicked() {
        boolean deleted;
        ObjId id = this.objectChooser.getObjId();
        if (id == null) {
            return;
        }
        this.log.info("deleting object " + id);
        try {
            deleted = this.doDelete(id);
        }
        catch (DeletedObjectException e) {
            Notification.show((String)("Object " + e.getId() + " no longer exists"), null, (Notification.Type)Notification.Type.WARNING_MESSAGE);
            return;
        }
        catch (ReferencedObjectException e) {
            Notification.show((String)("Object " + id + " is referenced by " + e.getReferrer()), (String)e.getMessage(), (Notification.Type)Notification.Type.ERROR_MESSAGE);
            return;
        }
        if (deleted) {
            Notification.show((String)("Removed object " + id));
        } else {
            Notification.show((String)("Could not delete object " + id), null, (Notification.Type)Notification.Type.WARNING_MESSAGE);
        }
        this.selectObject(null);
    }

    @RetryTransaction
    @Transactional(value="jsimpledbGuiTransactionManager")
    private boolean doDelete(ObjId id) {
        ObjId objId = id;
        Object[] objectArray = new Object[]{this, objId};
        return Conversions.booleanValue((Object)AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new MainPanel$AjcClosure3(objectArray), ajc$tjp_1));
    }

    private void upgradeButtonClicked() {
        ObjId id = this.objectChooser.getObjId();
        if (id == null) {
            return;
        }
        int newVersion = this.jdb.getActualVersion();
        this.log.info("upgrading object " + id + " to schema version " + newVersion);
        int oldVersion = this.doUpgrade(id);
        switch (oldVersion) {
            case -1: {
                Notification.show((String)("Object " + id + " no longer exists"), null, (Notification.Type)Notification.Type.WARNING_MESSAGE);
                break;
            }
            case 0: {
                Notification.show((String)("Object " + id + " was already upgraded"), null, (Notification.Type)Notification.Type.WARNING_MESSAGE);
                break;
            }
            default: {
                Notification.show((String)("Upgraded object " + id + " version from " + oldVersion + " to " + newVersion));
            }
        }
    }

    @RetryTransaction
    @Transactional(value="jsimpledbGuiTransactionManager")
    private int doUpgrade(ObjId id) {
        ObjId objId = id;
        Object[] objectArray = new Object[]{this, objId};
        return Conversions.intValue((Object)AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new MainPanel$AjcClosure5(objectArray), ajc$tjp_2));
    }

    @RetryTransaction
    @Transactional(value="jsimpledbGuiTransactionManager")
    private boolean canUpgrade(ObjId id) {
        ObjId objId = id;
        Object[] objectArray = new Object[]{this, objId};
        return Conversions.booleanValue((Object)AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new MainPanel$AjcClosure7(objectArray), ajc$tjp_3));
    }

    static {
        MainPanel.ajc$preClinit();
    }

    static final /* synthetic */ JObject doCopyForEdit_aroundBody0(MainPanel ajc$this, ObjId id) {
        JTransaction jtx = JTransaction.getCurrent();
        JObject jobj = jtx.get(id);
        if (!jobj.exists()) {
            return null;
        }
        return ajc$this.objectChooser.getJObjectContainer().copyWithRelated(jobj, (JTransaction)jtx.getSnapshotTransaction(), new CopyState());
    }

    static final /* synthetic */ boolean doDelete_aroundBody2(MainPanel ajc$this, ObjId id) {
        boolean deleted = JTransaction.getCurrent().get(id).delete();
        if (deleted) {
            ajc$this.objectChooser.getJObjectContainer().reloadAfterCommit();
        }
        return deleted;
    }

    static final /* synthetic */ int doUpgrade_aroundBody4(MainPanel ajc$this, ObjId id) {
        int oldVersion;
        JObject jobj = JTransaction.getCurrent().get(id);
        try {
            oldVersion = jobj.getSchemaVersion();
        }
        catch (DeletedObjectException deletedObjectException) {
            return -1;
        }
        boolean upgraded = jobj.upgrade();
        if (upgraded) {
            ajc$this.objectChooser.getJObjectContainer().reloadAfterCommit();
        }
        return upgraded ? oldVersion : 0;
    }

    static final /* synthetic */ boolean canUpgrade_aroundBody6(MainPanel ajc$this, ObjId id) {
        JObject jobj = JTransaction.getCurrent().get(id);
        return jobj.exists() && jobj.getSchemaVersion() != ajc$this.jdb.getActualVersion();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MainPanel.java", MainPanel.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "doCopyForEdit", "org.jsimpledb.vaadin.app.MainPanel", "org.jsimpledb.core.ObjId", "id", "", "org.jsimpledb.JObject"), 192);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "doDelete", "org.jsimpledb.vaadin.app.MainPanel", "org.jsimpledb.core.ObjId", "id", "", "boolean"), 244);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "doUpgrade", "org.jsimpledb.vaadin.app.MainPanel", "org.jsimpledb.core.ObjId", "id", "", "int"), 275);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "canUpgrade", "org.jsimpledb.vaadin.app.MainPanel", "org.jsimpledb.core.ObjId", "id", "", "boolean"), 291);
    }

    private static class GUISession
    extends ParseSession {
        private final GUIConfig guiConfig;

        GUISession(GUIConfig guiConfig) {
            super(guiConfig.getJSimpleDB());
            this.guiConfig = guiConfig;
            this.setReadOnly(this.guiConfig.isReadOnly());
            this.setSchemaModel(this.guiConfig.getJSimpleDB().getSchemaModel());
            this.setSchemaVersion(this.guiConfig.getSchemaVersion());
            this.setAllowNewSchema(this.guiConfig.isAllowNewSchema());
            this.loadFunctionsFromClasspath();
        }

        protected void reportException(Exception e) {
            Notification.show((String)("Error: " + e.getMessage()), null, (Notification.Type)Notification.Type.ERROR_MESSAGE);
            if (this.guiConfig.isVerbose()) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("exception in parse session", (Throwable)e);
            }
        }
    }
}

