/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.vaadin.app;

import com.google.common.base.Preconditions;
import com.vaadin.data.Property;
import com.vaadin.server.Sizeable;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomField;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.HorizontalSplitPanel;
import com.vaadin.ui.Label;
import com.vaadin.ui.Notification;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.dellroad.stuff.spring.RetryTransaction;
import org.jsimpledb.CopyState;
import org.jsimpledb.JObject;
import org.jsimpledb.JTransaction;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.vaadin.ConfirmWindow;
import org.jsimpledb.vaadin.JObjectChooser;
import org.jsimpledb.vaadin.JObjectContainer;
import org.jsimpledb.vaadin.SizedLabel;
import org.jsimpledb.vaadin.SmallButton;
import org.jsimpledb.vaadin.app.ReferenceFieldField$ChangeWindow$AjcClosure1;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.aspectj.AnnotationTransactionAspect;

public class ReferenceFieldField
extends CustomField<JObject> {
    private final JTransaction dest;
    private final HorizontalLayout layout = new HorizontalLayout();
    private final ParseSession session;
    private final String name;
    private final Class<?> type;
    private final JObjectContainer.RefLabelPropertyDef refLabelPropertyDef = new JObjectContainer.RefLabelPropertyDef();
    private final SmallButton changeButton = new SmallButton("Change...", (Button.ClickListener & Serializable)e -> this.change());
    private Component refLabel = new Label();

    public ReferenceFieldField(JTransaction dest, ParseSession session, String name, Class<?> type) {
        Preconditions.checkArgument((dest != null ? 1 : 0) != 0, (Object)"null dest");
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (Object)"null session");
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"null name");
        this.dest = dest;
        this.session = session;
        this.name = name;
        this.type = type;
        this.addValueChangeListener((Property.ValueChangeListener & Serializable)e -> this.updateDisplay());
        this.addReadOnlyStatusChangeListener((Property.ReadOnlyStatusChangeListener & Serializable)e -> this.updateDisplay());
    }

    public Class<JObject> getType() {
        return JObject.class;
    }

    protected HorizontalLayout initContent() {
        this.layout.setMargin(false);
        this.layout.setSpacing(true);
        this.layout.addComponent(this.refLabel);
        this.layout.addComponent((Component)new Label("\u00a0\u00a0"));
        this.layout.addComponent((Component)this.changeButton);
        this.layout.setComponentAlignment((Component)this.changeButton, Alignment.MIDDLE_LEFT);
        this.updateDisplay();
        return this.layout;
    }

    protected void setInternalValue(JObject jobj) {
        super.setInternalValue((Object)jobj);
        this.updateDisplay();
    }

    private void updateDisplay() {
        JObject jobj = (JObject)this.getValue();
        boolean readOnly = this.isReadOnly();
        SizedLabel newLabel = jobj != null ? this.refLabelPropertyDef.extract(jobj) : new SizedLabel("<i>Null</i>&#160;", ContentMode.HTML);
        this.layout.replaceComponent(this.refLabel, (Component)newLabel);
        this.refLabel = newLabel;
        this.changeButton.setEnabled(!readOnly);
    }

    private void change() {
        new ChangeWindow().show();
    }

    public class ChangeWindow
    extends ConfirmWindow {
        private final JObjectChooser objectChooser;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        ChangeWindow() {
            super(ReferenceFieldField.this.getUI(), "Select " + ReferenceFieldField.this.name);
            this.setWidth(800.0f, Sizeable.Unit.PIXELS);
            this.setHeight(500.0f, Sizeable.Unit.PIXELS);
            this.objectChooser = new JObjectChooser(ReferenceFieldField.this.session, ReferenceFieldField.this.type, false);
        }

        protected void addContent(VerticalLayout layout) {
            HorizontalSplitPanel objectPanel = this.objectChooser.getObjectPanel();
            objectPanel.setHeight(200.0f, Sizeable.Unit.PIXELS);
            objectPanel.setSplitPosition(40.0f);
            layout.addComponent((Component)objectPanel);
            layout.addComponent((Component)this.objectChooser.getShowForm());
        }

        @RetryTransaction
        @Transactional(value="jsimpledbGuiTransactionManager")
        protected boolean execute() {
            Object[] objectArray = new Object[]{this};
            return Conversions.booleanValue((Object)AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new ReferenceFieldField$ChangeWindow$AjcClosure1(objectArray), ajc$tjp_0));
        }

        static {
            ChangeWindow.ajc$preClinit();
        }

        static final /* synthetic */ boolean execute_aroundBody0(ChangeWindow ajc$this) {
            ObjId id = ajc$this.objectChooser.getObjId();
            if (id == null) {
                return true;
            }
            JObject jobj = JTransaction.getCurrent().get(id);
            if (!jobj.exists()) {
                Notification.show((String)("Object " + id + " no longer exists"), null, (Notification.Type)Notification.Type.WARNING_MESSAGE);
                return false;
            }
            try {
                ajc$this.ReferenceFieldField.this.setValue(jobj.copyTo(ajc$this.ReferenceFieldField.this.dest, new CopyState(), new String[0]));
            }
            catch (Exception e) {
                Notification.show((String)("Error: " + e), null, (Notification.Type)Notification.Type.ERROR_MESSAGE);
            }
            return true;
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("ReferenceFieldField.java", ChangeWindow.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "execute", "org.jsimpledb.vaadin.app.ReferenceFieldField$ChangeWindow", "", "", "", "boolean"), 141);
        }
    }
}

