/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.vaadin.app;

import com.google.common.base.Preconditions;
import com.vaadin.shared.ui.datefield.Resolution;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Field;
import com.vaadin.ui.PopupDateField;
import com.vaadin.ui.TextField;
import java.util.Date;
import org.dellroad.stuff.vaadin7.EnumComboBox;
import org.jsimpledb.JReferenceField;
import org.jsimpledb.JSimpleField;
import org.jsimpledb.JTransaction;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.vaadin.NullableField;
import org.jsimpledb.vaadin.SimpleFieldConverter;
import org.jsimpledb.vaadin.app.ReferenceFieldField;

public class SimpleFieldFieldBuilder {
    private final JTransaction jtx;
    private final JSimpleField jfield;
    private final ParseSession session;
    private final boolean allowNull;

    public SimpleFieldFieldBuilder(JTransaction jtx, JSimpleField jfield, ParseSession session, boolean allowNull) {
        Preconditions.checkArgument((jtx != null ? 1 : 0) != 0, (Object)"null jtx");
        Preconditions.checkArgument((jfield != null ? 1 : 0) != 0, (Object)"null jfield");
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (Object)"null session");
        this.jtx = jtx;
        this.jfield = jfield;
        this.session = session;
        this.allowNull = allowNull && !jfield.getTypeToken().isPrimitive();
    }

    public Field<?> buildField() {
        TextField field;
        Class propertyType = this.jfield.getTypeToken().getRawType();
        if (this.jfield instanceof JReferenceField) {
            field = new ReferenceFieldField(this.jtx, this.session, this.jfield.getName(), this.jfield.getTypeToken().getRawType());
        } else if (Enum.class.isAssignableFrom(propertyType)) {
            EnumComboBox comboBox = this.createEnumComboBox(propertyType.asSubclass(Enum.class));
            comboBox.setInputPrompt("Null");
            field = comboBox;
        } else if (propertyType.isAssignableFrom(Date.class)) {
            PopupDateField dateField = new PopupDateField();
            dateField.setResolution(Resolution.SECOND);
            field = dateField;
        } else if (propertyType == Boolean.TYPE || propertyType == Boolean.class) {
            field = new CheckBox();
        } else {
            TextField textField = new TextField();
            textField.setWidth("100%");
            textField.setNullRepresentation("");
            textField.setNullSettingAllowed(false);
            FieldType fieldType = this.jfield.getFieldType();
            textField.setConverter(this.buildSimpleFieldConverter(fieldType));
            field = textField;
        }
        if (this.allowNull) {
            field = this.addNullButton((Field)field);
        }
        return field;
    }

    private <T extends Enum> EnumComboBox createEnumComboBox(Class<T> enumType) {
        return new EnumComboBox(enumType, this.allowNull);
    }

    private <T> SimpleFieldConverter<T> buildSimpleFieldConverter(FieldType<T> fieldType) {
        return new SimpleFieldConverter(fieldType);
    }

    private <T> NullableField<T> addNullButton(Field<T> field) {
        return new NullableField(field);
    }
}

