/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.caching;

import com.google.common.base.Preconditions;
import org.jsimpledb.kv.caching.CachingConfig;

public abstract class AbstractCachingConfig
implements CachingConfig {
    int maxRanges = 256;
    long maxRangeBytes = 0xA00000L;
    long maxTotalBytes = 0x6400000L;
    boolean readAhead = true;

    protected AbstractCachingConfig() {
    }

    @Override
    public synchronized long getMaxRangeBytes() {
        return this.maxRangeBytes;
    }

    @Override
    public synchronized void setMaxRangeBytes(long maxRangeBytes) {
        Preconditions.checkArgument((this.maxRanges > 0 ? 1 : 0) != 0, (Object)"maxRangeBytes <= 0");
        this.maxRangeBytes = maxRangeBytes;
    }

    @Override
    public synchronized long getMaxTotalBytes() {
        return this.maxTotalBytes;
    }

    @Override
    public synchronized void setMaxTotalBytes(long maxTotalBytes) {
        Preconditions.checkArgument((maxTotalBytes > 0L ? 1 : 0) != 0, (Object)"maxTotalBytes <= 0");
        this.maxTotalBytes = maxTotalBytes;
    }

    @Override
    public synchronized int getMaxRanges() {
        return this.maxRanges;
    }

    @Override
    public synchronized void setMaxRanges(int maxRanges) {
        Preconditions.checkArgument((maxRanges > 0 ? 1 : 0) != 0, (Object)"maxRanges <= 0");
        this.maxRanges = maxRanges;
    }

    @Override
    public synchronized boolean isReadAhead() {
        return this.readAhead;
    }

    @Override
    public synchronized void setReadAhead(boolean readAhead) {
        this.readAhead = readAhead;
    }
}

