/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.caching;

class RingEntry<T> {
    private final T owner;
    private RingEntry<T> prev;
    private RingEntry<T> next;

    RingEntry(T owner) {
        this.owner = owner;
        this.prev = this;
        this.next = this;
    }

    public T getOwner() {
        return this.owner;
    }

    public RingEntry<T> next() {
        assert (this.checkValid());
        return this.next;
    }

    public RingEntry<T> prev() {
        assert (this.checkValid());
        return this.prev;
    }

    public boolean isAttached() {
        assert (this.checkValid());
        return this.prev != this;
    }

    public void detach() {
        assert (this.checkValid());
        if (this.next == this) {
            assert (this.prev == this);
            return;
        }
        this.prev.next = this.next;
        this.next.prev = this.prev;
        this.prev = this.next = this;
    }

    public void attachAfter(RingEntry<T> that) {
        assert (this.checkValid());
        assert (super.checkValid());
        if (this == that) {
            return;
        }
        if (this.next != this) {
            this.prev.next = this.next;
            this.next.prev = this.prev;
        } else assert (this.prev == this);
        this.next = that.next;
        this.prev = that;
        this.next.prev = that.next = this;
    }

    private boolean checkValid() {
        assert (this.prev == this == (this.next == this));
        assert (this.prev.next == this);
        assert (this.next.prev == this);
        int count = 0;
        RingEntry<T> that = this;
        while ((that = that.next) != this) {
            assert (count < 100000) : "non-ring topology";
            ++count;
        }
        return true;
    }
}

