/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.util;

import com.google.common.collect.Iterators;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;

public abstract class AbstractIterationSet<E>
extends AbstractSet<E> {
    protected AbstractIterationSet() {
    }

    @Override
    public int size() {
        return Iterators.size(this.iterator());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Set)) {
            return false;
        }
        Set that = (Set)obj;
        Iterator i1 = this.iterator();
        Iterator i2 = that.iterator();
        while (true) {
            boolean hasNext1 = i1.hasNext();
            boolean hasNext2 = i2.hasNext();
            if (!hasNext1 && !hasNext2) {
                return true;
            }
            if (!hasNext1 || !hasNext2) {
                return false;
            }
            if (!this.contains(i2.next())) {
                return false;
            }
            i1.next();
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    @Override
    public Object[] toArray() {
        ArrayList list = new ArrayList();
        for (Object elem : this) {
            list.add(elem);
        }
        return list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        ArrayList list = new ArrayList();
        for (Object elem : this) {
            list.add(elem);
        }
        return list.toArray(array);
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliteratorUnknownSize(this.iterator(), 1);
    }
}

