/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.util;

import com.google.common.base.Preconditions;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import org.jsimpledb.util.BoundType;
import org.jsimpledb.util.Bounds;
import org.jsimpledb.util.NavigableSets;

public abstract class AbstractNavigableMap<K, V>
extends AbstractMap<K, V>
implements NavigableMap<K, V> {
    protected final Bounds<K> bounds;

    protected AbstractNavigableMap() {
        this(new Bounds());
    }

    protected AbstractNavigableMap(Bounds<K> bounds) {
        Preconditions.checkArgument((bounds != null ? 1 : 0) != 0, (Object)"null bounds");
        this.bounds = bounds;
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException("read-only map");
    }

    @Override
    public boolean isEmpty() {
        return this.navigableKeySet().isEmpty();
    }

    @Override
    public boolean containsKey(Object obj) {
        return this.navigableKeySet().contains(obj);
    }

    @Override
    public K firstKey() {
        return this.navigableKeySet().iterator().next();
    }

    @Override
    public K lastKey() {
        return this.descendingMap().firstKey();
    }

    @Override
    public NavigableSet<K> keySet() {
        return this.navigableKeySet();
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K maxKey) {
        return this.searchBelow(maxKey, false);
    }

    @Override
    public Map.Entry<K, V> floorEntry(K maxKey) {
        return this.searchBelow(maxKey, true);
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K minKey) {
        return this.searchAbove(minKey, true);
    }

    @Override
    public Map.Entry<K, V> higherEntry(K minKey) {
        return this.searchAbove(minKey, false);
    }

    @Override
    public K lowerKey(K maxKey) {
        Map.Entry<K, V> entry = this.lowerEntry(maxKey);
        return entry != null ? (K)entry.getKey() : null;
    }

    @Override
    public K floorKey(K maxKey) {
        Map.Entry<K, V> entry = this.floorEntry(maxKey);
        return entry != null ? (K)entry.getKey() : null;
    }

    @Override
    public K ceilingKey(K minKey) {
        Map.Entry<K, V> entry = this.ceilingEntry(minKey);
        return entry != null ? (K)entry.getKey() : null;
    }

    @Override
    public K higherKey(K minKey) {
        Map.Entry<K, V> entry = this.higherEntry(minKey);
        return entry != null ? (K)entry.getKey() : null;
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        try {
            return this.entrySet().iterator().next();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        return this.descendingMap().firstEntry();
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        Iterator i = this.entrySet().iterator();
        if (!i.hasNext()) {
            return null;
        }
        Map.Entry entry = i.next();
        i.remove();
        return entry;
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        return this.descendingMap().pollFirstEntry();
    }

    @Override
    public NavigableMap<K, V> descendingMap() {
        return this.createSubMap(true, this.bounds.reverse());
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return this.navigableKeySet().descendingSet();
    }

    @Override
    public NavigableMap<K, V> subMap(K minKey, K maxKey) {
        return this.subMap(minKey, true, maxKey, false);
    }

    @Override
    public NavigableMap<K, V> headMap(K maxKey) {
        return this.headMap(maxKey, false);
    }

    @Override
    public NavigableMap<K, V> tailMap(K minKey) {
        return this.tailMap(minKey, true);
    }

    @Override
    public NavigableMap<K, V> headMap(K newMaxKey, boolean inclusive) {
        Bounds<K> newBounds = this.bounds.withUpperBound(newMaxKey, BoundType.of(inclusive));
        if (!this.bounds.isWithinBounds(this.comparator(), newBounds)) {
            throw new IllegalArgumentException("upper bound " + newMaxKey + " is out of bounds: " + this.bounds);
        }
        return this.createSubMap(false, newBounds);
    }

    @Override
    public NavigableMap<K, V> tailMap(K newMinKey, boolean inclusive) {
        Bounds<K> newBounds = this.bounds.withLowerBound(newMinKey, BoundType.of(inclusive));
        if (!this.bounds.isWithinBounds(this.comparator(), newBounds)) {
            throw new IllegalArgumentException("lower bound " + newMinKey + " is out of bounds: " + this.bounds);
        }
        return this.createSubMap(false, newBounds);
    }

    @Override
    public NavigableMap<K, V> subMap(K newMinKey, boolean minInclusive, K newMaxKey, boolean maxInclusive) {
        Bounds<K> newBounds = new Bounds<K>(newMinKey, BoundType.of(minInclusive), newMaxKey, BoundType.of(maxInclusive));
        if (!this.bounds.isWithinBounds(this.comparator(), newBounds)) {
            throw new IllegalArgumentException("new bound(s) " + newBounds + " are out of bounds: " + this.bounds);
        }
        return this.createSubMap(false, newBounds);
    }

    protected Map.Entry<K, V> searchBelow(K maxKey, boolean inclusive) {
        if (!this.isWithinLowerBound(maxKey)) {
            return null;
        }
        AbstractNavigableMap subMap = this.isWithinUpperBound(maxKey) ? this.headMap(maxKey, inclusive) : this;
        try {
            return subMap.lastEntry();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    protected Map.Entry<K, V> searchAbove(K minKey, boolean inclusive) {
        if (!this.isWithinUpperBound(minKey)) {
            return null;
        }
        AbstractNavigableMap subMap = this.isWithinLowerBound(minKey) ? this.tailMap(minKey, inclusive) : this;
        try {
            return subMap.firstEntry();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    protected Comparator<? super K> getComparator(boolean reversed) {
        return NavigableSets.getComparator(this.comparator(), reversed);
    }

    protected abstract NavigableMap<K, V> createSubMap(boolean var1, Bounds<K> var2);

    protected boolean isWithinLowerBound(K key) {
        return this.bounds.isWithinLowerBound(this.comparator(), key);
    }

    protected boolean isWithinUpperBound(K key) {
        return this.bounds.isWithinUpperBound(this.comparator(), key);
    }
}

