/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.util;

import com.google.common.base.Preconditions;
import org.jsimpledb.util.ByteWriter;

public class ByteReader {
    final byte[] buf;
    final int max;
    int off;

    public ByteReader(byte[] buf) {
        this.buf = buf;
        this.max = buf.length;
        this.off = 0;
    }

    public ByteReader(byte[] buf, int off) {
        this(buf, off, buf.length - off);
    }

    public ByteReader(byte[] buf, int off, int len) {
        if (off < 0 || len < 0 || off > buf.length || off + len < 0 || off + len > buf.length) {
            throw new IndexOutOfBoundsException("buf.length = " + buf.length + ", off = " + off + ", len = " + len);
        }
        this.buf = buf;
        this.max = off + len;
        this.off = off;
    }

    public ByteReader(ByteWriter writer) {
        this(writer.buf, 0, writer.len);
    }

    public ByteReader(ByteWriter writer, int mark) {
        this(writer.buf, mark, writer.len - mark);
    }

    public int peek() {
        if (this.off == this.max) {
            throw new IndexOutOfBoundsException();
        }
        return this.buf[this.off] & 0xFF;
    }

    public int readByte() {
        if (this.off == this.max) {
            throw new IndexOutOfBoundsException();
        }
        return this.buf[this.off++] & 0xFF;
    }

    public void unread() {
        if (this.off == 0) {
            throw new IndexOutOfBoundsException();
        }
        --this.off;
    }

    public void unread(int len) {
        if (this.off - len < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.off -= len;
    }

    public byte[] readBytes(int len) {
        Preconditions.checkArgument((len >= 0 ? 1 : 0) != 0, (Object)"len < 0");
        if (this.off + len > this.max) {
            throw new IndexOutOfBoundsException();
        }
        byte[] result = new byte[len];
        System.arraycopy(this.buf, this.off, result, 0, len);
        this.off += len;
        return result;
    }

    public int remain() {
        return this.max - this.off;
    }

    public void skip(int num) {
        if (num < 0 || this.off + num > this.max) {
            throw new IndexOutOfBoundsException();
        }
        this.off += num;
    }

    public int getOffset() {
        return this.off;
    }

    public int getMax() {
        return this.max;
    }

    public byte[] getBytes(int off, int len) {
        if (off < 0 || len < 0 || off + len > this.max) {
            throw new IndexOutOfBoundsException();
        }
        byte[] data = new byte[len];
        System.arraycopy(this.buf, off, data, 0, len);
        return data;
    }

    public byte[] getBytes(int off) {
        return this.getBytes(off, this.max - off);
    }

    public byte[] getBytes() {
        return this.max == this.buf.length ? (byte[])this.buf.clone() : this.getBytes(0);
    }

    public int mark() {
        return this.off;
    }

    public void reset(int mark) {
        if (mark < 0 || mark > this.max) {
            throw new IndexOutOfBoundsException();
        }
        this.off = mark;
    }
}

