/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.util;

import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.Objects;

class ConvertedComparator<E, W>
implements Comparator<E> {
    private final Comparator<? super W> comparator;
    private final Converter<E, W> converter;

    ConvertedComparator(Comparator<? super W> comparator, Converter<E, W> converter) {
        Preconditions.checkArgument((converter != null ? 1 : 0) != 0, (Object)"null converter");
        this.comparator = comparator;
        this.converter = converter;
    }

    public Comparator<? super W> getWrappedComparator() {
        return this.comparator;
    }

    public Converter<E, W> getConverter() {
        return this.converter;
    }

    @Override
    public int compare(E obj1, E obj2) {
        Object wobj1 = this.converter.convert(obj1);
        Object wobj2 = this.converter.convert(obj2);
        return this.comparator != null ? this.comparator.compare(wobj1, wobj2) : ((Comparable)wobj1).compareTo(wobj2);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ConvertedComparator that = (ConvertedComparator)obj;
        return Objects.equals(this.comparator, that.comparator) && this.converter.equals(that.converter);
    }

    public int hashCode() {
        return Objects.hashCode(this.comparator) ^ this.converter.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[converter=" + this.converter + ",comparator=" + this.comparator + "]";
    }
}

