/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.util;

import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jsimpledb.util.AbstractNavigableMap;
import org.jsimpledb.util.BoundType;
import org.jsimpledb.util.Bounds;
import org.jsimpledb.util.ConvertedComparator;
import org.jsimpledb.util.ConvertedEntrySet;
import org.jsimpledb.util.ConvertedNavigableSet;

public class ConvertedNavigableMap<K, V, WK, WV>
extends AbstractNavigableMap<K, V> {
    private final NavigableMap<WK, WV> map;
    private final Converter<K, WK> keyConverter;
    private final Converter<V, WV> valueConverter;

    public ConvertedNavigableMap(NavigableMap<WK, WV> map, Converter<K, WK> keyConverter, Converter<V, WV> valueConverter) {
        this(map, keyConverter, valueConverter, new Bounds());
    }

    ConvertedNavigableMap(NavigableMap<WK, WV> map, Converter<K, WK> keyConverter, Converter<V, WV> valueConverter, Bounds<K> bounds) {
        super(bounds);
        Preconditions.checkArgument((map != null ? 1 : 0) != 0, (Object)"null map");
        Preconditions.checkArgument((keyConverter != null ? 1 : 0) != 0, (Object)"null keyConverter");
        Preconditions.checkArgument((valueConverter != null ? 1 : 0) != 0, (Object)"null valueConverter");
        this.map = map;
        this.keyConverter = keyConverter;
        this.valueConverter = valueConverter;
    }

    public Converter<K, WK> getKeyConverter() {
        return this.keyConverter;
    }

    public Converter<V, WV> getValueConverter() {
        return this.valueConverter;
    }

    @Override
    public Comparator<? super K> comparator() {
        return new ConvertedComparator(this.map.comparator(), this.keyConverter);
    }

    @Override
    public V get(Object key) {
        Object wvalue;
        Object wkey = null;
        if (key != null) {
            try {
                wkey = this.keyConverter.convert(key);
            }
            catch (ClassCastException e) {
                return null;
            }
        }
        return (V)((wvalue = this.map.get(wkey)) != null ? this.valueConverter.reverse().convert(wvalue) : null);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new ConvertedEntrySet<K, V, WK, WV>(this.map, this.keyConverter, this.valueConverter);
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        return new ConvertedNavigableSet<K, WK>(this.map.navigableKeySet(), this.keyConverter);
    }

    @Override
    public V put(K key, V value) {
        Object wkey = key != null ? this.keyConverter.convert(key) : null;
        Object wvalue = value != null ? this.valueConverter.convert(value) : null;
        Object wprev = this.map.put(wkey, wvalue);
        return (V)(wprev != null ? this.valueConverter.reverse().convert(wprev) : null);
    }

    @Override
    public V remove(Object key) {
        Object wvalue;
        Object wkey = null;
        if (key != null) {
            try {
                wkey = this.keyConverter.convert(key);
            }
            catch (ClassCastException e) {
                return null;
            }
        }
        return (V)((wvalue = this.map.remove(wkey)) != null ? this.valueConverter.reverse().convert(wvalue) : null);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    protected Map.Entry<K, V> searchBelow(K maxKey, boolean inclusive) {
        try {
            return super.searchBelow(maxKey, inclusive);
        }
        catch (IllegalArgumentException e) {
            Map.Entry lastEntry;
            try {
                lastEntry = this.lastEntry();
            }
            catch (NoSuchElementException e2) {
                return null;
            }
            return this.getComparator(false).compare(maxKey, lastEntry.getKey()) > 0 ? lastEntry : null;
        }
    }

    @Override
    protected Map.Entry<K, V> searchAbove(K minKey, boolean inclusive) {
        try {
            return super.searchAbove(minKey, inclusive);
        }
        catch (IllegalArgumentException e) {
            Map.Entry firstEntry;
            try {
                firstEntry = this.firstEntry();
            }
            catch (NoSuchElementException e2) {
                return null;
            }
            return this.getComparator(false).compare(minKey, firstEntry.getKey()) < 0 ? firstEntry : null;
        }
    }

    @Override
    protected NavigableMap<K, V> createSubMap(boolean reverse, Bounds<K> newBounds) {
        NavigableMap<Object, WV> subMap;
        K lower = newBounds.getLowerBound();
        K upper = newBounds.getUpperBound();
        Object wlower = newBounds.getLowerBoundType() != BoundType.NONE && lower != null ? this.keyConverter.convert(lower) : null;
        Object wupper = newBounds.getUpperBoundType() != BoundType.NONE && upper != null ? this.keyConverter.convert(upper) : null;
        NavigableMap<WK, WV> navigableMap = subMap = reverse ? this.map.descendingMap() : this.map;
        if (newBounds.getLowerBoundType() != BoundType.NONE && newBounds.getUpperBoundType() != BoundType.NONE) {
            subMap = subMap.subMap(wlower, newBounds.getLowerBoundType().isInclusive(), wupper, newBounds.getUpperBoundType().isInclusive());
        } else if (newBounds.getLowerBoundType() != BoundType.NONE) {
            subMap = subMap.tailMap(wlower, newBounds.getLowerBoundType().isInclusive());
        } else if (newBounds.getUpperBoundType() != BoundType.NONE) {
            subMap = subMap.headMap(wupper, newBounds.getUpperBoundType().isInclusive());
        }
        return new ConvertedNavigableMap<K, V, WK, WV>(subMap, this.keyConverter, this.valueConverter, newBounds);
    }
}

