/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.util;

import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.jsimpledb.util.ConvertedComparator;

public class ConvertedSpliterator<E, W>
implements Spliterator<E> {
    private final Spliterator<W> inner;
    private final Converter<W, E> converter;

    public ConvertedSpliterator(Spliterator<W> inner, Converter<W, E> converter) {
        Preconditions.checkArgument((inner != null ? 1 : 0) != 0, (Object)"null inner");
        Preconditions.checkArgument((converter != null ? 1 : 0) != 0, (Object)"null converter");
        this.inner = inner;
        this.converter = converter;
    }

    public Spliterator<W> getWrappedSpliterator() {
        return this.inner;
    }

    public Converter<W, E> getConverter() {
        return this.converter;
    }

    @Override
    public int characteristics() {
        return this.inner.characteristics();
    }

    @Override
    public long estimateSize() {
        return this.inner.estimateSize();
    }

    @Override
    public void forEachRemaining(Consumer<? super E> consumer) {
        this.inner.forEachRemaining((? super T element) -> consumer.accept((E)this.converter.convert(element)));
    }

    @Override
    public Comparator<E> getComparator() {
        Comparator<W> comparator = this.inner.getComparator();
        return comparator != null ? new ConvertedComparator(comparator, this.converter.reverse()) : null;
    }

    @Override
    public long getExactSizeIfKnown() {
        return this.inner.getExactSizeIfKnown();
    }

    @Override
    public boolean hasCharacteristics(int characteristics) {
        return this.inner.hasCharacteristics(characteristics);
    }

    @Override
    public boolean tryAdvance(Consumer<? super E> action) {
        return this.inner.tryAdvance((? super T element) -> action.accept((E)this.converter.convert(element)));
    }

    @Override
    public Spliterator<E> trySplit() {
        Spliterator<W> split = this.inner.trySplit();
        return split != null ? new ConvertedSpliterator<E, W>(split, this.converter) : null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ConvertedSpliterator that = (ConvertedSpliterator)obj;
        return this.inner.equals(that.inner) && this.converter.equals(that.converter);
    }

    public int hashCode() {
        return this.inner.hashCode() ^ this.converter.hashCode();
    }
}

