/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import org.jsimpledb.util.AbstractMultiNavigableSet;
import org.jsimpledb.util.Bounds;

class DifferenceNavigableSet<E>
extends AbstractMultiNavigableSet<E> {
    DifferenceNavigableSet(NavigableSet<E> set1, NavigableSet<E> set2) {
        super(Lists.newArrayList((Object[])new NavigableSet[]{set1, set2}));
    }

    protected DifferenceNavigableSet(NavigableSet<E> set1, NavigableSet<E> set2, Comparator<? super E> comparator, Bounds<E> bounds) {
        super(Lists.newArrayList((Object[])new NavigableSet[]{set1, set2}), comparator, bounds);
    }

    @Override
    protected NavigableSet<E> createSubSet(boolean reverse, Bounds<E> newBounds, List<NavigableSet<E>> newList) {
        Comparator newComparator = this.getComparator(reverse);
        return new DifferenceNavigableSet<E>(newList.get(0), newList.get(1), newComparator, newBounds);
    }

    @Override
    public boolean contains(Object obj) {
        return ((NavigableSet)this.list.get(0)).contains(obj) && !((NavigableSet)this.list.get(1)).contains(obj);
    }

    @Override
    public Iterator<E> iterator() {
        return Iterators.filter(((NavigableSet)this.list.get(0)).iterator(), (Predicate)Predicates.not((Predicate)Predicates.in((Collection)((Collection)this.list.get(1)))));
    }
}

