/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.ByteWriter;

public final class LongEncoder {
    public static final int MAX_ENCODED_LENGTH = 9;
    public static final int MIN_SINGLE_BYTE_ENCODED = 9;
    public static final int MAX_SINGLE_BYTE_ENCODED = 246;
    public static final int ZERO_ADJUST = 127;
    public static final int MIN_SINGLE_BYTE_VALUE = -118;
    public static final int MAX_SINGLE_BYTE_VALUE = 119;
    public static final int NEGATIVE_ADJUST = 118;
    public static final int POSITIVE_ADJUST = -120;
    static final long[] CUTOFF_VALUES = new long[]{-72057594037928054L, -281474976710774L, -1099511627894L, -4294967414L, -16777334L, -65654L, -374L, -118L, 120L, 376L, 65656L, 16777336L, 4294967416L, 1099511627896L, 281474976710776L, 72057594037928056L};

    private LongEncoder() {
    }

    public static byte[] encode(long value) {
        ByteWriter writer = new ByteWriter(LongEncoder.encodeLength(value));
        LongEncoder.write(writer, value);
        return writer.getBytes();
    }

    public static long decode(byte[] data) {
        ByteReader reader = new ByteReader(data);
        long value = LongEncoder.read(reader);
        if (reader.remain() > 0) {
            throw new IllegalArgumentException("encoded value contains extra trailing garbage");
        }
        return value;
    }

    public static void write(ByteWriter writer, long value) {
        writer.makeRoom(9);
        writer.len += LongEncoder.encode(value, writer.buf, writer.len);
    }

    public static void write(OutputStream out, long value) throws IOException {
        byte[] array = new byte[9];
        int nbytes = LongEncoder.encode(value, array, 0);
        out.write(array, 0, nbytes);
    }

    public static void write(ByteBuffer buf, long value) {
        byte[] array = new byte[9];
        int nbytes = LongEncoder.encode(value, array, 0);
        buf.put(array, 0, nbytes);
    }

    public static long read(ByteReader reader) {
        try {
            int first = reader.readByte();
            if (first < 9) {
                if (first == 0) {
                    throw new IllegalArgumentException("invalid encoded value starting with 0x00");
                }
                long value = -1L;
                while (first++ < 9) {
                    value = value << 8 | (long)reader.readByte();
                }
                return value - 118L;
            }
            if (first > 246) {
                if (first == 255) {
                    throw new IllegalArgumentException("invalid encoded value starting with 0xff");
                }
                long value = 0L;
                while (first-- > 246) {
                    value = value << 8 | (long)reader.readByte();
                }
                return value - -120L;
            }
            return (byte)(first - 127);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("encoded value is truncated", e);
        }
    }

    public static long read(InputStream input) throws IOException {
        int first = input.read();
        if (first == -1) {
            throw new EOFException();
        }
        byte[] array = new byte[LongEncoder.decodeLength(first)];
        array[0] = (byte)first;
        for (int i = 1; i < array.length; ++i) {
            int next = input.read();
            if (next == -1) {
                throw new EOFException();
            }
            array[i] = (byte)next;
        }
        return LongEncoder.read(new ByteReader(array));
    }

    public static long read(ByteBuffer buf) {
        byte first = buf.get();
        byte[] array = new byte[LongEncoder.decodeLength(first)];
        array[0] = first;
        if (array.length > 1) {
            buf.get(array, 1, array.length - 1);
        }
        return LongEncoder.read(new ByteReader(array));
    }

    public static void skip(ByteReader reader) {
        int first = reader.readByte();
        if (first == 0 || first == 255) {
            throw new IllegalArgumentException("invalid encoded value starting with 0x" + Integer.toHexString(first));
        }
        reader.skip(LongEncoder.decodeLength(first) - 1);
    }

    public static int decodeLength(int first) {
        if ((first &= 0xFF) == 0 || first == 255) {
            throw new IllegalArgumentException("invalid encoded value starting with 0x" + Integer.toHexString(first));
        }
        if (first < 9) {
            return 10 - first;
        }
        if (first > 246) {
            return 1 + first - 246;
        }
        return 1;
    }

    public static int encodeLength(long value) {
        int index = Arrays.binarySearch(CUTOFF_VALUES, value);
        if (index < 0) {
            index = ~index - 1;
        }
        return index < 8 ? 8 - index : index - 6;
    }

    private static int encode(long value, byte[] buf, int off) {
        int len = 1;
        if (value < -118L) {
            value += 118L;
            long mask = 0xFFFFFFFFFFFFFFL;
            int shift = 56;
            while (shift != 0) {
                if ((value | mask) != -1L) {
                    buf[off + len++] = (byte)(value >> shift);
                }
                shift -= 8;
                mask >>= 8;
            }
            buf[off] = (byte)(9 - len);
        } else if (value > 119L) {
            value += -120L;
            long mask = -72057594037927936L;
            int shift = 56;
            while (shift != 0) {
                if ((value & mask) != 0L) {
                    buf[off + len++] = (byte)(value >> shift);
                }
                shift -= 8;
                mask >>= 8;
            }
            buf[off] = (byte)(246 + len);
        } else {
            buf[off] = (byte)(value + 127L);
            return 1;
        }
        buf[off + len++] = (byte)value;
        return len;
    }

    public static void main(String[] args) {
        for (String arg : args) {
            byte[] bytes;
            block6: {
                bytes = null;
                try {
                    bytes = ByteUtil.parse(arg);
                }
                catch (IllegalArgumentException e) {
                    if (!arg.startsWith("0x")) break block6;
                    bytes = ByteUtil.parse(arg.substring(2));
                }
            }
            if (bytes != null) {
                long value = LongEncoder.decode(bytes);
                System.out.println("0x" + ByteUtil.toString(bytes) + " decodes to " + value + " (" + String.format("0x%016x", value) + ")");
            }
            Long value = null;
            try {
                value = Long.parseLong(arg);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (value == null) continue;
            ByteWriter writer = new ByteWriter();
            LongEncoder.write(writer, (long)value);
            System.out.println(value + " (" + String.format("0x%016x", value) + ") encodes to " + ByteUtil.toString(writer.getBytes()));
        }
    }
}

