/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.util;

import com.google.common.base.Preconditions;

public final class ThrowableUtil {
    private ThrowableUtil() {
    }

    public static <T extends Throwable> T maskException(Throwable t) throws T {
        throw t;
    }

    public static void prependCurrentStackTrace(Throwable t) {
        t.setStackTrace(ThrowableUtil.appendStackFrames(t, new Throwable().getStackTrace()));
    }

    public static StackTraceElement[] appendStackFrames(Throwable t, StackTraceElement[] outerFrames) {
        Preconditions.checkArgument((t != null ? 1 : 0) != 0, (Object)"null t");
        Preconditions.checkArgument((outerFrames != null ? 1 : 0) != 0, (Object)"null outerFrames");
        StackTraceElement[] innerFrames = t.getStackTrace();
        StackTraceElement[] frames = new StackTraceElement[innerFrames.length + outerFrames.length];
        System.arraycopy(innerFrames, 0, frames, 0, innerFrames.length);
        for (int i = 0; i < outerFrames.length; ++i) {
            frames[innerFrames.length + i] = outerFrames[i];
        }
        return frames;
    }
}

